/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.spaces.ui.services;

import com.google.common.base.Strings;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.security.Authenticate;
import org.fenixedu.commons.i18n.I18N;
import org.fenixedu.spaces.core.service.NotificationService;
import org.fenixedu.spaces.domain.Space;
import org.fenixedu.spaces.domain.SpaceDomainException;
import org.fenixedu.spaces.domain.occupation.Occupation;
import org.fenixedu.spaces.domain.occupation.SharedOccupation;
import org.fenixedu.spaces.domain.occupation.config.ExplicitConfigWithSettings;
import org.fenixedu.spaces.domain.occupation.config.OccupationConfig;
import org.fenixedu.spaces.domain.occupation.requests.OccupationRequest;
import org.fenixedu.spaces.domain.occupation.requests.OccupationRequestState;
import org.fenixedu.spaces.ui.OccupationRequestBean;
import org.fenixedu.spaces.ui.services.OccupationService$callable$addComment;
import org.fenixedu.spaces.ui.services.OccupationService$callable$closeRequest;
import org.fenixedu.spaces.ui.services.OccupationService$callable$createOccupation;
import org.fenixedu.spaces.ui.services.OccupationService$callable$createRequest;
import org.fenixedu.spaces.ui.services.OccupationService$callable$delete;
import org.fenixedu.spaces.ui.services.OccupationService$callable$editOccupation;
import org.fenixedu.spaces.ui.services.OccupationService$callable$openRequest;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadableInterval;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.support.PagedListHolder;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Service;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.DomainObject;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

@Service
public class OccupationService {
    private final JsonParser jsonParser;
    private final DateTimeFormatter datetimeFormatter;
    @Autowired
    MessageSource messageSource;
    @Autowired(required=false)
    NotificationService notificationService;
    public String[] colors = new String[]{"#FF9999", "#FFCC99", "#FFFF99", "#CCFF99", "#99FF99", "#99FFFF"};
    public static final Advice advice$createRequest = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$addComment = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$openRequest = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$closeRequest = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$createOccupation = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$editOccupation = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    public OccupationService() {
        this.jsonParser = new JsonParser();
        this.datetimeFormatter = DateTimeFormat.forPattern((String)"dd/MM/yyyy HH:mm");
    }

    public OccupationRequest createRequest(OccupationRequestBean occupationRequestBean) {
        return (OccupationRequest)((Object)advice$createRequest.perform((Callable)new OccupationService$callable$createRequest(this, occupationRequestBean)));
    }

    static /* synthetic */ OccupationRequest advised$createRequest(OccupationService this_, OccupationRequestBean bean2) {
        return new OccupationRequest(bean2.getRequestor(), bean2.getSubject(), bean2.getCampus(), bean2.getDescription());
    }

    public List<OccupationRequest> search(String requestIdOrUsername) {
        try {
            return Stream.of(OccupationRequest.getRequestById(Integer.parseInt(requestIdOrUsername))).collect(Collectors.toList());
        }
        catch (NumberFormatException nfe) {
            User user = User.findByUsername((String)requestIdOrUsername);
            if (user == null) {
                return new ArrayList<OccupationRequest>();
            }
            return this.all(user);
        }
    }

    @Deprecated
    public Set<Space> getAllCampus() {
        return Space.getTopLevelSpaces();
    }

    public Set<Space> getTopLevelSpaces() {
        return Space.getTopLevelSpaces();
    }

    public List<OccupationRequest> all() {
        return Bennu.getInstance().getOccupationRequestSet().stream().sorted(OccupationRequest.COMPARATOR_BY_INSTANT.reversed()).collect(Collectors.toList());
    }

    public List<OccupationRequest> all(User user) {
        return this.all().stream().filter(o -> user != null && user.equals((Object)o.getRequestor())).collect(Collectors.toList());
    }

    public List<OccupationRequest> all(OccupationRequestState state, Space campus) {
        return OccupationRequest.getRequestsByTypeOrderByDate(state, campus);
    }

    public List<OccupationRequest> getRequestsToProcess(User user, Space campus) {
        return user.getOcuppationRequestsToProcessSet().stream().filter(r -> !r.getCurrentState().equals((Object)OccupationRequestState.RESOLVED) && (r.getCampus() == null || r.getCampus().equals(campus))).sorted(OccupationRequest.COMPARATOR_BY_INSTANT.reversed()).collect(Collectors.toList());
    }

    public void addComment(OccupationRequest occupationRequest, String string, OccupationRequestState occupationRequestState) {
        Object object = advice$addComment.perform((Callable)new OccupationService$callable$addComment(this, occupationRequest, string, occupationRequestState));
    }

    static /* synthetic */ void advised$addComment(OccupationService this_, OccupationRequest request, String description, OccupationRequestState newState) {
        OccupationRequestState oldState = request.getCurrentState();
        Boolean reOpenRequest = oldState != OccupationRequestState.OPEN && newState == OccupationRequestState.OPEN;
        Boolean resolveRequest = oldState != OccupationRequestState.RESOLVED && newState == OccupationRequestState.RESOLVED;
        this_.addComment(request, description, reOpenRequest, resolveRequest);
    }

    private void addComment(OccupationRequest request, String description, Boolean reOpenRequest, Boolean resolveRequest) {
        DateTime now = new DateTime();
        User requestor = Authenticate.getUser();
        if (reOpenRequest.booleanValue()) {
            request.createNewTeacherCommentAndOpenRequest(description, requestor, now);
        } else if (resolveRequest.booleanValue()) {
            request.createNewEmployeeCommentAndCloseRequest(description, requestor, now);
            if (this.notificationService != null) {
                this.notificationService.notify(request);
            }
        } else {
            request.createNewTeacherOrEmployeeComment(description, requestor, now);
        }
    }

    public void openRequest(OccupationRequest occupationRequest, User user) {
        Object object = advice$openRequest.perform((Callable)new OccupationService$callable$openRequest(this, occupationRequest, user));
    }

    static /* synthetic */ void advised$openRequest(OccupationService this_, OccupationRequest request, User owner) {
        request.openRequestAndAssociateOwnerOnlyForEmployess(new DateTime(), owner);
    }

    public void closeRequest(OccupationRequest occupationRequest, User user) {
        Object object = advice$closeRequest.perform((Callable)new OccupationService$callable$closeRequest(this, occupationRequest, user));
    }

    static /* synthetic */ void advised$closeRequest(OccupationService this_, OccupationRequest request, User owner) {
        request.closeRequestAndAssociateOwnerOnlyForEmployees(new DateTime(), owner);
        if (this_.notificationService != null) {
            this_.notificationService.notify(request);
        }
    }

    public List<Space> searchFreeSpaces(List<Interval> intervals, User user) {
        return Space.getSpaces().filter(space -> space.getClassification().isAllocatable()).filter(space -> space.isFree(intervals) && space.isOccupationMember(user)).sorted((o1, o2) -> o1.getPresentationName().toLowerCase().compareTo(o2.getPresentationName().toLowerCase())).collect(Collectors.toList());
    }

    public void createOccupation(String string, String string2, String string3, String string4, String string5, String string6, OccupationRequest occupationRequest, User user) throws Exception {
        Object object = advice$createOccupation.perform((Callable)new OccupationService$callable$createOccupation(this, string, string2, string3, string4, string5, string6, occupationRequest, user));
    }

    static /* synthetic */ void advised$createOccupation(OccupationService this_, String emails, String subject, String description, String selectedSpaces, String config, String events, OccupationRequest request, User user) throws Exception {
        Set<Space> selectedSpaceSet = this_.selectSpaces(selectedSpaces, user);
        List<Interval> intervals = this_.selectEvents(events);
        Occupation occupation = new Occupation(emails, subject, description, this_.parseConfig(config, intervals));
        for (Space space : selectedSpaceSet) {
            if (!space.isFree(intervals)) {
                throw new Exception(this_.messageSource.getMessage("error.occupations.rooms.is.not.free", new Object[0], I18N.getLocale()));
            }
            occupation.addSpace(space);
        }
        if (request != null) {
            request.addOccupation(occupation);
        }
        if (this_.notificationService != null) {
            this_.notificationService.sendEmail(emails, subject, description);
        }
    }

    private OccupationConfig parseConfig(String config, List<Interval> intervals) {
        JsonObject json = this.jsonParser.parse(config).getAsJsonObject();
        DateTime start = DateTime.parse((String)json.get("start").getAsString(), (DateTimeFormatter)this.datetimeFormatter);
        DateTime end = DateTime.parse((String)json.get("end").getAsString(), (DateTimeFormatter)this.datetimeFormatter);
        String jsonFrequency = json.get("frequency").getAsString();
        Boolean allDay = json.get("isAllDay").getAsBoolean();
        Integer repeatsEvery = null;
        ArrayList<Integer> weekdays = null;
        ExplicitConfigWithSettings.MonthlyType monthlyType = null;
        ExplicitConfigWithSettings.Frequency frequency = null;
        switch (jsonFrequency) {
            case "n": {
                frequency = ExplicitConfigWithSettings.Frequency.NEVER;
                break;
            }
            case "d": {
                frequency = ExplicitConfigWithSettings.Frequency.DAILY;
                repeatsEvery = json.get("repeatsevery").getAsInt();
                break;
            }
            case "w": {
                frequency = ExplicitConfigWithSettings.Frequency.WEEKLY;
                repeatsEvery = json.get("repeatsevery").getAsInt();
                weekdays = new ArrayList<Integer>();
                for (JsonElement day : json.get("weekdays").getAsJsonArray()) {
                    weekdays.add(day.getAsInt());
                }
                break;
            }
            case "m": {
                frequency = ExplicitConfigWithSettings.Frequency.MONTHLY;
                repeatsEvery = json.get("repeatsevery").getAsInt();
                monthlyType = json.get("monthlyType").getAsString().equals("dayofmonth") ? ExplicitConfigWithSettings.MonthlyType.DAY_OF_MONTH : ExplicitConfigWithSettings.MonthlyType.DAY_OF_WEEK;
                break;
            }
            case "y": {
                frequency = ExplicitConfigWithSettings.Frequency.YEARLY;
                repeatsEvery = json.get("repeatsevery").getAsInt();
            }
        }
        return new ExplicitConfigWithSettings(start, end, allDay, repeatsEvery, frequency, weekdays, monthlyType, intervals);
    }

    private DateTime selectDate(JsonElement jsonElement, String memberName) {
        String timestamp = jsonElement.getAsJsonObject().get(memberName).getAsString();
        return new DateTime(Long.parseLong(timestamp) * 1000L);
    }

    private List<Interval> selectEvents(String events) {
        ArrayList<Interval> intervals = new ArrayList<Interval>();
        JsonArray eventsJson = this.jsonParser.parse(events).getAsJsonArray();
        for (JsonElement eventElement : eventsJson) {
            DateTime start = this.selectDate(eventElement, "start");
            DateTime end = this.selectDate(eventElement, "end");
            intervals.add(new Interval((ReadableInstant)start, (ReadableInstant)end));
        }
        return intervals;
    }

    private Set<Space> selectSpaces(String selectedSpaces, User user) {
        HashSet<Space> selectedSpaceSet = new HashSet<Space>();
        JsonArray spacesJson = this.jsonParser.parse(selectedSpaces).getAsJsonArray();
        for (JsonElement spaceJson : spacesJson) {
            String spaceId = spaceJson.getAsString();
            Space space = (Space)FenixFramework.getDomainObject((String)spaceId);
            if (!FenixFramework.isDomainObjectValid((DomainObject)space)) continue;
            if (!space.isOccupationMember(user)) {
                throw new SpaceDomainException("unauthorized.selected.space", space.getName());
            }
            selectedSpaceSet.add(space);
        }
        return selectedSpaceSet;
    }

    public List<Occupation> getOccupations(Integer month, Integer year, User user, String spaceName) {
        String spaceNameForSearch = spaceName == null ? null : spaceName.toLowerCase();
        DateTime start = new DateTime(year.intValue(), month.intValue(), 1, 0, 0);
        Interval interval = new Interval((ReadableInstant)start, (ReadableInstant)start.plusMonths(1));
        Predicate<Occupation> userAndSpaceNamePredicate = o -> o.getSpaces().stream().filter(s -> s.isOccupationMember(user)).filter(s -> this.matches((Space)s, spaceNameForSearch)).findAny().isPresent();
        return Bennu.getInstance().getOccupationSet().stream().filter(o -> ((Object)o).getClass().equals(Occupation.class)).filter(userAndSpaceNamePredicate).filter(o -> o.overlaps(interval)).sorted((o1, o2) -> o2.getStart().compareTo((ReadableInstant)o1.getStart())).collect(Collectors.toList());
    }

    private boolean matches(Space space, String spaceName) {
        return spaceName == null || spaceName.isEmpty() || space.getName().toLowerCase().indexOf(spaceName) >= 0;
    }

    public String exportConfig(Occupation occupation) {
        ExplicitConfigWithSettings config = (ExplicitConfigWithSettings)occupation.getConfig();
        JsonObject jsonConfig = new JsonObject();
        jsonConfig.addProperty("start", config.getStart().toString(this.datetimeFormatter));
        jsonConfig.addProperty("end", config.getEnd().toString(this.datetimeFormatter));
        String jsonFrequency = Character.toString(config.getFrequency().name().toLowerCase().charAt(0));
        jsonConfig.addProperty("frequency", jsonFrequency);
        jsonConfig.addProperty("isAllDay", Boolean.valueOf(config.getAllDay() != null && config.getAllDay() != false));
        switch (jsonFrequency) {
            case "d": {
                jsonConfig.addProperty("repeatsevery", (Number)config.getRepeatsevery());
                break;
            }
            case "w": {
                jsonConfig.addProperty("repeatsevery", (Number)config.getRepeatsevery());
                jsonConfig.add("weekdays", new Gson().toJsonTree(config.getWeekdays()));
                break;
            }
            case "m": {
                jsonConfig.addProperty("repeatsevery", (Number)config.getRepeatsevery());
                jsonConfig.addProperty("monthlyType", config.getMonthlyType().equals((Object)ExplicitConfigWithSettings.MonthlyType.DAY_OF_MONTH) ? "dayofmonth" : "dayofweek");
                break;
            }
            case "y": {
                jsonConfig.addProperty("repeatsevery", (Number)config.getRepeatsevery());
            }
        }
        return jsonConfig.toString();
    }

    public String exportEvents(Occupation occupation) {
        JsonArray events = new JsonArray();
        for (Interval i : occupation.getIntervals()) {
            JsonObject event = new JsonObject();
            event.addProperty("start", (Number)(i.getStartMillis() / 1000L));
            event.addProperty("end", (Number)(i.getEndMillis() / 1000L));
            events.add((JsonElement)event);
        }
        return events.toString();
    }

    public List<Space> getFreeAndSelectedSpaces(Occupation occupation, User user) {
        List<Space> spaces = this.searchFreeSpaces(occupation.getIntervals(), user);
        spaces.addAll(occupation.getSpaces());
        return spaces;
    }

    public void editOccupation(Occupation occupation, String string, String string2, String string3, String string4, User user) throws Exception {
        Object object = advice$editOccupation.perform((Callable)new OccupationService$callable$editOccupation(this, occupation, string, string2, string3, string4, user));
    }

    static /* synthetic */ void advised$editOccupation(OccupationService this_, Occupation occupation, String emails, String subject, String description, String selectedSpaces, User user) throws Exception {
        if (!this_.canManageOccupation(occupation, user)) {
            throw new SpaceDomainException("unauthorized.edit.occupation", new String[0]);
        }
        occupation.setEmails(emails);
        occupation.setSubject(subject);
        occupation.setDescription(description);
        Set<Space> selectedSpaceSet = this_.selectSpaces(selectedSpaces, user);
        occupation.getSpaces().stream().forEach(s -> occupation.removeSpace((Space)s));
        for (Space space : selectedSpaceSet) {
            if (!space.isFree(occupation.getIntervals())) {
                throw new Exception(this_.messageSource.getMessage("error.occupations.rooms.is.not.free", new Object[0], I18N.getLocale()));
            }
            occupation.addSpace(space);
        }
    }

    public boolean canManageOccupation(Occupation occupation, User user) {
        return occupation.canManageOccupation(user);
    }

    public void delete(Occupation occupation, User user) {
        Object object = advice$delete.perform((Callable)new OccupationService$callable$delete(this, occupation, user));
    }

    static /* synthetic */ void advised$delete(OccupationService this_, Occupation occupation, User user) {
        if (!this_.canManageOccupation(occupation, user)) {
            throw new SpaceDomainException("unauthorized.delete.occupation", new String[0]);
        }
        occupation.delete();
    }

    public PagedListHolder<OccupationRequest> getBook(List<OccupationRequest> requests, String pageString) {
        int page;
        PagedListHolder book;
        block5: {
            book = new PagedListHolder(requests);
            book.setPageSize(30);
            page = 0;
            if (Strings.isNullOrEmpty((String)pageString)) {
                page = 0;
            } else {
                try {
                    page = Integer.parseInt(pageString);
                }
                catch (NumberFormatException nfe) {
                    if ("f".equals(pageString)) {
                        page = 0;
                    }
                    if (!"l".equals(pageString)) break block5;
                    page = book.getPageCount();
                }
            }
        }
        book.setPage(page == 0 ? 0 : page - 1);
        return book;
    }

    public String getOccupations(Space space, Interval search) {
        JsonArray events = new JsonArray();
        int id = 1;
        for (Occupation occupation : space.getOccupationSet()) {
            boolean hasEvents = false;
            for (Interval interval : occupation.getIntervals()) {
                if (!interval.overlaps((ReadableInterval)search)) continue;
                JsonObject event = new JsonObject();
                String start = new Long(interval.getStart().getMillis() / 1000L).toString();
                String end = new Long(interval.getEnd().getMillis() / 1000L).toString();
                event.addProperty("id", (Number)id);
                event.addProperty("start", start);
                event.addProperty("end", end);
                event.addProperty("title", occupation.getSubject());
                String url = occupation.getUrl();
                if (url != null && !url.isEmpty()) {
                    event.addProperty("url", url);
                }
                event.addProperty("allDay", Boolean.valueOf(((Object)((Object)occupation)).getClass().equals(SharedOccupation.class)));
                event.addProperty("backgroundColor", this.colors[id % this.colors.length]);
                event.addProperty("info", occupation.getInfo());
                events.add((JsonElement)event);
                if (hasEvents) continue;
                hasEvents = true;
            }
            if (!hasEvents) continue;
            ++id;
        }
        return events.toString();
    }
}

