/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.spaces.ui;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import javax.servlet.UnavailableException;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.groups.Group;
import org.fenixedu.bennu.core.security.Authenticate;
import org.fenixedu.bennu.spring.portal.SpringApplication;
import org.fenixedu.bennu.spring.portal.SpringFunctionality;
import org.fenixedu.spaces.domain.Information;
import org.fenixedu.spaces.domain.Space;
import org.fenixedu.spaces.domain.SpaceClassification;
import org.fenixedu.spaces.ui.InformationBean;
import org.fenixedu.spaces.ui.SpaceAccessBean;
import org.fenixedu.spaces.ui.SpacesController$callable$changeAccess;
import org.fenixedu.spaces.ui.SpacesController$callable$create;
import org.joda.time.DateTime;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.view.RedirectView;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

@SpringApplication(group="anyone", path="spaces", title="title.space.management", hint="spaces-manager")
@SpringFunctionality(app=SpacesController.class, title="title.space.management", accessGroup="spaceManager")
@RequestMapping(value={"/spaces"})
public class SpacesController {
    static Comparator<Space> BY_NAME_COMPARATOR;
    public static final Advice advice$create;
    public static final Advice advice$changeAccess;

    @RequestMapping(method={RequestMethod.GET})
    public String home(Model model) {
        return this.home(null, model);
    }

    @RequestMapping(value={"{space}"}, method={RequestMethod.GET})
    public String home(@PathVariable Space space, Model model) {
        model.addAttribute("spaces", space == null ? Space.getTopLevelSpaces() : this.getChildrenOrderedByName(space));
        model.addAttribute("currentUser", (Object)Authenticate.getUser());
        model.addAttribute("isSpaceSuperUser", (Object)Group.dynamic((String)"spaceSuperUsers").isMember(Authenticate.getUser()));
        return "spaces/home";
    }

    private List<Space> getChildrenOrderedByName(Space space) {
        return space.getChildren().stream().sorted(BY_NAME_COMPARATOR).collect(Collectors.toList());
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.GET})
    public String create(Model model) throws UnavailableException {
        return this.create(null, model);
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.POST})
    public RedirectView create(@ModelAttribute InformationBean infoBean, BindingResult errors) {
        return this.create(null, infoBean, errors);
    }

    @RequestMapping(value={"/create/{space}"}, method={RequestMethod.GET})
    public String create(@PathVariable Space space, Model model) {
        if (space == null) {
            model.addAttribute("action", (Object)"/spaces/create");
        } else {
            model.addAttribute("action", (Object)("/spaces/create/" + space.getExternalId()));
            model.addAttribute("parentSpace", (Object)space);
        }
        model.addAttribute("information", (Object)new InformationBean());
        model.addAttribute("classifications", SpaceClassification.all());
        model.addAttribute("currentUser", (Object)Authenticate.getUser());
        return "spaces/create";
    }

    @RequestMapping(value={"/create/{space}"}, method={RequestMethod.POST})
    public RedirectView create(@PathVariable Space space, @ModelAttribute InformationBean infoBean, BindingResult errors) {
        this.create(space, infoBean);
        if (space == null) {
            return new RedirectView("/spaces", true);
        }
        return new RedirectView("/spaces/" + space.getExternalId(), true);
    }

    private boolean accessControl(Space space) {
        User currentUser = Authenticate.getUser();
        if (space == null) {
            return Group.dynamic((String)"spaceSuperUsers").isMember(currentUser);
        }
        return space.isSpaceManagementMember(currentUser);
    }

    private void canWrite(Space space) {
        if (!this.accessControl(space)) {
            throw new RuntimeException("Unauthorized");
        }
    }

    private void create(Space space, InformationBean informationBean) {
        Object object = advice$create.perform((Callable)new SpacesController$callable$create(this, space, informationBean));
    }

    static /* synthetic */ void advised$create(SpacesController this_, Space space, InformationBean infoBean) {
        this_.canWrite(space);
        Information information = new Information.Builder(infoBean).build();
        Space newSpace = new Space(space, information);
        if (space == null) {
            newSpace.setManagementAccessGroup((Group)Group.dynamic((String)"spaceSuperUsers"));
            newSpace.setOccupationsAccessGroup((Group)Group.dynamic((String)"spaceSuperUsers"));
        }
    }

    @RequestMapping(value={"/edit/{space}"}, method={RequestMethod.GET})
    public String edit(@PathVariable Space space, Model model) throws UnavailableException {
        InformationBean bean2 = space.bean();
        bean2.setValidFrom(new DateTime());
        model.addAttribute("information", (Object)bean2);
        model.addAttribute("classifications", SpaceClassification.all());
        model.addAttribute("currentUser", (Object)Authenticate.getUser());
        model.addAttribute("action", (Object)("/spaces/edit/" + space.getExternalId()));
        return "spaces/create";
    }

    @RequestMapping(value={"/edit/{space}"}, method={RequestMethod.POST})
    public String edit(@PathVariable Space space, @ModelAttribute InformationBean informationBean, BindingResult errors) throws UnavailableException {
        this.canWrite(space);
        if (space.getBlueprintFile().isPresent() && informationBean.getBlueprintContent() == null) {
            informationBean.setBlueprint(space.getBlueprintFile().get());
        }
        informationBean.setSpacePhotoSet(space.getSpacePhotoSet().orElse(Collections.emptySet()));
        space.bean(informationBean);
        return "redirect:/spaces-view/view/" + space.getExternalId();
    }

    @RequestMapping(value={"/timeline/{space}"}, method={RequestMethod.GET})
    public String timeline(@PathVariable Space space, Model model) throws UnavailableException {
        model.addAttribute("currentUser", (Object)Authenticate.getUser());
        model.addAttribute("timeline", space.timeline());
        if (space.getParent() != null) {
            model.addAttribute("parent", (Object)space.getParent().bean());
        }
        return "spaces/timeline";
    }

    @RequestMapping(value={"/access/{space}"}, method={RequestMethod.GET})
    public String accessManagement(@PathVariable Space space, Model model) throws UnavailableException {
        this.canWrite(space);
        SpaceAccessBean accessBean = new SpaceAccessBean();
        accessBean.setManagementGroup(space.getManagementGroup() != null ? space.getManagementGroup() : Group.nobody());
        accessBean.setOccupationGroup(space.getOccupationsGroup() != null ? space.getOccupationsGroup() : Group.nobody());
        model.addAttribute("spacebean", (Object)accessBean);
        model.addAttribute("space", (Object)space);
        model.addAttribute("action", (Object)("/spaces/access/" + space.getExternalId()));
        model.addAttribute("managementGroups", (Object)Bennu.getInstance().getGroupForSpacesSet());
        return "spaces/access";
    }

    private void changeAccess(Space space, SpaceAccessBean spaceAccessBean) {
        Object object = advice$changeAccess.perform((Callable)new SpacesController$callable$changeAccess(this, space, spaceAccessBean));
    }

    static /* synthetic */ void advised$changeAccess(SpacesController this_, Space space, SpaceAccessBean sab) {
        space.setManagementAccessGroup(sab.getManagementGroup());
        space.setOccupationsAccessGroup(sab.getOccupationGroup());
    }

    @RequestMapping(value={"/access/{space}"}, method={RequestMethod.POST})
    public String changeAccess(@PathVariable Space space, @ModelAttribute SpaceAccessBean spacebean, BindingResult errors) throws UnavailableException {
        this.canWrite(space);
        this.changeAccess(space, spacebean);
        return "redirect:/spaces/access/" + space.getExternalId();
    }

    @ResponseBody
    @RequestMapping(value={"/{space}"}, method={RequestMethod.DELETE})
    public String delete(@PathVariable Space space) throws UnavailableException {
        space.delete();
        return "ok";
    }

    static {
        advice$create = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.WRITE, true));
        advice$changeAccess = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.WRITE, true));
        BY_NAME_COMPARATOR = new Comparator<Space>(){

            @Override
            public int compare(Space o1, Space o2) {
                String o1Name = o1.getName();
                String o2Name = o2.getName();
                try {
                    Integer o1Number = Integer.parseInt(o1Name);
                    Integer o2Number = Integer.parseInt(o2Name);
                    return o1Number.compareTo(o2Number);
                }
                catch (NumberFormatException numberFormatException) {
                    return o1Name.compareTo(o2Name);
                }
            }
        };
    }
}

