/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.spaces.ui;

import com.google.common.base.Strings;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.ServletOutputStream;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServletResponse;
import org.fenixedu.bennu.core.security.Authenticate;
import org.fenixedu.bennu.spring.portal.SpringFunctionality;
import org.fenixedu.spaces.domain.BlueprintFile;
import org.fenixedu.spaces.domain.Space;
import org.fenixedu.spaces.domain.submission.SpacePhoto;
import org.fenixedu.spaces.services.ExportSpace;
import org.fenixedu.spaces.services.SpaceBlueprintsDWGProcessor;
import org.fenixedu.spaces.ui.SpacesController;
import org.fenixedu.spaces.ui.services.OccupationService;
import org.fenixedu.spaces.ui.services.SpacePhotoService;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@SpringFunctionality(app=SpacesController.class, title="title.spaces.search")
@RequestMapping(value={"/spaces-view"})
public class SpaceSearchController {
    @Autowired
    private OccupationService occupationService;
    @Autowired
    private SpacePhotoService photoService;

    @RequestMapping
    public String home(@RequestParam(required=false) String name, Model model) {
        return this.search(name, model);
    }

    @RequestMapping(value={"/search"})
    public String search(@RequestParam(required=false) String name, Model model) {
        model.addAttribute("name", (Object)name);
        model.addAttribute("currentUser", (Object)Authenticate.getUser());
        if (!Strings.isNullOrEmpty((String)name)) {
            model.addAttribute("foundSpaces", this.findSpace(name));
        }
        return "spaces-view/search";
    }

    private Set<Space> findSpace(String text) {
        return Space.getSpaces().filter(s -> {
            List<String> toksToFind = Arrays.asList(text.toLowerCase().split(" "));
            List<String> toks = Arrays.asList(s.getFullName().toLowerCase().split(" "));
            for (String token : toksToFind) {
                boolean contains = false;
                for (String ss : toks) {
                    if (!ss.contains(token)) continue;
                    contains = true;
                    break;
                }
                if (contains) continue;
                return false;
            }
            return true;
        }).sorted().collect(Collectors.toSet());
    }

    @RequestMapping(value={"/schedule/{space}"})
    public String schedule(@PathVariable Space space, Model model) {
        model.addAttribute("space", (Object)space);
        return "spaces-view/schedule";
    }

    @RequestMapping(value={"/schedule/{space}/events"}, produces={"application/json; charset=utf-8"})
    @ResponseBody
    public String schedule(@PathVariable Space space, @RequestParam(required=false) String start, @RequestParam(required=false) String end, Model model) {
        DateTime endDate;
        DateTime beginDate;
        if (Strings.isNullOrEmpty((String)start)) {
            DateTime now = new DateTime();
            beginDate = now.withDayOfWeek(1).withHourOfDay(0).withMinuteOfHour(0);
            endDate = now.withDayOfWeek(7).plusDays(1).withHourOfDay(0).withMinuteOfHour(0);
        } else {
            beginDate = new DateTime(Long.parseLong(start) * 1000L);
            endDate = new DateTime(Long.parseLong(end) * 1000L);
        }
        return this.occupationService.getOccupations(space, new Interval((ReadableInstant)beginDate, (ReadableInstant)endDate));
    }

    private BlueprintFile.BlueprintTextRectangles getBlueprintTextRectangles(Space space, BigDecimal scale) {
        BlueprintFile mostRecentBlueprint;
        DateTime now = new DateTime();
        Space spaceWithBlueprint = SpaceBlueprintsDWGProcessor.getSuroundingSpaceMostRecentBlueprint(space);
        if (spaceWithBlueprint != null && (mostRecentBlueprint = spaceWithBlueprint.getBlueprintFile().get()) != null) {
            try {
                byte[] blueprintBytes = mostRecentBlueprint.getContent();
                ByteArrayInputStream inputStream = new ByteArrayInputStream(blueprintBytes);
                return SpaceBlueprintsDWGProcessor.getBlueprintTextRectangles(inputStream, spaceWithBlueprint, now, false, false, true, false, scale);
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    private List<Space> getChildrenOrderedByName(Space space) {
        return space.getChildren().stream().sorted(SpacesController.BY_NAME_COMPARATOR).collect(Collectors.toList());
    }

    @RequestMapping(value={"/view/{space}"}, method={RequestMethod.GET})
    public String view(@PathVariable Space space, Model model, @RequestParam(defaultValue="50") BigDecimal scale, @RequestParam(defaultValue="") Boolean viewOriginalSpaceBlueprint, @RequestParam(defaultValue="") Boolean viewBlueprintNumbers, @RequestParam(defaultValue="") Boolean viewIdentifications, @RequestParam(defaultValue="") Boolean viewDoorNumbers) throws UnavailableException {
        model.addAttribute("scale", (Object)scale);
        model.addAttribute("viewOriginalSpaceBlueprint", (Object)viewOriginalSpaceBlueprint);
        model.addAttribute("viewBlueprintNumbers", (Object)viewBlueprintNumbers);
        model.addAttribute("viewIdentifications", (Object)viewIdentifications);
        model.addAttribute("viewDoorNumbers", (Object)viewDoorNumbers);
        model.addAttribute("information", (Object)space.bean());
        model.addAttribute("blueprintTextRectangles", (Object)this.getBlueprintTextRectangles(space, scale));
        model.addAttribute("spaces", this.getChildrenOrderedByName(space));
        model.addAttribute("parentSpace", (Object)space.getParent());
        model.addAttribute("currentUser", (Object)Authenticate.getUser());
        model.addAttribute("spacePhotos", this.photoService.getVisiblePhotos(space));
        return "spaces/view";
    }

    @RequestMapping(value={"/export/{space}"}, method={RequestMethod.GET})
    public void exportCSV(@PathVariable Space space, @DateTimeFormat(pattern="yyyy-MM-dd") @RequestParam(defaultValue="#{new org.joda.time.DateTime()}") DateTime when, HttpServletResponse response) throws IOException, UnavailableException {
        String filename = space.getName() + "_info";
        response.setContentType("application/vnd.ms-excel");
        response.setHeader("Content-disposition", "attachment; filename=" + filename + ".xls");
        try (ServletOutputStream outputStream = response.getOutputStream();){
            ExportSpace.run(space, (OutputStream)outputStream);
        }
    }

    @RequestMapping(value={"/blueprint/{space}"}, method={RequestMethod.GET})
    public void blueprint(@PathVariable Space space, @DateTimeFormat(pattern="yyyy-MM-dd") @RequestParam(defaultValue="#{new org.joda.time.DateTime()}") DateTime when, @RequestParam(defaultValue="50") BigDecimal scale, @RequestParam(defaultValue="false") Boolean viewOriginalSpaceBlueprint, @RequestParam(defaultValue="true") Boolean viewBlueprintNumbers, @RequestParam(defaultValue="true") Boolean viewIdentifications, @RequestParam(defaultValue="false") Boolean viewDoorNumbers, HttpServletResponse response) throws IOException, UnavailableException {
        Boolean isToViewOriginalSpaceBlueprint = viewOriginalSpaceBlueprint;
        Boolean isToViewBlueprintNumbers = viewBlueprintNumbers;
        Boolean isToViewIdentifications = viewIdentifications;
        Boolean isToViewDoorNumbers = viewDoorNumbers;
        BigDecimal scalePercentage = scale;
        response.setContentType("image/jpeg");
        try (ServletOutputStream outputStream = response.getOutputStream();){
            SpaceBlueprintsDWGProcessor.writeBlueprint(space, when, isToViewOriginalSpaceBlueprint, isToViewBlueprintNumbers, isToViewIdentifications, isToViewDoorNumbers, scalePercentage, (OutputStream)outputStream);
        }
    }

    @RequestMapping(value={"/photo/{spacePhoto}"}, method={RequestMethod.GET})
    public void spacePhotoRender(@PathVariable SpacePhoto spacePhoto, HttpServletResponse response) throws IOException, UnavailableException {
        response.setContentType("image/jpeg");
        try (ServletOutputStream outputStream = response.getOutputStream();){
            outputStream.write(spacePhoto.getContent());
        }
    }
}

