/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.spaces.ui;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import javax.servlet.UnavailableException;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.domain.exceptions.DomainException;
import org.fenixedu.bennu.core.groups.Group;
import org.fenixedu.bennu.core.security.Authenticate;
import org.fenixedu.bennu.spring.portal.BennuSpringController;
import org.fenixedu.spaces.domain.Space;
import org.fenixedu.spaces.domain.occupation.Occupation;
import org.fenixedu.spaces.domain.occupation.SharedOccupation;
import org.fenixedu.spaces.ui.SpaceOccupantsBean;
import org.fenixedu.spaces.ui.SpaceOccupantsController$callable$occupantsManagement;
import org.fenixedu.spaces.ui.SpacesController;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

@BennuSpringController(value=SpacesController.class)
@RequestMapping(value={"/spaces/occupants"})
public class SpaceOccupantsController {
    public static final Advice advice$occupantsManagement = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.WRITE, true));

    private List<SharedOccupation> getSharedOccupations(Space space) {
        return this.getSharedOccupations(space, null);
    }

    private List<SharedOccupation> getSharedOccupations(Space space, Boolean active) {
        ArrayList<SharedOccupation> occupationList = new ArrayList<SharedOccupation>();
        for (Occupation occupation : space.getOccupationSet()) {
            if (!(occupation instanceof SharedOccupation)) continue;
            SharedOccupation sharedOccupation = (SharedOccupation)((Object)occupation);
            if (active != null && !(active != false ? !sharedOccupation.getActiveIntervals().isEmpty() : !sharedOccupation.getInactiveIntervals().isEmpty())) continue;
            occupationList.add(sharedOccupation);
        }
        return occupationList;
    }

    @RequestMapping(value={"{space}"}, method={RequestMethod.GET})
    public String occupantsManagement(@PathVariable Space space, Model model) throws UnavailableException {
        this.canWrite(space);
        SpaceOccupantsBean theOb = new SpaceOccupantsBean();
        model.addAttribute("occupantsbean", (Object)theOb);
        model.addAttribute("spaceinfo", (Object)space.bean());
        model.addAttribute("space", (Object)space);
        model.addAttribute("activeOccupations", this.getSharedOccupations(space, true));
        model.addAttribute("inactiveOccupations", this.getSharedOccupations(space, false));
        model.addAttribute("action", (Object)("/spaces/occupants/" + space.getExternalId()));
        return "spaces/occupants";
    }

    private void occupantsManagement(Space space, SpaceOccupantsBean spaceOccupantsBean) {
        Object object = advice$occupantsManagement.perform((Callable)new SpaceOccupantsController$callable$occupantsManagement(this, space, spaceOccupantsBean));
    }

    static /* synthetic */ void advised$occupantsManagement(SpaceOccupantsController this_, Space space, SpaceOccupantsBean sab) {
        SharedOccupation sharedOccup = null;
        List<SharedOccupation> sharedOccups = this_.getSharedOccupations(space);
        for (SharedOccupation so : sharedOccups) {
            if (!so.getUser().equals((Object)sab.getUserObject())) continue;
            sharedOccup = so;
        }
        if (sharedOccups.size() == 0 || sharedOccup == null) {
            sharedOccup = new SharedOccupation();
        }
        if (sharedOccup.doConfig(sab)) {
            space.addOccupation((Occupation)((Object)sharedOccup));
        }
    }

    @RequestMapping(value={"{space}"}, method={RequestMethod.POST})
    public String occupantsManagement(@PathVariable Space space, @ModelAttribute SpaceOccupantsBean spacebean, BindingResult errors, Model model) throws UnavailableException {
        this.canWrite(space);
        try {
            this.occupantsManagement(space, spacebean);
        }
        catch (DomainException e) {
            model.addAttribute("message", (Object)e.asJson().toString());
            return this.occupantsManagement(space, model);
        }
        return "redirect:/spaces/occupants/" + space.getExternalId();
    }

    private boolean accessControl(Space space) {
        User currentUser = Authenticate.getUser();
        if (space == null) {
            return Group.dynamic((String)"spaceSuperUsers").isMember(currentUser);
        }
        return space.isOccupationMember(currentUser);
    }

    private void canWrite(Space space) {
        if (!this.accessControl(space)) {
            throw new RuntimeException("Unauthorized");
        }
    }
}

