/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.spaces.ui;

import com.google.gson.JsonObject;
import java.lang.annotation.Annotation;
import java.util.concurrent.Callable;
import javax.servlet.UnavailableException;
import org.fenixedu.bennu.core.domain.exceptions.DomainException;
import org.fenixedu.bennu.core.groups.Group;
import org.fenixedu.bennu.core.security.Authenticate;
import org.fenixedu.bennu.spring.portal.SpringFunctionality;
import org.fenixedu.spaces.domain.SpaceClassification;
import org.fenixedu.spaces.ui.SpaceClassificationBean;
import org.fenixedu.spaces.ui.SpaceClassificationController$callable$create;
import org.fenixedu.spaces.ui.SpacesController;
import org.fenixedu.spaces.ui.services.SpaceClassificationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

@SpringFunctionality(app=SpacesController.class, title="title.space.classification.management")
@RequestMapping(value={"/classification"})
public class SpaceClassificationController {
    @Autowired
    SpaceClassificationService spaceClassificationService;
    public static final Advice advice$create = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.WRITE, true));

    @RequestMapping
    public String home(Model model) {
        return this.listClassifications(model);
    }

    @RequestMapping(value={"/list"})
    public String listClassifications(Model model) {
        this.canWrite();
        model.addAttribute("classifications", SpaceClassification.all());
        return "classification/list";
    }

    @RequestMapping(value={"/edit"}, method={RequestMethod.GET})
    public String edit(Model model) throws UnavailableException {
        this.canWrite();
        return this.create(null, model);
    }

    @RequestMapping(value={"/edit"}, method={RequestMethod.POST})
    @ResponseBody
    public String edit(@RequestBody String informationJson) {
        this.canWrite();
        return this.create(null, informationJson);
    }

    private SpaceClassification create(SpaceClassificationBean spaceClassificationBean) {
        return (SpaceClassification)((Object)advice$create.perform((Callable)new SpaceClassificationController$callable$create(this, spaceClassificationBean)));
    }

    static /* synthetic */ SpaceClassification advised$create(SpaceClassificationController this_, SpaceClassificationBean infoBean) {
        SpaceClassification sc = null;
        if (infoBean.getParent().length() > 0) {
            sc = (SpaceClassification)FenixFramework.getDomainObject((String)infoBean.getParent());
        }
        return new SpaceClassification(infoBean.getCode(), infoBean.getLocalizedName(), sc, infoBean.getMetadataSpec(), infoBean.getIsAllocatable());
    }

    @RequestMapping(value={"/edit/{classification}"}, method={RequestMethod.GET})
    public String create(@PathVariable SpaceClassification classification, Model model) {
        this.canWrite();
        return this.create(classification, model, false);
    }

    public String create(SpaceClassification classification, Model model, boolean newInfo) {
        SpaceClassificationBean scb = null;
        this.canWrite();
        if (classification == null) {
            model.addAttribute("action", (Object)"/classification/edit");
            scb = new SpaceClassificationBean();
        } else {
            model.addAttribute("action", (Object)("/classification/edit/" + classification.getExternalId()));
            scb = classification.getBean();
        }
        if (!newInfo) {
            model.addAttribute("information", (Object)scb);
        }
        model.addAttribute("classifications", SpaceClassification.all());
        model.addAttribute("currentUser", (Object)Authenticate.getUser());
        return "classification/edit";
    }

    @ResponseBody
    @RequestMapping(value={"/edit/{classification}"}, method={RequestMethod.POST})
    public String create(@PathVariable SpaceClassification classification, @RequestBody String json) {
        this.canWrite();
        SpaceClassificationBean information = new SpaceClassificationBean(json);
        try {
            this.spaceClassificationService.verifyClassification(information);
        }
        catch (DomainException de) {
            return de.asJson().toString();
        }
        if (classification == null) {
            this.create(information);
        } else {
            try {
                this.spaceClassificationService.updateClassification(classification, information);
            }
            catch (DomainException de) {
                return de.asJson().toString();
            }
        }
        JsonObject ok = new JsonObject();
        String okS = ok.toString();
        return okS;
    }

    @ResponseBody
    @RequestMapping(value={"/remove/{classification}"}, method={RequestMethod.DELETE})
    public String create(@PathVariable SpaceClassification classification) {
        this.canWrite();
        try {
            classification.delete();
        }
        catch (DomainException de) {
            return de.asJson().toString();
        }
        return "ok";
    }

    private boolean accessControl() {
        return Group.dynamic((String)"spaceSuperUsers").isMember(Authenticate.getUser());
    }

    private void canWrite() {
        if (!this.accessControl()) {
            throw new RuntimeException("Unauthorized");
        }
    }
}

