/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.spaces.ui;

import java.io.IOException;
import org.apache.tika.Tika;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.security.Authenticate;
import org.fenixedu.spaces.domain.Space;
import org.springframework.web.multipart.MultipartFile;

public class PhotoSubmissionBean {
    User submitor;
    Space space;
    MultipartFile submissionMultipartFile;

    public PhotoSubmissionBean() {
        this.setSubmitor(Authenticate.getUser());
    }

    public PhotoSubmissionBean(Space space) {
        this();
        this.setSpace(space);
    }

    public User getSubmitor() {
        return this.submitor;
    }

    public void setSubmitor(User submitor) {
        this.submitor = submitor;
    }

    public MultipartFile getSubmissionMultipartFile() {
        return this.submissionMultipartFile;
    }

    public void setSubmissionMultipartFile(MultipartFile submissionMultipartFile) {
        this.submissionMultipartFile = submissionMultipartFile;
    }

    public Space getSpace() {
        return this.space;
    }

    public void setSpace(Space space) {
        this.space = space;
    }

    public byte[] getSubmissionContent() {
        try {
            if (this.getSubmissionMultipartFile() != null && !this.getSubmissionMultipartFile().isEmpty()) {
                return this.getSubmissionMultipartFile().getBytes();
            }
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    public boolean isImageFile() {
        String contentType;
        if (this.submissionMultipartFile == null || this.submissionMultipartFile.isEmpty()) {
            return false;
        }
        Tika tika = new Tika();
        try {
            contentType = tika.detect(this.submissionMultipartFile.getInputStream(), "Content-Type");
        }
        catch (IOException e) {
            return false;
        }
        return contentType.equals("image/pjpeg") || contentType.equals("image/jpeg") || contentType.equals("image/png") || contentType.equals("image/x-png");
    }
}

