/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.spaces.ui;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.security.Authenticate;
import org.fenixedu.bennu.spring.I18NBean;
import org.fenixedu.bennu.spring.portal.SpringFunctionality;
import org.fenixedu.commons.spreadsheet.SheetData;
import org.fenixedu.commons.spreadsheet.SpreadsheetBuilder;
import org.fenixedu.commons.spreadsheet.WorkbookExportFormat;
import org.fenixedu.spaces.domain.Space;
import org.fenixedu.spaces.domain.SpaceDomainException;
import org.fenixedu.spaces.domain.occupation.requests.OccupationRequest;
import org.fenixedu.spaces.domain.occupation.requests.OccupationRequestState;
import org.fenixedu.spaces.ui.SpacesController;
import org.fenixedu.spaces.ui.services.OccupationService;
import org.fenixedu.spaces.ui.services.UserInformationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.view.RedirectView;

@SpringFunctionality(app=SpacesController.class, title="title.space.occupations.requests")
@RequestMapping(value={"/spaces/occupations/requests"})
public class OccupationRequestsController {
    @Autowired
    OccupationService occupationService;
    @Autowired
    I18NBean bundle;
    @Autowired(required=false)
    UserInformationService userInformationService;

    @RequestMapping(value={"/search/{id}"}, method={RequestMethod.GET})
    public String search(@PathVariable String id, Model model, @RequestParam(required=false, defaultValue="1") String p) {
        List<OccupationRequest> result = this.occupationService.search(id);
        if (result.size() < 2) {
            return this.view(result.isEmpty() ? null : result.iterator().next(), model);
        }
        model.addAttribute("searchId", (Object)id);
        model.addAttribute("userRequestSearchResult", this.occupationService.getBook(result, p));
        return this.viewRequests(model, null, null);
    }

    @RequestMapping(value={"/{occupationRequest}"}, method={RequestMethod.GET})
    public String view(@PathVariable OccupationRequest occupationRequest, Model model) {
        model.addAttribute("occupationRequest", (Object)occupationRequest);
        if (this.userInformationService != null && occupationRequest != null) {
            model.addAttribute("email", (Object)this.userInformationService.getEmail(occupationRequest.getRequestor()));
            model.addAttribute("contacts", (Object)this.userInformationService.getContacts(occupationRequest.getRequestor()));
            model.addAttribute("groups", (Object)this.getUserGroups(occupationRequest.getRequestor()));
        }
        return "occupations/requests/single";
    }

    @RequestMapping(value={"/{occupationRequest}/comments"}, method={RequestMethod.POST})
    public String addComment(@PathVariable OccupationRequest occupationRequest, @RequestParam String description, @RequestParam OccupationRequestState state, Model model) {
        try {
            this.occupationService.addComment(occupationRequest, description, state);
        }
        catch (SpaceDomainException sde) {
            model.addAttribute("errors", (Object)sde.getLocalizedMessage());
            return this.view(occupationRequest, model);
        }
        return "redirect:/spaces/occupations/requests/" + occupationRequest.getExternalId();
    }

    @RequestMapping(value={"/{occupationRequest}/{state}"}, method={RequestMethod.GET})
    public RedirectView changeRequestState(@PathVariable OccupationRequest occupationRequest, Model model, @PathVariable OccupationRequestState state) {
        if (occupationRequest.getCurrentState() != OccupationRequestState.NEW) {
            return new RedirectView("/spaces/occupations/requests/", true);
        }
        switch (state) {
            case OPEN: {
                this.occupationService.openRequest(occupationRequest, Authenticate.getUser());
                break;
            }
            case RESOLVED: {
                this.occupationService.closeRequest(occupationRequest, Authenticate.getUser());
            }
        }
        return new RedirectView("/spaces/occupations/requests/" + occupationRequest.getExternalId(), true);
    }

    @RequestMapping(value={"/filter/{campus}"}, method={RequestMethod.GET})
    public String filter(@PathVariable Space campus, Model model, @RequestParam(defaultValue="1") String p, @RequestParam(required=false) OccupationRequestState state) {
        model.addAttribute("campus", this.occupationService.getTopLevelSpaces());
        model.addAttribute("selectedCampi", (Object)campus);
        this.addRequests(model, campus, p, state);
        return "occupations/requests/view";
    }

    @RequestMapping(value={"/export"}, method={RequestMethod.GET})
    public void exportAnyCampusToExcel(@RequestParam(required=false) Space campus, @RequestParam(required=false) OccupationRequestState state, HttpServletResponse response) {
        List<OccupationRequest> requests = state != null ? this.occupationService.all(state, campus) : this.occupationService.getRequestsToProcess(Authenticate.getUser(), campus);
        Object filename = this.bundle.message("label.occupation.request.filename");
        if (campus != null) {
            filename = (String)filename + "_" + campus.getPresentationName();
        }
        response.setContentType("application/vnd.ms-excel");
        response.setHeader("Content-disposition", "attachment; filename=" + (String)filename + ".xls");
        try {
            this.makeExcel(requests, (OutputStream)response.getOutputStream());
            response.flushBuffer();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    @RequestMapping(method={RequestMethod.GET})
    public String viewRequests(Model model, @RequestParam(defaultValue="1") String p, @RequestParam(required=false) OccupationRequestState state) {
        model.addAttribute("campus", this.occupationService.getTopLevelSpaces());
        this.addRequests(model, null, p, state);
        return "occupations/requests/view";
    }

    public void addRequests(Model model, Space campus) {
        this.addRequests(model, campus, null, null);
    }

    public void addRequests(Model model, Space campus, String page, OccupationRequestState state) {
        String myRequestsPage = state == null ? page : null;
        String openRequestsPage = OccupationRequestState.OPEN.equals((Object)state) ? page : null;
        String newRequestsPage = OccupationRequestState.NEW.equals((Object)state) ? page : null;
        String resolvedRequestsPage = OccupationRequestState.RESOLVED.equals((Object)state) ? page : null;
        List<OccupationRequest> myRequests = this.occupationService.getRequestsToProcess(Authenticate.getUser(), campus);
        List<OccupationRequest> openRequests = this.occupationService.all(OccupationRequestState.OPEN, campus);
        List<OccupationRequest> newRequests = this.occupationService.all(OccupationRequestState.NEW, campus);
        List<OccupationRequest> resolvedRequests = this.occupationService.all(OccupationRequestState.RESOLVED, campus);
        model.addAttribute("myRequests", this.occupationService.getBook(myRequests, myRequestsPage));
        model.addAttribute("openRequests", this.occupationService.getBook(openRequests, openRequestsPage));
        model.addAttribute("newRequests", this.occupationService.getBook(newRequests, newRequestsPage));
        model.addAttribute("resolvedRequests", this.occupationService.getBook(resolvedRequests, resolvedRequestsPage));
    }

    private String getUserGroups(User requestor) {
        return this.userInformationService.getGroups(requestor).stream().map(g -> g.getPresentationName().trim()).collect(Collectors.joining(","));
    }

    private void makeExcel(List<OccupationRequest> requests, OutputStream outputStream) throws IOException {
        SheetData<OccupationRequest> data = new SheetData<OccupationRequest>(requests){

            protected void makeLine(OccupationRequest request) {
                this.addCell(OccupationRequestsController.this.bundle.message("label.occupation.request.identification"), request.getIdentification());
                this.addCell(OccupationRequestsController.this.bundle.message("label.occupation.request.instant"), request.getPresentationInstant());
                this.addCell(OccupationRequestsController.this.bundle.message("label.occupation.request.subject"), request.getSubject());
                User requestor = request.getRequestor();
                this.addCell(OccupationRequestsController.this.bundle.message("label.occupation.request.requestor"), String.format("%s (%s)", requestor.getProfile().getDisplayName(), requestor.getUsername()));
                if (OccupationRequestsController.this.userInformationService != null) {
                    this.addCell(OccupationRequestsController.this.bundle.message("label.occupation.request.email"), OccupationRequestsController.this.userInformationService.getEmail(requestor));
                    this.addCell(OccupationRequestsController.this.bundle.message("label.occupation.request.roles"), OccupationRequestsController.this.getUserGroups(requestor).toString());
                }
                User owner = request.getOwner();
                String ownerCellValue = "-";
                if (owner != null && owner.getProfile() != null) {
                    ownerCellValue = String.format("%s (%s)", owner.getProfile().getDisplayName(), owner.getUsername());
                }
                this.addCell(OccupationRequestsController.this.bundle.message("label.occupation.request.owner"), ownerCellValue);
            }
        };
        new SpreadsheetBuilder().addSheet(this.bundle.message("label.occupation.request.filetitle"), (SheetData)data).build(WorkbookExportFormat.EXCEL, outputStream);
    }
}

