/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.spaces.ui;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.fenixedu.bennu.core.security.Authenticate;
import org.fenixedu.bennu.spring.portal.BennuSpringController;
import org.fenixedu.spaces.domain.occupation.Occupation;
import org.fenixedu.spaces.domain.occupation.requests.OccupationRequest;
import org.fenixedu.spaces.ui.SpacesController;
import org.fenixedu.spaces.ui.services.OccupationService;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@BennuSpringController(value=SpacesController.class)
@RequestMapping(value={"/spaces/occupations"})
public class OccupationController {
    private final JsonParser jsonParser = new JsonParser();
    @Autowired
    OccupationService occupationService;

    private List<Interval> parseIntervals(String events) {
        JsonArray jsonEvents = this.jsonParser.parse(events).getAsJsonArray();
        ArrayList<Interval> intervals = new ArrayList<Interval>();
        for (JsonElement jsonEvent : jsonEvents) {
            JsonObject event = jsonEvent.getAsJsonObject();
            Long start = Long.parseLong(event.get("start").getAsString()) * 1000L;
            Long end = Long.parseLong(event.get("end").getAsString()) * 1000L;
            intervals.add(new Interval((ReadableInstant)new DateTime((Object)start), (ReadableInstant)new DateTime((Object)end)));
        }
        return intervals;
    }

    @RequestMapping(value={"create"}, method={RequestMethod.GET})
    public String getCreate(Model model, @RequestParam(required=false) OccupationRequest request) {
        model.addAttribute("request", (Object)request);
        return "occupations/create";
    }

    public String searchSpaces(Model model, @RequestParam String events, @RequestParam String config, @RequestParam(required=false) OccupationRequest request, @RequestParam(required=false) String mails) {
        List<Interval> intervals = this.parseIntervals(events);
        model.addAttribute("events", (Object)events);
        model.addAttribute("config", (Object)config);
        model.addAttribute("request", (Object)request);
        if (mails != null) {
            model.addAttribute("emails", (Object)mails);
        }
        model.addAttribute("freeSpaces", this.occupationService.searchFreeSpaces(intervals, Authenticate.getUser()));
        return "occupations/searchcreate";
    }

    @RequestMapping(value={"search-create"}, method={RequestMethod.POST})
    public String searchSpaces(Model model, @RequestParam String events, @RequestParam String config, @RequestParam(required=false) OccupationRequest request) {
        return this.searchSpaces(model, events, config, request, null);
    }

    @RequestMapping(value={"create"}, method={RequestMethod.POST})
    public String create(Model model, @RequestParam String emails, @RequestParam String subject, @RequestParam String description, @RequestParam String selectedSpaces, @RequestParam String config, @RequestParam String events, @RequestParam(required=false) OccupationRequest request) {
        ArrayList<String> parsedMails = new ArrayList<String>();
        for (String m : emails.split(",")) {
            if (!this.isValidEmailAddress(m.trim())) continue;
            parsedMails.add(m);
        }
        emails = parsedMails.stream().collect(Collectors.joining(", "));
        try {
            this.occupationService.createOccupation(emails, subject, description, selectedSpaces, config, events, request, Authenticate.getUser());
            if (request != null) {
                return "redirect:/spaces/occupations/requests/" + request.getExternalId();
            }
            return "redirect:/spaces/occupations/list";
        }
        catch (Exception e) {
            model.addAttribute("errorMessage", (Object)e.getMessage());
            return this.searchSpaces(model, events, config, request, emails);
        }
    }

    public boolean isValidEmailAddress(String email) {
        String ePattern = "^[a-zA-Z0-9.!#$%&'*+/=?^_`{|}~-]+@((\\[[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\])|(([a-zA-Z\\-0-9]+\\.)+[a-zA-Z]{2,}))$";
        Pattern p = Pattern.compile(ePattern);
        Matcher m = p.matcher(email);
        return m.matches();
    }

    @RequestMapping(value={"view/{occupation}"})
    public String view(Model model, @PathVariable Occupation occupation) {
        if (!this.occupationService.canManageOccupation(occupation, Authenticate.getUser())) {
            return "redirect:/";
        }
        model.addAttribute("occupation", (Object)occupation);
        model.addAttribute("events", (Object)this.occupationService.exportEvents(occupation));
        model.addAttribute("config", (Object)this.occupationService.exportConfig(occupation));
        model.addAttribute("freeSpaces", this.occupationService.getFreeAndSelectedSpaces(occupation, Authenticate.getUser()));
        return "occupations/edit";
    }

    @RequestMapping(value={"edit"}, method={RequestMethod.POST})
    public String edit(Model model, @RequestParam Occupation occupation, @RequestParam String emails, @RequestParam String subject, @RequestParam String description, @RequestParam String selectedSpaces) {
        try {
            this.occupationService.editOccupation(occupation, emails, subject, description, selectedSpaces, Authenticate.getUser());
            return "redirect:/spaces/occupations/list";
        }
        catch (Exception e) {
            model.addAttribute("errorMessage", (Object)e.getMessage());
            return this.view(model, occupation);
        }
    }

    @RequestMapping(value={"{occupation}"}, method={RequestMethod.DELETE})
    public String delete(@PathVariable Occupation occupation) {
        this.occupationService.delete(occupation, Authenticate.getUser());
        return "redirect:/spaces/occupations/list";
    }
}

