/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.spaces.ui;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.fenixedu.bennu.core.security.Authenticate;
import org.fenixedu.bennu.spring.portal.SpringFunctionality;
import org.fenixedu.spaces.ui.SpacesController;
import org.fenixedu.spaces.ui.services.OccupationService;
import org.joda.time.DateTime;
import org.joda.time.DateTimeFieldType;
import org.joda.time.Partial;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@SpringFunctionality(app=SpacesController.class, title="title.list.occupations")
@RequestMapping(value={"/spaces/occupations/list"})
public class ListOccupationsController {
    @Autowired
    OccupationService occupationService;

    @RequestMapping
    public String list(Model model, @RequestParam(defaultValue="#{new org.joda.time.DateTime().getMonthOfYear()}") int month, @RequestParam(defaultValue="#{new org.joda.time.DateTime().getYear()}") int year, @RequestParam(defaultValue="") String name) {
        DateTime now = new DateTime();
        int currentYear = now.getYear();
        model.addAttribute("years", IntStream.rangeClosed(currentYear - 100, currentYear + 10).boxed().sorted((o1, o2) -> o2.compareTo((Integer)o1)).collect(Collectors.toList()));
        List months = IntStream.rangeClosed(1, 12).boxed().map(m -> new Partial(DateTimeFieldType.monthOfYear(), m.intValue())).collect(Collectors.toList());
        model.addAttribute("months", months);
        model.addAttribute("currentMonth", (Object)month);
        model.addAttribute("currentYear", (Object)year);
        model.addAttribute("occupations", this.occupationService.getOccupations(month, year, Authenticate.getUser(), name));
        model.addAttribute("name", (Object)name);
        return "occupations/list";
    }
}

