/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.spaces.services;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.commons.spreadsheet.Spreadsheet;
import org.fenixedu.spaces.domain.Space;
import org.fenixedu.spaces.domain.SpaceClassification;
import org.fenixedu.spaces.domain.occupation.SharedOccupation;

public class ExportSpace {
    private static List<Object> getHeaders(List<String> metaKeys) {
        ArrayList<Object> headers = new ArrayList<Object>();
        headers.add(BundleUtil.getString((String)"resources/FenixEduSpacesResources", (String)"export.excel.path", (String[])new String[0]));
        headers.add(BundleUtil.getString((String)"resources/FenixEduSpacesResources", (String)"export.excel.name", (String[])new String[0]));
        headers.add(BundleUtil.getString((String)"resources/FenixEduSpacesResources", (String)"export.excel.id", (String[])new String[0]));
        headers.add(BundleUtil.getString((String)"resources/FenixEduSpacesResources", (String)"export.excel.valid.from", (String[])new String[0]));
        headers.add(BundleUtil.getString((String)"resources/FenixEduSpacesResources", (String)"export.excel.valid.until", (String[])new String[0]));
        headers.add(BundleUtil.getString((String)"resources/FenixEduSpacesResources", (String)"export.excel.blueprintNumber", (String[])new String[0]));
        headers.add(BundleUtil.getString((String)"resources/FenixEduSpacesResources", (String)"export.excel.classification", (String[])new String[0]));
        headers.add(BundleUtil.getString((String)"resources/FenixEduSpacesResources", (String)"export.excel.capacity", (String[])new String[0]));
        headers.add(BundleUtil.getString((String)"resources/FenixEduSpacesResources", (String)"export.excel.area", (String[])new String[0]));
        headers.add(BundleUtil.getString((String)"resources/FenixEduSpacesResources", (String)"export.excel.occupants", (String[])new String[0]));
        HashMap<String, LocalizedString> showKeys = new HashMap<String, LocalizedString>();
        for (SpaceClassification spaceClassification : SpaceClassification.all()) {
            for (JsonElement je : spaceClassification.getMetadataSpec().getAsJsonArray()) {
                LocalizedString description;
                JsonObject attribute = je.getAsJsonObject();
                String name = attribute.get("name").getAsString();
                if (showKeys.putIfAbsent(name, description = LocalizedString.fromJson((JsonElement)attribute.get("description"))) != null) continue;
                metaKeys.add(name);
            }
        }
        for (String header : metaKeys) {
            headers.add(((LocalizedString)showKeys.get(header)).getContent());
        }
        return headers;
    }

    private static void exportToXls(Space space, OutputStream outputStream) throws IOException {
        ArrayList<String> metaKeys = new ArrayList<String>();
        List<Object> headers = ExportSpace.getHeaders(metaKeys);
        Spreadsheet spreadsheet = new Spreadsheet("Gest\u00e3oDeEspa\u00e7os", headers);
        ExportSpace.fillSpaceInfo(space, spreadsheet, metaKeys);
        ExportSpace.fillSpreadSheet(space, spreadsheet, metaKeys);
        spreadsheet.exportToXLSSheet(outputStream);
    }

    private static String StringPath(List<Space> path) {
        return path.stream().map(a -> a.getName()).collect(Collectors.joining(" > "));
    }

    private static void fillSpaceInfo(Space space, Spreadsheet spreadsheet, List<String> metaKeys) {
        Spreadsheet.Row row = spreadsheet.addRow();
        row.setCell(space.getParent() != null ? ExportSpace.StringPath(space.getParent().getPath()) : "--");
        row.setCell(space.getName());
        row.setCell(space.bean().getIdentification() != null ? space.bean().getIdentification() : "--");
        row.setCell(space.bean().getValidFrom() != null ? space.bean().getValidFrom().toString("yyyy-MM-dd") : "--");
        row.setCell(space.bean().getValidUntil() != null ? space.bean().getValidUntil().toString("yyyy-MM-dd") : "--");
        row.setCell(space.bean().getBlueprintNumber() != null ? space.bean().getBlueprintNumber() : "--");
        row.setCell(space.bean().getClassification() != null ? space.bean().getClassification().getName().getContent() : "--");
        row.setCell(space.bean().getAllocatableCapacity() != null ? space.bean().getAllocatableCapacity().toString() : "--");
        row.setCell(space.bean().getArea() != null ? space.bean().getArea().toString() : "--");
        row.setCell(ExportSpace.getOccupantsString(space));
        for (String field : metaKeys) {
            row.setCell(space.getMetadata(field).orElse("--").toString());
        }
    }

    private static String getOccupantsString(Space space) {
        return space.getOccupationSet().stream().filter(occ -> SharedOccupation.class.isInstance(occ)).map(occ -> (SharedOccupation)((Object)((Object)occ))).filter(so -> so.isActive()).map(so -> so.getUser().getProfile().getDisplayName() + " (" + so.getUser().getUsername() + ")").collect(Collectors.joining("; "));
    }

    private static void fillSpreadSheet(Space space, Spreadsheet spreadsheet, List<String> metaKeys) {
        for (Space subSpace : space.getChildren()) {
            if (subSpace.isActive()) {
                ExportSpace.fillSpaceInfo(subSpace, spreadsheet, metaKeys);
            }
            if (subSpace.getChildren().size() == 0) continue;
            ExportSpace.fillSpreadSheet(subSpace, spreadsheet, metaKeys);
        }
    }

    public static void run(Space space, OutputStream outputStream) {
        try {
            ExportSpace.exportToXls(space, outputStream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

