/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.spaces.domain.occupation.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.JsonSyntaxException;
import java.lang.reflect.Type;
import java.util.List;
import java.util.stream.Collectors;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.LocalTime;
import org.joda.time.ReadableInstant;

public abstract class OccupationConfig {
    private static final Gson gson = new GsonBuilder().registerTypeAdapter(Interval.class, (Object)new JsonSerializer<Interval>(){

        public JsonElement serialize(Interval src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject json = new JsonObject();
            json.addProperty("start", src.getStart().toString());
            json.addProperty("end", src.getEnd().toString());
            return json;
        }
    }).registerTypeAdapter(Interval.class, (Object)new JsonDeserializer<Interval>(){

        public Interval deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject intervalJson = json.getAsJsonObject();
            DateTime start = new DateTime((Object)intervalJson.get("start").getAsString());
            DateTime end = new DateTime((Object)intervalJson.get("end").getAsString());
            return new Interval((ReadableInstant)start, (ReadableInstant)end);
        }
    }).registerTypeAdapter(LocalTime.class, (Object)new JsonSerializer<LocalTime>(){

        public JsonElement serialize(LocalTime src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(src.toString("HH:mm:ss"));
        }
    }).registerTypeAdapter(LocalTime.class, (Object)new JsonDeserializer<LocalTime>(){

        public LocalTime deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return LocalTime.parse((String)json.getAsString());
        }
    }).registerTypeAdapter(DateTime.class, (Object)new JsonDeserializer<DateTime>(){

        public DateTime deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return DateTime.parse((String)json.getAsString());
        }
    }).registerTypeAdapter(DateTime.class, (Object)new JsonSerializer<DateTime>(){

        public JsonElement serialize(DateTime src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(src.toString());
        }
    }).create();

    public abstract List<Interval> getIntervals();

    public static OccupationConfig internalize(JsonElement json) {
        if (json == null) {
            return null;
        }
        JsonObject jsonObject = json.getAsJsonObject();
        String type = jsonObject.get("type").getAsString();
        try {
            return (OccupationConfig)gson.fromJson(json, Class.forName(type));
        }
        catch (JsonSyntaxException | ClassNotFoundException e) {
            throw new IllegalArgumentException();
        }
    }

    public JsonElement externalize() {
        JsonElement jsonTree = gson.toJsonTree((Object)this, this.getClass());
        jsonTree.getAsJsonObject().addProperty("type", this.getClass().getName());
        return jsonTree;
    }

    public static Gson gson() {
        return gson;
    }

    public String getSummary() {
        return this.getIntervals().toString();
    }

    public String getExtendedSummary() {
        return this.getIntervals().toString();
    }

    public DateTime getStart() {
        return this.getSortedIntervals().isEmpty() ? null : this.getSortedIntervals().get(0).getStart();
    }

    public DateTime getEnd() {
        return this.getSortedIntervals().isEmpty() ? null : this.getSortedIntervals().get(this.getSortedIntervals().size() - 1).getEnd();
    }

    private List<Interval> getSortedIntervals() {
        return this.getIntervals().stream().sorted((i1, i2) -> i1.getStart().compareTo((ReadableInstant)i2.getStart())).collect(Collectors.toList());
    }
}

