/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.spaces.domain.occupation;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.bennu.core.security.Authenticate;
import org.fenixedu.bennu.core.util.CoreConfiguration;
import org.fenixedu.spaces.domain.Space;
import org.fenixedu.spaces.domain.occupation.Occupation_Base;
import org.fenixedu.spaces.domain.occupation.config.OccupationConfig;
import org.fenixedu.spaces.domain.occupation.requests.OccupationRequest;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadableInterval;

public class Occupation
extends Occupation_Base {
    public Occupation() {
        this.setBennu(Bennu.getInstance());
    }

    public Occupation(String emails, String subject, String description, OccupationConfig config) {
        this(emails, subject, description, config, null);
    }

    public Occupation(String emails, String subject, String description, OccupationConfig config, OccupationRequest request) {
        this();
        this.setConfig(config);
        this.setEmails(emails);
        this.setSubject(subject);
        this.setDescription(description);
        this.setRequest(request);
    }

    public void addSpace(Space space) {
        super.addSpace(space);
    }

    public void removeSpace(Space space) {
        super.removeSpace(space);
    }

    public Set<Space> getSpaces() {
        return this.getSpaceSet().stream().filter(space -> space.isActive()).collect(Collectors.toSet());
    }

    public List<Interval> getIntervals() {
        return this.getConfig().getIntervals();
    }

    public Boolean overlaps(List<Interval> intervals) {
        for (Interval interval : intervals) {
            for (Interval occupationInterval : this.getIntervals()) {
                if (!occupationInterval.overlaps((ReadableInterval)interval)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean overlaps(Interval ... intervals) {
        for (Interval interval : intervals) {
            for (Interval occupationInterval : this.getIntervals()) {
                if (!occupationInterval.overlaps((ReadableInterval)interval)) continue;
                return true;
            }
        }
        return false;
    }

    public Boolean isActive() {
        return this.getIntervals().stream().anyMatch(interval -> interval.contains((ReadableInstant)DateTime.now()));
    }

    public String getSummary() {
        return this.getConfig().getSummary();
    }

    public String getExtendedSummary() {
        return this.getConfig().getExtendedSummary();
    }

    public DateTime getStart() {
        return this.getConfig().getStart();
    }

    public DateTime getEnd() {
        return this.getConfig().getEnd();
    }

    public void delete() {
        if (this.getRequest() != null) {
            this.setRequest(null);
        }
        this.setBennu(null);
        this.getSpaceSet().clear();
        super.deleteDomainObject();
    }

    public boolean canManageOccupation(User user) {
        for (Space space : this.getSpaces()) {
            if (space.isOccupationMember(user)) continue;
            return false;
        }
        return true;
    }

    public String getInfo() {
        return "";
    }

    public String getUrl() {
        if (!((Object)((Object)this)).getClass().equals(Occupation.class)) {
            return "";
        }
        if (this.canManageOccupation(Authenticate.getUser())) {
            return CoreConfiguration.getConfiguration().applicationUrl() + "/spaces/occupations/view/" + this.getOid().toString();
        }
        return "";
    }

    public String getType() {
        return BundleUtil.getString((String)"resources/FenixEduSpacesResources", (String)"Generic", (String[])new String[0]);
    }
}

