/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.qubdocs.academic.documentRequests.providers;

import com.qubit.terra.docs.util.IDocumentFieldsData;
import com.qubit.terra.docs.util.IReportDataProvider;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.fenixedu.academic.domain.CompetenceCourse;
import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumLine;

public class CompetenceCoursesDataProvider
implements IReportDataProvider {
    private static final String KEY = "competenceCourses";
    Set<CompetenceCourseWrapper> competenceCourseWrapper = new HashSet<CompetenceCourseWrapper>();

    public CompetenceCoursesDataProvider(Collection<? extends CurriculumLine> curriculumLines) {
        for (CurriculumLine curriculumLine : curriculumLines) {
            this.competenceCourseWrapper.add(new CompetenceCourseWrapper(curriculumLine.getCurricularCourse().getCompetenceCourse()).withExecutionInterval(curriculumLine.getExecutionPeriod()));
        }
    }

    public boolean handleKey(String key) {
        return KEY.equals(key);
    }

    public void registerFieldsAndImages(IDocumentFieldsData documentFieldsData) {
        documentFieldsData.registerCollectionAsField(KEY);
    }

    public Object valueForKey(String key) {
        return this.handleKey(KEY) ? this.competenceCourseWrapper : null;
    }

    public static class CompetenceCourseWrapper {
        protected CompetenceCourse competenceCourse;
        protected ExecutionInterval executionInterval;

        public CompetenceCourseWrapper(CompetenceCourse competenceCourse) {
            this.competenceCourse = competenceCourse;
        }

        public CompetenceCourseWrapper withExecutionInterval(ExecutionInterval executionInterval) {
            this.executionInterval = executionInterval;
            return this;
        }

        public String getName() {
            return this.competenceCourse.getName();
        }

        public String getExecutionYear() {
            return this.executionInterval.getExecutionYear().getName();
        }

        public String getAutonomousWorkHours() {
            return new BigDecimal(this.competenceCourse.getAutonomousWorkHours(this.executionInterval)).toPlainString();
        }

        public String getTotalHours() {
            return new BigDecimal(this.competenceCourse.getTotalLoad(this.executionInterval)).toPlainString();
        }

        public String getContactHours() {
            return new BigDecimal(this.competenceCourse.getContactLoad(this.executionInterval)).toPlainString();
        }
    }
}

