/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.qubdocs.base.providers;

import com.qubit.terra.docs.util.IDocumentFieldsData;
import com.qubit.terra.docs.util.IReportDataProvider;
import fr.opensagres.xdocreport.template.formatter.NullImageBehaviour;
import java.util.Locale;
import org.fenixedu.academic.domain.person.Gender;
import org.fenixedu.commons.i18n.LocalizedString;

public class InstitutionConfigurationReportDataProvider
implements IReportDataProvider {
    protected static final String KEY_LOGO = "institutionLogo";
    protected static final String KEY_NAME = "institutionName";
    protected static final String KEY_SHORT_NAME = "institutionShortName";
    protected static final String KEY_ADDRESS = "institutionAddress";
    protected static final String KEY_SITE = "institutionSite";
    protected static final String KEY_PREPOSITION = "institutionGender";
    private final LocalizedString institutionName;
    private final LocalizedString institutionShortName;
    private final String institutionAddress;
    private final String institutionSite;
    private final byte[] institutionLogo;
    private final boolean showLogo;
    private final Locale language;

    public InstitutionConfigurationReportDataProvider(LocalizedString name, LocalizedString shortName, String address, String site, byte[] image, boolean showLogo, Locale language) {
        this.institutionName = name;
        this.institutionShortName = shortName;
        this.institutionAddress = address;
        this.institutionSite = site;
        this.institutionLogo = image;
        this.showLogo = showLogo;
        this.language = language;
    }

    public void registerFieldsAndImages(IDocumentFieldsData documentFieldsData) {
        if (this.institutionLogo.length == 0 || !this.showLogo) {
            documentFieldsData.registerImageNullBehaviour(KEY_LOGO, NullImageBehaviour.RemoveImageTemplate);
            return;
        }
        documentFieldsData.registerImage(KEY_LOGO, this.institutionLogo);
    }

    public boolean handleKey(String key) {
        return key.equals(KEY_NAME) || key.equals(KEY_SHORT_NAME) || key.equals(KEY_ADDRESS) || key.equals(KEY_SITE) || key.equals(KEY_PREPOSITION);
    }

    public Object valueForKey(String key) {
        if (key.equals(KEY_NAME)) {
            return this.institutionName.getContent(this.language);
        }
        if (key.equals(KEY_SHORT_NAME)) {
            return this.institutionShortName.getContent(this.language);
        }
        if (key.equals(KEY_SITE)) {
            return this.institutionSite;
        }
        if (key.equals(KEY_ADDRESS)) {
            return this.institutionAddress;
        }
        if (key.equals(KEY_PREPOSITION)) {
            return this.getPreposition();
        }
        return null;
    }

    public Gender getPreposition() {
        if (this.institutionName.getContent(this.language).startsWith("Inst")) {
            return Gender.MALE;
        }
        return Gender.FEMALE;
    }
}

