/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.qubdocs.academic.documentRequests.providers;

import com.qubit.terra.docs.util.IDocumentFieldsData;
import com.qubit.terra.docs.util.IReportDataProvider;
import java.math.BigDecimal;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.serviceRequests.AcademicServiceRequest;
import org.fenixedu.academic.domain.treasury.IAcademicServiceRequestAndAcademicTaxTreasuryEvent;
import org.fenixedu.academic.domain.treasury.IAcademicTreasuryEvent;
import org.fenixedu.academic.domain.treasury.TreasuryBridgeAPIFactory;
import org.fenixedu.qubdocs.util.reports.helpers.MoneyHelper;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class ServiceRequestDataProvider
implements IReportDataProvider {
    protected static final String KEY = "serviceRequest";
    protected static final String KEY_HAS_PRICETAG = "hasPricetag";
    protected static final String KEY_FOR_PRICE = "serviceRequestPrice";
    protected static final String KEY_FOR_PRICE_TAG = "priceTag";
    protected static final String KEY_FOR_EXECUTION_YEAR_INFORMATION = "executionYearInformation";
    protected static final String KEY_EXECUTION_YEAR = "executionYearName";
    protected static final String KEY_PREVIOUS_EXECUTION_YEAR = "previousExecutionYearName";
    protected AcademicServiceRequest serviceRequest;
    protected ExecutionYearBean executionYearBean;

    public ServiceRequestDataProvider(AcademicServiceRequest serviceRequest, ExecutionYear executionYear) {
        this.serviceRequest = serviceRequest;
        this.executionYearBean = new ExecutionYearBean(executionYear);
    }

    public void registerFieldsAndImages(IDocumentFieldsData documentFieldsData) {
    }

    public boolean handleKey(String key) {
        return KEY.equals(key) || KEY_HAS_PRICETAG.equals(key) || KEY_FOR_PRICE.equals(key) || KEY_FOR_PRICE_TAG.equals(key) || KEY_FOR_EXECUTION_YEAR_INFORMATION.equals(key) || KEY_EXECUTION_YEAR.equals(key) || KEY_PREVIOUS_EXECUTION_YEAR.equals(key);
    }

    public Object valueForKey(String key) {
        if (KEY.equals(key)) {
            return this.serviceRequest;
        }
        if (KEY_HAS_PRICETAG.equals(key)) {
            IAcademicServiceRequestAndAcademicTaxTreasuryEvent academicTreasuryEvent = TreasuryBridgeAPIFactory.implementation().academicTreasuryEventForAcademicServiceRequest(this.serviceRequest);
            return academicTreasuryEvent != null && academicTreasuryEvent.isCharged();
        }
        if (KEY_FOR_PRICE_TAG.equals(key)) {
            MoneyHelper helper = new MoneyHelper();
            IAcademicServiceRequestAndAcademicTaxTreasuryEvent event = TreasuryBridgeAPIFactory.implementation().academicTreasuryEventForAcademicServiceRequest(this.serviceRequest);
            if (event != null && event.isCharged()) {
                if (!event.getExemptionTypeName(this.serviceRequest.getLanguage()).isEmpty() && event.getAmountToPay().compareTo(BigDecimal.ZERO) == 0) {
                    String exemptionText = event.getExemptionTypeName(this.serviceRequest.getLanguage());
                    return exemptionText;
                }
                if (this.serviceRequest.getLanguage().getLanguage().equals("pt")) {
                    return "Emolumento: " + helper.total((IAcademicTreasuryEvent)event);
                }
                if (this.serviceRequest.getLanguage().getLanguage().equals("en")) {
                    return "Fee: " + helper.total((IAcademicTreasuryEvent)event);
                }
                return "" + helper.total((IAcademicTreasuryEvent)event);
            }
            return "";
        }
        if (KEY_FOR_PRICE.equals(key)) {
            return TreasuryBridgeAPIFactory.implementation().academicTreasuryEventForAcademicServiceRequest(this.serviceRequest);
        }
        if (KEY_FOR_EXECUTION_YEAR_INFORMATION.equals(key)) {
            return this.executionYearBean;
        }
        if (KEY_EXECUTION_YEAR.equals(key)) {
            return this.executionYearBean.getName();
        }
        if (KEY_PREVIOUS_EXECUTION_YEAR.equals(key)) {
            return this.executionYearBean.getPreviousExecutionYearName();
        }
        return null;
    }

    public class ExecutionYearBean {
        protected ExecutionYear executionYear;

        public ExecutionYearBean(ExecutionYear executionYear) {
            this.executionYear = executionYear;
        }

        public String getName() {
            return this.executionYear.getName();
        }

        public String getPreviousExecutionYearName() {
            return this.executionYear.getPreviousExecutionYear().getName();
        }

        public Boolean isBefore(String yearMonthDay) {
            DateTimeFormatter df = DateTimeFormat.forPattern((String)"yyyy-MM-dd");
            DateTime date = df.parseDateTime(yearMonthDay);
            if (date == null) {
                return null;
            }
            ExecutionYear exYear = ExecutionYear.readByDateTime((DateTime)date);
            if (exYear == null) {
                return null;
            }
            return new Boolean(this.executionYear.isBefore(exYear));
        }
    }
}

