/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.qubdocs.academic.documentRequests.providers;

import com.google.common.collect.Sets;
import com.qubit.terra.docs.util.IDocumentFieldsData;
import com.qubit.terra.docs.util.IReportDataProvider;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.fenixedu.academic.domain.degreeStructure.ProgramConclusion;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.dto.student.RegistrationConclusionBean;
import org.fenixedu.qubdocs.academic.documentRequests.providers.CurriculumEntry;
import org.fenixedu.qubdocs.academic.documentRequests.providers.CurriculumEntryRemarksDataProvider;
import org.fenixedu.qubdocs.util.CurriculumEntryServices;

public class CurriculumEntriesDataProvider
implements IReportDataProvider {
    protected static final String KEY = "curriculumEntries";
    protected Registration registration;
    protected ProgramConclusion programConclusion;
    protected CurriculumEntryRemarksDataProvider remarksDataProvider;
    protected Locale locale;
    protected CurriculumEntryServices service;
    protected Set<CurriculumEntry> curriculumEntries;

    public CurriculumEntriesDataProvider(Registration registration, ProgramConclusion programConclusion, CurriculumEntryRemarksDataProvider remarksDataProvider, Locale locale, CurriculumEntryServices service) {
        this.registration = registration;
        this.programConclusion = programConclusion;
        this.remarksDataProvider = remarksDataProvider;
        this.locale = locale;
        this.service = service;
    }

    public void registerFieldsAndImages(IDocumentFieldsData documentFieldsData) {
        documentFieldsData.registerCollectionAsField(KEY);
    }

    public boolean handleKey(String key) {
        return KEY.equals(key);
    }

    public Object valueForKey(String key) {
        if (this.handleKey(key)) {
            return this.getCurriculumEntries();
        }
        return null;
    }

    protected Set<CurriculumEntry> getCurriculumEntries() {
        if (this.curriculumEntries == null) {
            RegistrationConclusionBean conclusionBean = new RegistrationConclusionBean(this.registration, this.programConclusion);
            HashSet curricularYearEntries = Sets.newHashSet((Iterable)conclusionBean.getCurriculumForConclusion().getCurriculumEntries());
            this.curriculumEntries = Sets.newTreeSet((Comparator)new Comparator<CurriculumEntry>(){

                @Override
                public int compare(CurriculumEntry left, CurriculumEntry right) {
                    String leftContent = left.getName().getContent(CurriculumEntriesDataProvider.this.locale) != null ? left.getName().getContent(CurriculumEntriesDataProvider.this.locale) : left.getName().getContent();
                    String rightContent = right.getName().getContent(CurriculumEntriesDataProvider.this.locale) != null ? right.getName().getContent(CurriculumEntriesDataProvider.this.locale) : right.getName().getContent();
                    return leftContent.compareTo(rightContent);
                }
            });
            this.curriculumEntries.addAll(CurriculumEntry.transform(this.registration, curricularYearEntries, this.remarksDataProvider, this.service));
        }
        return this.curriculumEntries;
    }
}

