/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.qubdocs.ui.manageDocumentSignature;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.fenixedu.academic.domain.administrativeOffice.AdministrativeOffice;
import org.fenixedu.academic.domain.person.Gender;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.DocumentSigner;
import org.fenixedu.bennu.core.domain.exceptions.DomainException;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.bennu.spring.portal.SpringFunctionality;
import org.fenixedu.commons.StringNormalizer;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.qubdocs.ui.FenixeduQubdocsReportsBaseController;
import org.fenixedu.qubdocs.ui.FenixeduQubdocsReportsController;
import org.fenixedu.qubdocs.ui.manageDocumentSignature.DocumentSignatureController$callable$createDocumentSignature;
import org.fenixedu.qubdocs.ui.manageDocumentSignature.DocumentSignatureController$callable$deleteDocumentSignature;
import org.fenixedu.qubdocs.ui.manageDocumentSignature.DocumentSignatureController$callable$updateDocumentSignature;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

@SpringFunctionality(app=FenixeduQubdocsReportsController.class, title="label.title.manageDocumentSignature", accessGroup="logged")
@RequestMapping(value={"/qubdocsreports/managedocumentsignature/documentsignature"})
public class DocumentSignatureController
extends FenixeduQubdocsReportsBaseController {
    public static final String CONTROLLER_URL = "/qubdocsreports/managedocumentsignature/documentsignature";
    private static final String SEARCH_URI = "/";
    public static final String SEARCH_URL = "/qubdocsreports/managedocumentsignature/documentsignature/";
    private static final String SEARCH_VIEW_ACTION_URI = "/search/view/";
    public static final String SEARCH_VIEW_ACTION_URL = "/qubdocsreports/managedocumentsignature/documentsignature/search/view/";
    private static final String READ_URI = "/read/";
    public static final String READ_URL = "/qubdocsreports/managedocumentsignature/documentsignature/read/";
    private static final String DELETE_URI = "/delete/";
    public static final String DELETE_URL = "/qubdocsreports/managedocumentsignature/documentsignature/delete/";
    private static final String CREATE_URI = "/create/";
    public static final String CREATE_URL = "/qubdocsreports/managedocumentsignature/documentsignature/create/";
    private static final String UPDATE_URI = "/update/";
    public static final String UPDATE_URL = "/qubdocsreports/managedocumentsignature/documentsignature/update/";
    public static final Advice advice$deleteDocumentSignature = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$createDocumentSignature = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$updateDocumentSignature = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    @RequestMapping
    public String home(Model model) {
        return "forward:/qubdocsreports/managedocumentsignature/documentsignature/";
    }

    private DocumentSigner getDocumentSignature(Model m) {
        return (DocumentSigner)((Object)m.asMap().get("documentSignature"));
    }

    private void setDocumentSignature(DocumentSigner documentSignature, Model m) {
        m.addAttribute("documentSignature", (Object)documentSignature);
    }

    public void deleteDocumentSignature(DocumentSigner documentSigner) {
        Object object = advice$deleteDocumentSignature.perform((Callable)new DocumentSignatureController$callable$deleteDocumentSignature(this, documentSigner));
    }

    static /* synthetic */ void advised$deleteDocumentSignature(DocumentSignatureController this_, DocumentSigner documentSignature) {
        documentSignature.delete();
    }

    @RequestMapping(value={"/"})
    public String search(@RequestParam(value="responsiblename", required=false) String responsibleName, @RequestParam(value="responsiblefunction", required=false) LocalizedString responsibleFunction, @RequestParam(value="responsibleunit", required=false) LocalizedString responsibleUnit, Model model) {
        List<DocumentSigner> searchdocumentsignatureResultsDataSet = this.filterSearchDocumentSignature(responsibleName, responsibleFunction, responsibleUnit);
        model.addAttribute("searchdocumentsignatureResultsDataSet", searchdocumentsignatureResultsDataSet);
        return "qubdocsreports/managedocumentsignature/documentsignature/search";
    }

    private Stream<DocumentSigner> getSearchUniverseSearchDocumentSignatureDataSet() {
        return DocumentSigner.findAll();
    }

    private List<DocumentSigner> filterSearchDocumentSignature(String responsibleName, LocalizedString responsibleFunction, LocalizedString responsibleUnit) {
        return this.getSearchUniverseSearchDocumentSignatureDataSet().filter(documentSignature -> responsibleName == null || responsibleName.length() == 0 || documentSignature.getResponsibleName() != null && documentSignature.getResponsibleName().length() > 0 && this.containsName(documentSignature.getResponsibleName(), responsibleName)).filter(documentSignature -> responsibleFunction == null || responsibleFunction.isEmpty() || responsibleFunction.getLocales().stream().allMatch(locale -> documentSignature.getResponsibleFunction().getContent(locale) != null && documentSignature.getResponsibleFunction().getContent(locale).toLowerCase().contains(responsibleFunction.getContent(locale).toLowerCase()))).filter(documentSignature -> responsibleUnit == null || responsibleUnit.isEmpty() || responsibleUnit.getLocales().stream().allMatch(locale -> documentSignature.getResponsibleUnit().getContent(locale) != null && documentSignature.getResponsibleUnit().getContent(locale).toLowerCase().contains(responsibleUnit.getContent(locale).toLowerCase()))).collect(Collectors.toList());
    }

    private boolean containsName(String fullName, String searchName) {
        String[] splittedSearchName = StringNormalizer.normalizeAndRemoveAccents((String)searchName.toLowerCase().trim()).split("\\s+");
        String fullNameNormalized = StringNormalizer.normalizeAndRemoveAccents((String)fullName.toLowerCase());
        for (String name : splittedSearchName) {
            if (fullNameNormalized.contains(name)) continue;
            return false;
        }
        return true;
    }

    @RequestMapping(value={"/search/view/{oid}"})
    public String processSearchToViewAction(@PathVariable(value="oid") DocumentSigner documentSignature, Model model, RedirectAttributes redirectAttributes) {
        return this.redirect(READ_URL + documentSignature.getExternalId(), model, redirectAttributes);
    }

    @RequestMapping(value={"/read/{oid}"})
    public String read(@PathVariable(value="oid") DocumentSigner documentSignature, Model model) {
        this.setDocumentSignature(documentSignature, model);
        return "qubdocsreports/managedocumentsignature/documentsignature/read";
    }

    @RequestMapping(value={"/delete/{oid}"})
    public String delete(@PathVariable(value="oid") DocumentSigner documentSignature, Model model, RedirectAttributes redirectAttributes) {
        this.setDocumentSignature(documentSignature, model);
        try {
            String responsibleName = documentSignature.getResponsibleName();
            this.deleteDocumentSignature(documentSignature);
            this.addInfoMessage(BundleUtil.getString((String)"resources/FenixeduQubdocsReportsResources", (String)"label.info.documentSignature.successfulDelete", (String[])new String[]{responsibleName}), model);
            return this.redirect(SEARCH_URL, model, redirectAttributes);
        }
        catch (DomainException ex) {
            this.addErrorMessage(BundleUtil.getString((String)"resources/FenixeduQubdocsReportsResources", (String)ex.getKey(), (String[])new String[0]), model);
            return this.redirect(READ_URL + this.getDocumentSignature(model).getExternalId(), model, redirectAttributes);
        }
    }

    @RequestMapping(value={"/create/"}, method={RequestMethod.GET})
    public String create(Model model) {
        model.addAttribute("responsibleGenderValues", (Object)Gender.values());
        return "qubdocsreports/managedocumentsignature/documentsignature/create";
    }

    @RequestMapping(value={"/create/"}, method={RequestMethod.POST})
    public String create(@RequestParam(value="responsiblename", required=true) String responsibleName, @RequestParam(value="responsibleshortname", required=false) String responsibleShortName, @RequestParam(value="responsiblefunction", required=false) LocalizedString responsibleFunction, @RequestParam(value="responsibleunit", required=false) LocalizedString responsibleUnit, @RequestParam(value="responsiblegender", required=false) Gender responsibleGender, Model model, RedirectAttributes redirectAttributes) {
        if (responsibleName.trim().isEmpty()) {
            this.addErrorMessage(BundleUtil.getString((String)"resources/FenixeduQubdocsReportsResources", (String)"error.responsible.name.invalid", (String[])new String[0]), model);
            return this.create(model);
        }
        if (responsibleFunction == null || responsibleFunction.getContent(new Locale("pt")) == null || responsibleFunction.getContent(new Locale("pt")).trim().isEmpty()) {
            this.addErrorMessage(BundleUtil.getString((String)"resources/FenixeduQubdocsReportsResources", (String)"error.responsible.function.empty", (String[])new String[0]), model);
            return this.create(model);
        }
        DocumentSigner documentSignature = this.createDocumentSignature(responsibleName, responsibleShortName, responsibleFunction, responsibleUnit, responsibleGender);
        model.addAttribute("documentSignature", (Object)documentSignature);
        return this.redirect(READ_URL + this.getDocumentSignature(model).getExternalId(), model, redirectAttributes);
    }

    public DocumentSigner createDocumentSignature(String string, String string2, LocalizedString localizedString, LocalizedString localizedString2, Gender gender) {
        return (DocumentSigner)((Object)advice$createDocumentSignature.perform((Callable)new DocumentSignatureController$callable$createDocumentSignature(this, string, string2, localizedString, localizedString2, gender)));
    }

    static /* synthetic */ DocumentSigner advised$createDocumentSignature(DocumentSignatureController this_, String responsibleName, String responsibleShortName, LocalizedString responsibleFunction, LocalizedString responsibleUnit, Gender responsibleGender) {
        return DocumentSigner.create(AdministrativeOffice.readDegreeAdministrativeOffice(), responsibleName, responsibleShortName, responsibleFunction, responsibleUnit, responsibleGender);
    }

    @RequestMapping(value={"/update/{oid}"}, method={RequestMethod.GET})
    public String update(@PathVariable(value="oid") DocumentSigner documentSignature, Model model) {
        model.addAttribute("responsibleGenderValues", (Object)Gender.values());
        this.setDocumentSignature(documentSignature, model);
        return "qubdocsreports/managedocumentsignature/documentsignature/update";
    }

    @RequestMapping(value={"/update/{oid}"}, method={RequestMethod.POST})
    public String update(@PathVariable(value="oid") DocumentSigner documentSignature, @RequestParam(value="responsiblename", required=false) String responsibleName, @RequestParam(value="responsibleshortname", required=false) String responsibleShortName, @RequestParam(value="responsiblefunction", required=false) LocalizedString responsibleFunction, @RequestParam(value="responsibleunit", required=false) LocalizedString responsibleUnit, @RequestParam(value="responsiblegender", required=false) Gender responsibleGender, @RequestParam(value="responsibledefault", required=false) boolean responsibleDefault, Model model, RedirectAttributes redirectAttributes) {
        this.setDocumentSignature(documentSignature, model);
        this.updateDocumentSignature(responsibleName, responsibleShortName, responsibleFunction, responsibleUnit, responsibleGender, responsibleDefault, model);
        return this.redirect(READ_URL + this.getDocumentSignature(model).getExternalId(), model, redirectAttributes);
    }

    public void updateDocumentSignature(String string, String string2, LocalizedString localizedString, LocalizedString localizedString2, Gender gender, boolean bl, Model model) {
        Object object = advice$updateDocumentSignature.perform((Callable)new DocumentSignatureController$callable$updateDocumentSignature(this, string, string2, localizedString, localizedString2, gender, bl, model));
    }

    static /* synthetic */ void advised$updateDocumentSignature(DocumentSignatureController this_, String responsibleName, String responsibleShortName, LocalizedString responsibleFunction, LocalizedString responsibleUnit, Gender responsibleGender, boolean responsibleDefault, Model m) {
        this_.getDocumentSignature(m).edit(responsibleName, responsibleShortName, responsibleFunction, responsibleUnit, responsibleGender, responsibleDefault);
    }
}

