/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.qubdocs.academic.documentRequests.providers;

import com.google.common.collect.Sets;
import com.qubit.terra.docs.util.IDocumentFieldsData;
import java.util.Locale;
import java.util.Set;
import org.fenixedu.academic.domain.Curriculum;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.DegreeOfficialPublication;
import org.fenixedu.academic.domain.degreeStructure.ProgramConclusion;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.dto.student.RegistrationConclusionBean;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.qubdocs.academic.documentRequests.providers.CurriculumEntriesDataProvider;
import org.fenixedu.qubdocs.academic.documentRequests.providers.CurriculumEntry;
import org.fenixedu.qubdocs.academic.documentRequests.providers.CurriculumEntryRemarksDataProvider;
import org.fenixedu.qubdocs.util.CurriculumEntryServices;
import org.fenixedu.qubdocs.util.DocsStringUtils;
import org.joda.time.LocalDate;

public class ScholarPartCurriculumEntries
extends CurriculumEntriesDataProvider {
    protected static final String KEY = "scholarPartCurriculumEntries";
    protected static final String KEY_LIST = "scholarPartCurriculumEntriesList";

    public ScholarPartCurriculumEntries(Registration registration, ProgramConclusion programConclusion, CurriculumEntryRemarksDataProvider remarksDataProvider, Locale locale, CurriculumEntryServices service) {
        super(registration, programConclusion, remarksDataProvider, locale, service);
    }

    private Degree getDegree() {
        return this.registration.getDegree();
    }

    @Override
    public void registerFieldsAndImages(IDocumentFieldsData documentFieldsData) {
        documentFieldsData.registerCollectionAsField(KEY_LIST);
    }

    @Override
    public boolean handleKey(String key) {
        return KEY.equals(key) || KEY_LIST.equals(key);
    }

    @Override
    public Object valueForKey(String key) {
        if (KEY.equals(key)) {
            return this;
        }
        if (KEY_LIST.equals(key)) {
            return this.getCurriculumEntries();
        }
        return null;
    }

    @Override
    protected Set<CurriculumEntry> getCurriculumEntries() {
        return Sets.newHashSet();
    }

    protected Curriculum getCurriculumForConclusion() {
        RegistrationConclusionBean conclusionBean = new RegistrationConclusionBean(this.registration);
        return (Curriculum)conclusionBean.getCurriculumForConclusion();
    }

    public String getAverage() {
        return null;
    }

    public String getRoundedAverage() {
        return null;
    }

    public LocalizedString getRoundedAverageDescription() {
        return DocsStringUtils.capitalize(BundleUtil.getLocalizedString((String)"resources.EnumerationResources", (String)this.getRoundedAverage(), (String[])new String[0]));
    }

    public LocalDate getScholarPartConclusionDate() {
        return null;
    }

    protected DegreeOfficialPublication getDegreeOfficialPublication() {
        return this.getDegree().getOfficialPublication(this.getScholarPartConclusionDate().toDateTimeAtStartOfDay());
    }

    public String getDegreeOfficialPublicationName() {
        if (this.getDegreeOfficialPublication() == null) {
            throw new DomainException("error.DegreeCurricularPlanInformationDataProvider.degreeOfficialPublication.empty", new String[0]);
        }
        return this.getDegreeOfficialPublication().getOfficialReference();
    }

    public LocalDate getDegreeOfficialPublicationDate() {
        if (this.getDegreeOfficialPublication() == null) {
            throw new DomainException("error.DegreeCurricularPlanInformationDataProvider.degreeOfficialPublication.empty", new String[0]);
        }
        return this.getDegreeOfficialPublication().getPublication();
    }
}

