/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.qubdocs.academic.documentRequests.providers;

import com.google.common.collect.Sets;
import com.qubit.terra.docs.util.IDocumentFieldsData;
import com.qubit.terra.docs.util.IReportDataProvider;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.curriculum.ICurriculumEntry;
import org.fenixedu.qubdocs.academic.documentRequests.providers.CurriculumEntry;
import org.fenixedu.qubdocs.academic.documentRequests.providers.CurriculumEntryRemarksDataProvider;
import org.fenixedu.qubdocs.util.CurriculumEntryServices;

public class FlunkedEnrolmentsDataProvider
implements IReportDataProvider {
    protected static final String KEY = "flunkedCurriculumEntries";
    protected static final String KEY_FOR_REMARKS = "flunkedEnrolmentsRemarks";
    protected static final String KEY_FOR_TOTAL_UNITS = "totalFlunkedEnrolments";
    protected static final String KEY_FOR_TOTAL_ECTS = "totalFlunkedECTS";
    protected Registration registration;
    protected CurriculumEntryRemarksDataProvider remarksDataProvider;
    protected Locale locale;
    protected Collection<ICurriculumEntry> flunkedEnrolments;
    protected Set<CurriculumEntry> curriculumEntries;
    protected CurriculumEntryServices service;

    public FlunkedEnrolmentsDataProvider(Registration registration, Collection<ICurriculumEntry> flunkedEnrolments, Locale locale, CurriculumEntryServices service) {
        this.registration = registration;
        this.locale = locale;
        this.remarksDataProvider = new CurriculumEntryRemarksDataProvider(registration);
        this.flunkedEnrolments = flunkedEnrolments;
        this.service = service;
        this.init();
    }

    public void registerFieldsAndImages(IDocumentFieldsData documentFieldsData) {
        documentFieldsData.registerCollectionAsField(KEY);
        documentFieldsData.registerCollectionAsField(KEY_FOR_REMARKS);
    }

    public boolean handleKey(String key) {
        if (this.flunkedEnrolments == null || this.flunkedEnrolments.isEmpty()) {
            return false;
        }
        return KEY.equals(key) || KEY_FOR_REMARKS.equals(key) || KEY_FOR_TOTAL_UNITS.equals(key) || KEY_FOR_TOTAL_ECTS.equals(key);
    }

    public Object valueForKey(String key) {
        if (key.equals(KEY)) {
            return this.getCurriculumEntries();
        }
        if (key.equals(KEY_FOR_REMARKS)) {
            return this.getRemarks();
        }
        if (key.equals(KEY_FOR_TOTAL_UNITS)) {
            return this.getTotalApprovements();
        }
        if (key.equals(KEY_FOR_TOTAL_ECTS)) {
            return this.getFlunkedEcts();
        }
        return null;
    }

    protected Set<CurriculumEntry> getCurriculumEntries() {
        return this.curriculumEntries;
    }

    private int getTotalApprovements() {
        if (this.curriculumEntries == null) {
            return 0;
        }
        return this.curriculumEntries.size();
    }

    private BigDecimal getFlunkedEcts() {
        if (this.curriculumEntries == null) {
            return BigDecimal.ZERO;
        }
        return this.curriculumEntries.stream().map(CurriculumEntry::getEctsCredits).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    private Object getRemarks() {
        return this.remarksDataProvider.valueForKey("curriculumEntryRemarks");
    }

    protected void init() {
        if (this.flunkedEnrolments != null) {
            HashSet entries = Sets.newHashSet(this.flunkedEnrolments);
            this.curriculumEntries = Sets.newTreeSet((Comparator)new Comparator<CurriculumEntry>(){

                @Override
                public int compare(CurriculumEntry left, CurriculumEntry right) {
                    if (left.getExecutionYear() == right.getExecutionYear()) {
                        return this.compareByName(left, right);
                    }
                    return left.getExecutionYear().compareTo(right.getExecutionYear());
                }

                public int compareByName(CurriculumEntry left, CurriculumEntry right) {
                    String leftContent = left.getName().getContent(FlunkedEnrolmentsDataProvider.this.locale) != null ? left.getName().getContent(FlunkedEnrolmentsDataProvider.this.locale) : left.getName().getContent();
                    String rightContent = right.getName().getContent(FlunkedEnrolmentsDataProvider.this.locale) != null ? right.getName().getContent(FlunkedEnrolmentsDataProvider.this.locale) : right.getName().getContent();
                    leftContent = leftContent.toLowerCase();
                    rightContent = rightContent.toLowerCase();
                    return leftContent.compareTo(rightContent);
                }
            });
            this.curriculumEntries.addAll(CurriculumEntry.transform(this.registration, entries, this.remarksDataProvider, this.service));
        }
    }
}

