/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.qubdocs.academic.documentRequests.providers;

import com.google.common.collect.Sets;
import com.qubit.terra.docs.util.IDocumentFieldsData;
import com.qubit.terra.docs.util.IReportDataProvider;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.curriculum.ICurriculumEntry;
import org.fenixedu.qubdocs.academic.documentRequests.providers.CurriculumEntry;
import org.fenixedu.qubdocs.academic.documentRequests.providers.CurriculumEntryRemarksDataProvider;
import org.fenixedu.qubdocs.util.CurriculumEntryServices;

public class EnrolmentsDataProvider
implements IReportDataProvider {
    protected static final String KEY = "enrolments";
    protected Registration registration;
    protected ExecutionYear executionYear;
    protected Locale locale;
    protected List<Enrolments> data;
    protected CurriculumEntryServices service;

    public EnrolmentsDataProvider(Registration registration, Set<ICurriculumEntry> normalEnrolmentsEntries, Set<ICurriculumEntry> standaloneEnrolmentsEntries, Set<ICurriculumEntry> extracurricularEnrolmentsEntries, Set<ICurriculumEntry> enrolmentsInEnrolState, ExecutionYear executionYear, Locale locale, CurriculumEntryServices service) {
        this.registration = registration;
        this.executionYear = executionYear;
        this.locale = locale;
        this.service = service;
        this.data = new ArrayList<Enrolments>();
        if (normalEnrolmentsEntries != null && !normalEnrolmentsEntries.isEmpty()) {
            this.data.add(new Enrolments("normal", locale, registration, normalEnrolmentsEntries, service));
        }
        if (standaloneEnrolmentsEntries != null && !standaloneEnrolmentsEntries.isEmpty()) {
            this.data.add(new Enrolments("standalone", locale, registration, standaloneEnrolmentsEntries, service));
        }
        if (extracurricularEnrolmentsEntries != null && !extracurricularEnrolmentsEntries.isEmpty()) {
            this.data.add(new Enrolments("extracurricular", locale, registration, extracurricularEnrolmentsEntries, service));
        }
        if (enrolmentsInEnrolState != null && !enrolmentsInEnrolState.isEmpty()) {
            this.data.add(new Enrolments("active", locale, registration, enrolmentsInEnrolState, service));
        }
    }

    public void registerFieldsAndImages(IDocumentFieldsData documentFieldsData) {
        for (Enrolments enrolments : this.data) {
            enrolments.registerCollections(documentFieldsData);
        }
    }

    public boolean handleKey(String key) {
        for (Enrolments enrolments : this.data) {
            if (!enrolments.hasKey(key)) continue;
            return true;
        }
        return KEY.equals(key);
    }

    public Object valueForKey(String key) {
        if (KEY.equals(key)) {
            return this;
        }
        for (Enrolments enrolments : this.data) {
            if (!enrolments.hasKey(key)) continue;
            return enrolments.getValue(key);
        }
        return null;
    }

    public static class Enrolments {
        private String hasEnrolmentsKey;
        private String enrolmentsKey;
        private String totalsKey;
        private String ectsKey;
        private String remarksKey;
        private Set<ICurriculumEntry> enrolmentsEntries;
        private TreeSet<CurriculumEntry> curriculumEntries;
        private CurriculumEntryRemarksDataProvider remarksDataProvider;
        private CurriculumEntryServices service;

        public Enrolments(String type, final Locale locale, Registration registration, Set<ICurriculumEntry> enrolmentsEntries, CurriculumEntryServices service) {
            String casedType = type.substring(0, 1).toUpperCase() + type.substring(1);
            this.hasEnrolmentsKey = "has" + casedType + "Enrolments";
            this.enrolmentsKey = type + "EnrolmentsList";
            this.totalsKey = "total" + casedType + "Enrolments";
            this.ectsKey = "total" + casedType + "ECTS";
            this.remarksKey = type + "EnrolmentsRemarks";
            this.enrolmentsEntries = enrolmentsEntries;
            this.remarksDataProvider = new CurriculumEntryRemarksDataProvider(registration);
            this.curriculumEntries = Sets.newTreeSet((Comparator)new Comparator<CurriculumEntry>(){

                @Override
                public int compare(CurriculumEntry left, CurriculumEntry right) {
                    if (left.getExecutionYear() == right.getExecutionYear()) {
                        return this.compareBySemester(left, right);
                    }
                    return left.getExecutionYear().compareTo(right.getExecutionYear());
                }

                public int compareBySemester(CurriculumEntry left, CurriculumEntry right) {
                    if (left.getExecutionSemester() == right.getExecutionSemester()) {
                        return this.compareByName(left, right);
                    }
                    return left.getExecutionSemester().compareTo(right.getExecutionSemester());
                }

                public int compareByName(CurriculumEntry left, CurriculumEntry right) {
                    String leftContent = left.getName().getContent(locale) != null ? left.getName().getContent(locale) : left.getName().getContent();
                    String rightContent = right.getName().getContent(locale) != null ? right.getName().getContent(locale) : right.getName().getContent();
                    leftContent = leftContent.toLowerCase();
                    rightContent = rightContent.toLowerCase();
                    return leftContent.compareTo(rightContent);
                }
            });
            this.curriculumEntries.addAll(CurriculumEntry.transform(registration, this.enrolmentsEntries, this.remarksDataProvider, service));
        }

        public Object getValue(String key) {
            if (key.equals(this.hasEnrolmentsKey)) {
                return this.hasEnrolements();
            }
            if (key.equals(this.enrolmentsKey)) {
                return this.getCurriculumEntries();
            }
            if (key.equals(this.totalsKey)) {
                return this.getTotalEntries();
            }
            if (key.equals(this.ectsKey)) {
                return this.getTotalEcts();
            }
            if (key.equals(this.remarksKey)) {
                return this.getRemarks();
            }
            return null;
        }

        private boolean hasEnrolements() {
            return this.curriculumEntries.size() > 0;
        }

        private TreeSet<CurriculumEntry> getCurriculumEntries() {
            return this.curriculumEntries;
        }

        private int getTotalEntries() {
            return this.curriculumEntries.size();
        }

        private BigDecimal getTotalEcts() {
            return this.curriculumEntries.stream().map(CurriculumEntry::getEctsCredits).reduce(BigDecimal.ZERO, BigDecimal::add);
        }

        private Object getRemarks() {
            return this.remarksDataProvider.valueForKey("curriculumEntryRemarks");
        }

        public void registerCollections(IDocumentFieldsData documentFieldsData) {
            documentFieldsData.registerCollectionAsField(this.enrolmentsKey);
        }

        public boolean hasKey(String key) {
            return key.equals(this.hasEnrolmentsKey) || key.equals(this.enrolmentsKey) || key.equals(this.totalsKey) || key.equals(this.ectsKey) || key.equals(this.remarksKey);
        }
    }
}

