/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.qubdocs.academic.documentRequests.providers;

import com.google.common.collect.Sets;
import com.qubit.terra.docs.util.IDocumentFieldsData;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.fenixedu.academic.domain.degreeStructure.ProgramConclusion;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.DocumentRequest;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.qubdocs.academic.documentRequests.providers.CurriculumEntriesDataProvider;
import org.fenixedu.qubdocs.academic.documentRequests.providers.CurriculumEntry;
import org.fenixedu.qubdocs.academic.documentRequests.providers.CurriculumEntryRemarksDataProvider;
import org.fenixedu.qubdocs.util.CurriculumEntryServices;

public class ApprovementCertificateCurriculumEntries
extends CurriculumEntriesDataProvider {
    protected static final String KEY = "approvementCertificateCurriculumEntries";
    private final DocumentRequest certificateRequest;
    protected CurriculumEntryServices service;

    public ApprovementCertificateCurriculumEntries(DocumentRequest certificateRequest, Registration registration, ProgramConclusion programConclusion, CurriculumEntryRemarksDataProvider remarksDataProvider, Locale locale, CurriculumEntryServices service) {
        super(registration, programConclusion, remarksDataProvider, locale, service);
        this.certificateRequest = certificateRequest;
    }

    @Override
    public void registerFieldsAndImages(IDocumentFieldsData documentFieldsData) {
        documentFieldsData.registerCollectionAsField(KEY);
    }

    @Override
    protected Set<CurriculumEntry> getCurriculumEntries() {
        if (this.curriculumEntries == null) {
            HashSet entries = Sets.newHashSet((Iterable)this.certificateRequest.getApprovedCurriculumEntries());
            this.curriculumEntries = Sets.newTreeSet((Comparator)new Comparator<CurriculumEntry>(){

                @Override
                public int compare(CurriculumEntry left, CurriculumEntry right) {
                    String leftContent = left.getName().getContent(ApprovementCertificateCurriculumEntries.this.locale) != null ? left.getName().getContent(ApprovementCertificateCurriculumEntries.this.locale) : left.getName().getContent();
                    String rightContent = right.getName().getContent(ApprovementCertificateCurriculumEntries.this.locale) != null ? right.getName().getContent(ApprovementCertificateCurriculumEntries.this.locale) : right.getName().getContent();
                    return leftContent.compareTo(rightContent);
                }
            });
            this.curriculumEntries.addAll(CurriculumEntry.transform(this.registration, entries, this.remarksDataProvider, this.service));
        }
        return this.curriculumEntries;
    }

    @Override
    public boolean handleKey(String key) {
        return KEY.equals(key);
    }
}

