/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.legalpt.task;

import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.scheduler.CronTask;
import org.fenixedu.bennu.scheduler.annotation.Task;
import org.fenixedu.ulisboa.specifications.domain.legal.report.LegalReportRequest;
import pt.ist.fenixframework.FenixFramework;

@Task(englishTitle="Process pending legal report request", readOnly=false)
public class ProcessPendingLegalReportRequest
extends CronTask {
    private String pendingRequestId;

    public ProcessPendingLegalReportRequest() {
    }

    public ProcessPendingLegalReportRequest(String pendingRequestId) {
        this.pendingRequestId = pendingRequestId;
    }

    public void runTask() throws Exception {
        if (this.pendingRequestId != null) {
            LegalReportRequest request = (LegalReportRequest)FenixFramework.getDomainObject((String)this.pendingRequestId);
            this.getLogger().info("Process report: " + this.pendingRequestId);
            request.process();
            this.getLogger().info("Finished report: " + this.pendingRequestId);
        } else if (!Bennu.getInstance().getPendingLegalReportRequestsSet().isEmpty()) {
            LegalReportRequest request = (LegalReportRequest)((Object)Bennu.getInstance().getPendingLegalReportRequestsSet().iterator().next());
            this.getLogger().info("Process report: " + request.getExternalId());
            request.process();
            this.getLogger().info("Finished report: " + request.getExternalId());
        }
    }
}

