/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.legalpt.services.raides.process;

import com.google.common.base.Strings;
import java.math.BigDecimal;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.organizationalStructure.Unit;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.RegistrationServices;
import org.fenixedu.academic.domain.student.mobility.MobilityRegistrationInformation;
import org.fenixedu.legalpt.domain.LegalReportContext;
import org.fenixedu.legalpt.services.raides.process.RaidesService;
import org.fenixedu.ulisboa.specifications.domain.legal.mapping.LegalMapping;
import org.fenixedu.ulisboa.specifications.domain.legal.raides.Raides;
import org.fenixedu.ulisboa.specifications.domain.legal.raides.TblMobilidadeInternacional;
import org.fenixedu.ulisboa.specifications.domain.legal.raides.mapping.BranchMappingType;
import org.fenixedu.ulisboa.specifications.domain.legal.raides.mapping.LegalMappingType;
import org.fenixedu.ulisboa.specifications.domain.legal.raides.report.RaidesRequestParameter;
import org.fenixedu.ulisboa.specifications.domain.legal.report.LegalReport;
import org.joda.time.DateTime;
import pt.ist.fenixframework.DomainObject;

public class MobilidadeInternacionalService
extends RaidesService {
    public MobilidadeInternacionalService(LegalReport report) {
        super(report);
    }

    public TblMobilidadeInternacional create(RaidesRequestParameter raidesRequestParameter, ExecutionYear executionYear, Registration registration) {
        Unit institutionUnit = raidesRequestParameter.getInstitution();
        TblMobilidadeInternacional bean = new TblMobilidadeInternacional();
        bean.setRegistration(registration);
        this.preencheInformacaoMatricula(this.report, bean, institutionUnit, executionYear, registration);
        bean.setCurso(null);
        bean.setRamo(null);
        bean.setAnoCurricular(LegalMapping.find(this.report, LegalMappingType.CURRICULAR_YEAR).translate("NAO_APLICAVEL_CODE"));
        DateTime maximumAnnulmentDate = this.findMaximumAnnulmentDate(raidesRequestParameter.getPeriodsForInternationalMobility(), executionYear);
        BigDecimal enrolledEcts = this.enrolledEcts(executionYear, registration, maximumAnnulmentDate, true);
        if (enrolledEcts != null && enrolledEcts.compareTo(BigDecimal.ZERO) > 0) {
            Double enrollectsEctsAsDouble = enrolledEcts.doubleValue();
            if (enrollectsEctsAsDouble != (double)enrollectsEctsAsDouble.intValue() && !enrollectsEctsAsDouble.toString().endsWith(".5")) {
                bean.setEctsInscrito(String.valueOf(Math.round(enrollectsEctsAsDouble)));
            } else {
                bean.setEctsInscrito(enrolledEcts.toString());
            }
        } else {
            bean.setEctsInscrito(null);
        }
        bean.setRegimeFrequencia(this.regimeFrequencia(registration, executionYear));
        MobilityRegistrationInformation mobility = MobilityRegistrationInformation.findInternationalIncomingInformation((Registration)registration, (ExecutionYear)executionYear);
        if (mobility == null) {
            LegalReportContext.addError("", this.i18n("error.Raides.validation.mobility.information.is.missing", Raides.formatArgs(registration, executionYear)), new String[0]);
            bean.markAsInvalid();
            return bean;
        }
        if (mobility.getMobilityProgramType() != null) {
            bean.setProgMobilidade(LegalMapping.find(this.report, LegalMappingType.INTERNATIONAL_MOBILITY_PROGRAM).translate((DomainObject)mobility.getMobilityProgramType()));
            if ("2".equals(bean.getProgMobilidade()) || "3".equals(bean.getProgMobilidade())) {
                bean.setOutroPrograma(mobility.getMobilityProgramType().getName().getContent());
            }
        } else {
            LegalMapping agreementMapping = LegalMapping.find(this.report, LegalMappingType.INTERNATIONAL_MOBILITY_PROGRAM_AGREEMENT);
            bean.setProgMobilidade(agreementMapping != null && agreementMapping.isKeyDefined(registration.getRegistrationProtocol()) ? agreementMapping.translate((DomainObject)registration.getRegistrationProtocol()) : null);
            if ("2".equals(bean.getProgMobilidade()) || "3".equals(bean.getProgMobilidade())) {
                bean.setOutroPrograma(registration.getRegistrationProtocol().getDescription().getContent());
            }
        }
        if (mobility.getMobilityActivityType() != null) {
            bean.setTipoProgMobilidade(LegalMapping.find(this.report, LegalMappingType.INTERNATIONAL_MOBILITY_ACTIVITY).translate((DomainObject)mobility.getMobilityActivityType()));
        } else {
            bean.setTipoProgMobilidade("1");
        }
        if (mobility.getProgramDuration() != null) {
            bean.setDuracaoPrograma(LegalMapping.find(this.report, LegalMappingType.SCHOOL_PERIOD_DURATION).translate((Enum<?>)mobility.getProgramDuration()));
        }
        if (mobility.getOriginMobilityProgrammeLevel() != null) {
            bean.setNivelCursoOrigem(mobility.getOriginMobilityProgrammeLevel().getCode());
            if (mobility.getOriginMobilityProgrammeLevel().isOtherLevel()) {
                bean.setOutroNivelCurOrigem(mobility.getOtherOriginMobilityProgrammeLevel());
            }
        }
        if (mobility.getDegreeBased()) {
            bean.setCurso(mobility.getDegree().getMinistryCode());
            bean.setRamo(mobility.getBranchCourseGroup() != null ? BranchMappingType.readMapping(this.report).translate((DomainObject)mobility.getBranchCourseGroup()) : "1000017");
            bean.setAreaCientifica(null);
            bean.setNivelCursoDestino(null);
            bean.setOutroNivelCursoDestino(null);
            if (!Raides.isDoctoralDegree(registration)) {
                bean.setAnoCurricular(LegalMapping.find(this.report, LegalMappingType.CURRICULAR_YEAR).translate(String.valueOf(RegistrationServices.getCurricularYear((Registration)registration, (ExecutionYear)executionYear).getResult())));
            }
        } else {
            bean.setCurso("0000");
            bean.setRamo("0000000");
            if (mobility.getMobilityScientificArea() != null) {
                bean.setAreaCientifica(mobility.getMobilityScientificArea().getCode());
            }
            if (mobility.getIncomingMobilityProgrammeLevel() != null) {
                bean.setNivelCursoDestino(mobility.getIncomingMobilityProgrammeLevel().getCode());
                if (mobility.getIncomingMobilityProgrammeLevel().isOtherLevel()) {
                    bean.setOutroNivelCursoDestino(mobility.getOtherIncomingMobilityProgrammeLevel());
                }
            }
        }
        if (mobility.hasCountry()) {
            bean.setPaisOrigemMobilidadeCredito(mobility.getCountry().getCode());
        }
        this.validaProgramaMobilidade(executionYear, registration, bean);
        this.validaDuracaoPrograma(executionYear, registration, bean);
        this.validaNivelCursoOrigem(executionYear, registration, bean);
        this.validaCursoAreaCientificaNivelCursoDestino(executionYear, registration, bean);
        this.validaRegimeFrequencia(executionYear, registration, bean);
        return bean;
    }

    private void validaProgramaMobilidade(ExecutionYear executionYear, Registration registration, TblMobilidadeInternacional bean) {
        if (Strings.isNullOrEmpty((String)bean.getProgMobilidade())) {
            LegalReportContext.addError("", this.i18n("error.Raides.validation.mobility.program.type.empty", Raides.formatArgs(registration, executionYear)), new String[0]);
            bean.markAsInvalid();
        }
    }

    private void validaDuracaoPrograma(ExecutionYear executionYear, Registration registration, TblMobilidadeInternacional bean) {
        if (Strings.isNullOrEmpty((String)bean.getDuracaoPrograma())) {
            LegalReportContext.addError("", this.i18n("error.Raides.validation.mobility.program.duration.empty", Raides.formatArgs(registration, executionYear)), new String[0]);
            bean.markAsInvalid();
        }
    }

    protected void validaNivelCursoOrigem(ExecutionYear executionYear, Registration registration, TblMobilidadeInternacional bean) {
        if (Strings.isNullOrEmpty((String)bean.getNivelCursoOrigem())) {
            LegalReportContext.addError("", this.i18n("error.Raides.validation.mobility.provenance.school.level.empty", Raides.formatArgs(registration, executionYear)), new String[0]);
            bean.markAsInvalid();
        } else if ("4".equals(bean.getNivelCursoOrigem()) && Strings.isNullOrEmpty((String)bean.getOutroNivelCurOrigem())) {
            LegalReportContext.addError("", this.i18n("error.Raides.validation.mobility.other.provenance.school.level.empty", Raides.formatArgs(registration, executionYear)), new String[0]);
            bean.markAsInvalid();
        }
    }

    private void validaCursoAreaCientificaNivelCursoDestino(ExecutionYear executionYear, Registration registration, TblMobilidadeInternacional bean) {
        if ("0000".equals(bean.getCurso())) {
            if (Strings.isNullOrEmpty((String)bean.getAreaCientifica())) {
                LegalReportContext.addError("", this.i18n("error.Raides.validation.mobility.scientifica.area.cannot.be.empty.for.other.degree", Raides.formatArgs(registration, executionYear)), new String[0]);
                bean.markAsInvalid();
            }
            if (Strings.isNullOrEmpty((String)bean.getNivelCursoDestino())) {
                LegalReportContext.addError("", this.i18n("error.Raides.validation.mobility.incoming.mobility.program.level.cannot.be.empty.for.other.degree", Raides.formatArgs(registration, executionYear)), new String[0]);
                bean.markAsInvalid();
            }
        }
    }

    private void validaRegimeFrequencia(ExecutionYear executionYear, Registration registration, TblMobilidadeInternacional bean) {
        if (StringUtils.isEmpty((String)bean.getRegimeFrequencia())) {
            LegalReportContext.addError("", this.i18n("error.Raides.validation.missing.mapping.for.regime.frequence", registration.getDegree().getPresentationName() + " [" + registration.getDegree().getCode() + "]"), new String[0]);
            bean.markAsInvalid();
        }
    }
}

