/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.legalpt.dto.a3es;

import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.bennu.IBean;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.legalpt.services.a3es.process.A3esExportService;
import org.json.simple.JSONObject;
import org.jsoup.Jsoup;

public class A3esBeanField
implements IBean {
    public static final String CUT = " ...";
    private String id;
    private String label;
    private Locale locale;
    private String value;
    private Integer limit;
    private String report;
    private String reportType;

    private A3esBeanField() {
    }

    protected static A3esBeanField create(String id, String fieldName, Locale locale, LocalizedString source, int size) {
        String value = source == null ? null : source.getContent(locale);
        return A3esBeanField.create(id, fieldName, locale, value, size);
    }

    protected static A3esBeanField create(String id, String fieldName, String source, int size) {
        return A3esBeanField.create(id, fieldName, (Locale)null, source, size);
    }

    private static A3esBeanField create(String id, String fieldName, Locale locale, String source, int limit) {
        Object value;
        A3esBeanField result = new A3esBeanField();
        result.setId(id);
        result.setLocale(locale);
        result.setLimit(limit);
        String language = locale == null ? "" : " (" + locale.getDisplayLanguage() + ")";
        String labelKey = "label." + fieldName;
        String label = A3esExportService.i18n(labelKey, new String[0]) + language;
        result.setLabel(label);
        Object object = StringUtils.isBlank((String)source) ? null : (value = limit == A3esExportService._UNSUPPORTED ? source : JSONObject.escape((String)Jsoup.parse((String)source).text()).replace("\\u2022", "-").replace("\\/", "|"));
        if (StringUtils.isBlank((String)value)) {
            if (limit == A3esExportService._UNSUPPORTED) {
                result.addReport(A3esBeanField.labelFieldUnsupported(), "info");
            } else {
                result.addReport(A3esBeanField.labelFieldMissing(), "error");
            }
        } else if (limit > 0) {
            int length = ((String)value).length();
            if (length > limit) {
                result.addReport(A3esExportService.i18n("label.field.cut", String.valueOf(limit)), "error");
                value = ((String)value).substring(0, limit - 4 - (length - ((String)value).length())) + CUT;
            } else {
                result.addReport(A3esExportService.i18n("label.field.status", String.valueOf(limit - length), String.valueOf(limit)), "-");
            }
        }
        result.setValue((String)value);
        return result;
    }

    public static String labelFieldMissing() {
        return A3esExportService.label("field.missing");
    }

    private static String labelFieldUnsupported() {
        return A3esExportService.label("field.unsupported");
    }

    public static String labelFieldCutInfo() {
        return A3esExportService.label("field.cut.info");
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public String getLanguage() {
        return this.locale == null ? null : this.locale.getLanguage();
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public String getReport() {
        return this.report;
    }

    public void setReport(String report) {
        this.report = report;
    }

    public String getReportType() {
        return this.reportType;
    }

    public void setReportType(String reportType) {
        this.reportType = reportType;
    }

    public void addReport(String report, String reportType) {
        this.setReport(report);
        this.setReportType(reportType);
    }
}

