/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.ulisboa.specifications.domain.legal.raides.mapping;

import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.degreeStructure.CourseGroup;
import org.fenixedu.commons.i18n.I18N;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.legalpt.dto.mapping.LegalMappingBean;
import org.fenixedu.legalpt.util.LegalPTUtil;
import org.fenixedu.ulisboa.specifications.domain.legal.mapping.DomainObjectLegalMapping;
import org.fenixedu.ulisboa.specifications.domain.legal.mapping.ILegalMappingType;
import org.fenixedu.ulisboa.specifications.domain.legal.mapping.LegalMapping;
import org.fenixedu.ulisboa.specifications.domain.legal.mapping.LegalMappingEntry;
import org.fenixedu.ulisboa.specifications.domain.legal.raides.mapping.BranchMappingType$callable$readMapping;
import org.fenixedu.ulisboa.specifications.domain.legal.report.LegalReport;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class BranchMappingType
implements ILegalMappingType {
    protected static final String CODE = "BRANCH_MAPPING";
    protected static BranchMappingType _instance;
    public static final Advice advice$readMapping;

    protected BranchMappingType() {
    }

    @Override
    public String getCode() {
        return CODE;
    }

    @Override
    public LocalizedString getName() {
        return LegalPTUtil.bundleI18N(this.getQualifiedNameKey(), new String[0]);
    }

    @Override
    public LocalizedString getDescription() {
        return LegalPTUtil.bundleI18N(this.getQualifiedDescriptionKey(), new String[0]);
    }

    @Override
    public LocalizedString getLocalizedNameKey(String key) {
        CourseGroup branch = this.getCourseGroup(key);
        return new LocalizedString(I18N.getLocale(), branch.getOneFullName());
    }

    public Set<LegalMappingEntry> getMappingEntries(LegalMapping mapping, DegreeCurricularPlan degreeCurricularPlan) {
        Set entriesSet = mapping.getLegalMappingEntriesSet();
        HashSet result = Sets.newHashSet();
        for (LegalMappingEntry LegalMappingEntry2 : entriesSet) {
            CourseGroup courseGroup = this.getCourseGroup(LegalMappingEntry2.getMappingKey());
            if (courseGroup.getParentDegreeCurricularPlan() != degreeCurricularPlan) continue;
            result.add(LegalMappingEntry2);
        }
        return result;
    }

    public Set<?> getValues(DegreeCurricularPlan degreeCurricularPlan) {
        return degreeCurricularPlan.getAllBranches();
    }

    public static final BranchMappingType getInstance() {
        if (_instance == null) {
            _instance = new BranchMappingType();
        }
        return _instance;
    }

    public static synchronized LegalMapping readMapping(LegalReport legalReport) {
        return (LegalMapping)((Object)advice$readMapping.perform((Callable)new BranchMappingType$callable$readMapping(legalReport)));
    }

    static synchronized /* synthetic */ LegalMapping advised$readMapping(LegalReport report) {
        LegalMapping mapping = LegalMapping.find(report, BranchMappingType.getInstance());
        if (mapping == null) {
            LegalMappingBean bean = new LegalMappingBean(report);
            mapping = BranchMappingType.getInstance().createMapping(bean.getReport());
        }
        return mapping;
    }

    public static final boolean isTypeForMapping(String type) {
        return CODE.equals(type);
    }

    @Override
    public LegalMapping createMapping(LegalReport report) {
        return new DomainObjectLegalMapping(report, this);
    }

    protected CourseGroup getCourseGroup(String key) {
        return (CourseGroup)FenixFramework.getDomainObject((String)key);
    }

    protected String getQualifiedNameKey() {
        return this.getClass().getName() + ".name";
    }

    protected String getQualifiedDescriptionKey() {
        return this.getClass().getName() + ".description";
    }

    static {
        advice$readMapping = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        _instance = null;
    }
}

