/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.legalpt.services.a3es.process;

import java.math.BigDecimal;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.DegreeInfo;
import org.fenixedu.academic.domain.ExecutionDegree;
import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.degree.DegreeType;
import org.fenixedu.academic.domain.organizationalStructure.UniversityUnit;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.legalpt.dto.a3es.A3esDegreeBean;
import org.fenixedu.legalpt.dto.a3es.A3esProcessBean;
import org.fenixedu.legalpt.services.a3es.process.A3esExportService;

public class A3esHarvestDegreeDataService {
    private final ExecutionYear year;
    private final DegreeCurricularPlan degreeCurricularPlan;
    private final Degree degree;
    private final DegreeInfo info;

    public A3esHarvestDegreeDataService(A3esProcessBean bean) {
        this.year = bean.getExecutionYear();
        this.degreeCurricularPlan = bean.getDegreeCurricularPlan();
        this.degree = this.degreeCurricularPlan.getDegree();
        this.info = this.degree.getMostRecentDegreeInfo(this.year.getAcademicInterval());
        A3esDegreeBean data = bean.getDegreeData();
        A3esHarvestDegreeDataService.fillInstitutionName(data);
        A3esHarvestDegreeDataService.fillSchoolName(data);
        this.fillDegreeName(data);
        this.fillDegreeType(data);
        this.fillMainScientificArea(data);
        this.fillEctsCredits(data);
        this.fillDegreeDuration(data);
        this.fillNumerusClausus(data);
        this.fillIngressionSpecificConditions(data);
        this.fillBranches(data);
        this.fillRegistrationRegime(data);
        this.fillCoordinators(data);
    }

    private static void fillInstitutionName(A3esDegreeBean data) {
        data.addField("q-a1_name", "higherEducationInstitution", UniversityUnit.getInstitutionsUniversityUnit().getName(), A3esExportService._UNLIMITED);
    }

    private static void fillSchoolName(A3esDegreeBean data) {
        data.addField("ext-comp-1625", "organicUnit", Bennu.getInstance().getInstitutionUnit().getName(), A3esExportService._UNLIMITED);
    }

    private void fillDegreeName(A3esDegreeBean data) {
        LocalizedString source = this.degree.getNameI18N();
        data.addField("q-II.1.3_pt", "plan", A3esExportService.PT, source, A3esExportService._UNLIMITED);
        data.addField("q-II.1.3_en", "plan", A3esExportService.EN, source, A3esExportService._UNLIMITED);
    }

    private void fillDegreeType(A3esDegreeBean data) {
        DegreeType degreeType = this.degree.getDegreeType();
        data.addField("q-II.1.4_name", "degreeType", degreeType.getName().getContent(A3esExportService.PT), A3esExportService._UNLIMITED);
    }

    private void fillMainScientificArea(A3esDegreeBean data) {
        LocalizedString source = this.info.getPrevailingScientificArea();
        data.addField("q-II.1.6_pt", "mainScientificArea", A3esExportService.PT, source, A3esExportService._UNLIMITED);
        data.addField("q-II.1.6_en", "mainScientificArea", A3esExportService.EN, source, A3esExportService._UNLIMITED);
    }

    private void fillEctsCredits(A3esDegreeBean data) {
        Double source = this.degreeCurricularPlan.getRoot().getMinEctsCredits(this.year.getFirstExecutionPeriod());
        data.addField("q-II.1.8", "ectsCredits", BigDecimal.valueOf(source).stripTrailingZeros().toPlainString(), A3esExportService._UNLIMITED);
    }

    private void fillDegreeDuration(A3esDegreeBean data) {
        LocalizedString source = this.info.getExtendedDegreeInfo().getStudyProgrammeDuration();
        data.addField("q-II.1.9_pt", "degreeDuration", A3esExportService.PT, source, A3esExportService._UNLIMITED);
        data.addField("q-II.1.9_en", "degreeDuration", A3esExportService.EN, source, A3esExportService._UNLIMITED);
    }

    private void fillNumerusClausus(A3esDegreeBean data) {
        Integer drifts = this.info.getDriftsInitial();
        String source = drifts == null ? null : String.valueOf(drifts);
        data.addField("q-II.1.10", "numerusClausus", source, A3esExportService._100);
    }

    private void fillIngressionSpecificConditions(A3esDegreeBean data) {
        data.addField("testIngression_pt", "testIngression", A3esExportService.PT, this.info.getTestIngression(), A3esExportService._1000);
        data.addField("testIngression_en", "testIngression", A3esExportService.EN, this.info.getTestIngression(), A3esExportService._1000);
        data.addField("accessRequisites_pt", "accessRequisites", A3esExportService.PT, this.info.getAccessRequisites(), A3esExportService._1000);
        data.addField("accessRequisites_en", "accessRequisites", A3esExportService.EN, this.info.getAccessRequisites(), A3esExportService._1000);
        LocalizedString source = this.info.getClassifications();
        data.addField("q-II.1.11_pt", "ingressionSpecificConditions", A3esExportService.PT, source, A3esExportService._1000);
        data.addField("q-II.1.11_en", "ingressionSpecificConditions", A3esExportService.EN, source, A3esExportService._1000);
    }

    private void fillRegistrationRegime(A3esDegreeBean data) {
        LocalizedString source = this.info.getExtendedDegreeInfo().getStudyRegime();
        data.addField("q-II.1.12.1_pt", "registrationRegime", A3esExportService.PT, source, A3esExportService._100);
        data.addField("q-II.1.12.1_en", "registrationRegime", A3esExportService.EN, source, A3esExportService._100);
    }

    private void fillBranches(A3esDegreeBean data) {
        Set majors = this.degreeCurricularPlan.getMajorBranches().stream().map(i -> i.getNameI18N((ExecutionInterval)this.year)).collect(Collectors.toSet());
        Set minors = this.degreeCurricularPlan.getMinorBranches().stream().map(i -> i.getNameI18N((ExecutionInterval)this.year)).collect(Collectors.toSet());
        Stream<String> ptStream = Stream.concat(majors.stream().map(i -> i.getContent(A3esExportService.PT)), minors.stream().map(i -> i.getContent(A3esExportService.PT)));
        Stream<String> enStream = Stream.concat(majors.stream().map(i -> i.getContent(A3esExportService.EN)), minors.stream().map(i -> i.getContent(A3esExportService.EN)));
        String pt = ptStream.collect(Collectors.joining(A3esExportService.SEMICOLON));
        String en = enStream.collect(Collectors.joining(A3esExportService.SEMICOLON));
        LocalizedString source = A3esExportService.createMLS(pt, en);
        data.addField("branches", "branches", A3esExportService.PT, source, A3esExportService._200);
        data.addField("branches", "branches", A3esExportService.EN, source, A3esExportService._200);
    }

    private void fillCoordinators(A3esDegreeBean data) {
        String source = null;
        ExecutionDegree executionDegree = this.degreeCurricularPlan.getExecutionDegreeByYear(this.year);
        if (executionDegree != null) {
            source = executionDegree.getCoordinatorsListSet().stream().map(coordinator -> coordinator.getPerson().getName() + (coordinator.isResponsible() ? " (" + A3esExportService.label("responsable") + ")" : "")).collect(Collectors.joining(A3esExportService.PLUS));
        }
        data.addField("q-II.3.1", "coordinators", source, A3esExportService._1000);
    }
}

