/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.legalpt.domain.a3es;

import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.legalpt.domain.a3es.A3esPeriod$callable$create;
import org.fenixedu.legalpt.domain.a3es.A3esPeriod$callable$delete;
import org.fenixedu.legalpt.domain.a3es.A3esPeriod$callable$edit;
import org.fenixedu.legalpt.domain.a3es.A3esPeriod_Base;
import org.fenixedu.legalpt.domain.a3es.A3esProcessType;
import org.fenixedu.legalpt.domain.exceptions.LegalPTDomainException;
import org.fenixedu.legalpt.util.LegalPTUtil;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class A3esPeriod
extends A3esPeriod_Base {
    public static final Advice advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$create = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$edit = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    protected A3esPeriod() {
        this.setRoot(Bennu.getInstance());
    }

    public void delete() {
        Object object = advice$delete.perform((Callable)new A3esPeriod$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(A3esPeriod this_) {
        this_.setRoot(null);
        this_.setExecutionYear(null);
        super.deleteDomainObject();
    }

    protected void checkForDeletionBlockers(Collection<String> blockers) {
        super.checkForDeletionBlockers(blockers);
        if (!this.getProcessSet().isEmpty()) {
            blockers.add(LegalPTUtil.bundle("error.A3esPeriod.has.A3esProcess", new String[0]));
        }
    }

    protected void init(ExecutionYear year, A3esProcessType type, DateTime fillInDateBegin, DateTime fillInDateEnd) {
        this.setType(type);
        this.setExecutionYear(year);
        this.setFillInDateBegin(fillInDateBegin);
        this.setFillInDateEnd(fillInDateEnd);
        this.checkRules();
    }

    public void checkRules() {
        if (this.getExecutionYear() == null) {
            throw new LegalPTDomainException("error.A3esPeriod.executionYear.required", new String[0]);
        }
        if (this.getType() == null) {
            throw new LegalPTDomainException("error.A3esPeriod.type.required", new String[0]);
        }
        if (A3esPeriod.find(this.getExecutionYear(), this.getType(), null, null).size() != 1) {
            throw new LegalPTDomainException("error.A3esPeriod.duplicated", new String[0]);
        }
        if (this.getFillInDateBegin() == null) {
            throw new LegalPTDomainException("error.A3esPeriod.fillInDateBegin.required", new String[0]);
        }
        if (this.getFillInDateEnd() == null) {
            throw new LegalPTDomainException("error.A3esPeriod.fillInDateEnd.required", new String[0]);
        }
        if (this.getFillInDateInterval() == null) {
            throw new LegalPTDomainException("error.A3esPeriod.fillInInterval.inconsistent", new String[0]);
        }
    }

    public static A3esPeriod create(ExecutionYear executionYear, A3esProcessType a3esProcessType, DateTime dateTime, DateTime dateTime2) {
        return (A3esPeriod)((Object)advice$create.perform((Callable)new A3esPeriod$callable$create(executionYear, a3esProcessType, dateTime, dateTime2)));
    }

    static /* synthetic */ A3esPeriod advised$create(ExecutionYear year, A3esProcessType type, DateTime fillInDateBegin, DateTime fillInDateEnd) {
        A3esPeriod result = new A3esPeriod();
        result.init(year, type, fillInDateBegin, fillInDateEnd);
        return result;
    }

    public A3esPeriod edit(DateTime dateTime, DateTime dateTime2) {
        return (A3esPeriod)((Object)advice$edit.perform((Callable)new A3esPeriod$callable$edit(this, dateTime, dateTime2)));
    }

    static /* synthetic */ A3esPeriod advised$edit(A3esPeriod this_, DateTime fillInDateBegin, DateTime fillInDateEnd) {
        this_.init(this_.getExecutionYear(), this_.getType(), fillInDateBegin, fillInDateEnd);
        return this_;
    }

    public static Set<A3esPeriod> find(ExecutionYear year, A3esProcessType type, DateTime fillInDateBegin, DateTime fillInDateEnd) {
        return year == null ? Sets.newHashSet() : year.getA3esPeriodSet().stream().filter(i -> type == null || i.getType() == type).filter(i -> fillInDateBegin == null || i.getFillInDateBegin().isAfter((ReadableInstant)fillInDateBegin)).filter(i -> fillInDateEnd == null || i.getFillInDateEnd().isBefore((ReadableInstant)fillInDateEnd)).collect(Collectors.toSet());
    }

    public Interval getFillInDateInterval() {
        Interval result = null;
        try {
            result = new Interval((ReadableInstant)this.getFillInDateBegin(), (ReadableInstant)this.getFillInDateEnd());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return result;
    }

    public Boolean isInFillingPeriod() {
        return this.getFillInDateInterval().containsNow();
    }

    public String getDescription() {
        ExecutionYear year = this.getExecutionYear();
        String yearName = year.getQualifiedName();
        return String.format("%s/%s%s", this.getType().getCode(), yearName.substring(2, 4), yearName.substring(7));
    }
}

