/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.legalpt.ui.a3es;

import com.google.common.collect.Sets;
import java.util.Set;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.bennu.spring.portal.SpringFunctionality;
import org.fenixedu.legalpt.domain.a3es.A3esPeriod;
import org.fenixedu.legalpt.domain.a3es.A3esProcessType;
import org.fenixedu.legalpt.dto.a3es.A3esPeriodBean;
import org.fenixedu.legalpt.ui.FenixeduLegalPTBaseController;
import org.fenixedu.legalpt.ui.FenixeduLegalPTController;
import org.fenixedu.legalpt.util.LegalPTUtil;
import org.joda.time.DateTime;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Component(value="org.fenixedu.legalpt.ui.a3es.period")
@SpringFunctionality(app=FenixeduLegalPTController.class, title="label.searchA3esPeriod", accessGroup="#managers")
@RequestMapping(value={"/fenixedu-legal-pt/a3es/period"})
public class A3esPeriodController
extends FenixeduLegalPTBaseController {
    public static final String CONTROLLER_URL = "/fenixedu-legal-pt/a3es/period";
    private static final String JSP_PATH = "/fenixedu-legal-pt/a3es/period".substring(1);
    private static final String _SEARCH_URI = "/";
    public static final String SEARCH_URL = "/fenixedu-legal-pt/a3es/period/";
    private static final String _SEARCHPOSTBACK_URI = "/searchpostback/";
    public static final String SEARCHPOSTBACK_URL = "/fenixedu-legal-pt/a3es/period/searchpostback/";
    private static final String _SEARCH_TO_VIEW_ACTION_URI = "/search/view/";
    public static final String SEARCH_TO_VIEW_ACTION_URL = "/fenixedu-legal-pt/a3es/period/search/view/";
    private static final String _READ_URI = "/read/";
    public static final String READ_URL = "/fenixedu-legal-pt/a3es/period/read/";
    private static final String _DELETE_URI = "/delete/";
    public static final String DELETE_URL = "/fenixedu-legal-pt/a3es/period/delete/";
    private static final String _UPDATE_URI = "/update/";
    public static final String UPDATE_URL = "/fenixedu-legal-pt/a3es/period/update/";
    private static final String _UPDATEPOSTBACK_URI = "/updatepostback/";
    public static final String UPDATEPOSTBACK_URL = "/fenixedu-legal-pt/a3es/period/updatepostback/";
    private static final String _CREATE_URI = "/create/";
    public static final String CREATE_URL = "/fenixedu-legal-pt/a3es/period/create/";
    private static final String _CREATEPOSTBACK_URI = "/createpostback/";
    public static final String CREATEPOSTBACK_URL = "/fenixedu-legal-pt/a3es/period/createpostback/";

    private String jspPage(String page) {
        return JSP_PATH + _SEARCH_URI + page;
    }

    @RequestMapping
    public String home(Model model) {
        return "forward:/fenixedu-legal-pt/a3es/period/";
    }

    private void setBean(A3esPeriodBean bean, Model model) {
        model.addAttribute("periodBeanJson", bean == null ? null : this.getBeanJson(bean));
        model.addAttribute("periodBean", (Object)bean);
    }

    private A3esPeriod getA3esPeriod(Model model) {
        return (A3esPeriod)((Object)model.asMap().get("period"));
    }

    private void setA3esPeriod(A3esPeriod period, Model model) {
        model.addAttribute("period", (Object)period);
    }

    @RequestMapping(value={"/"})
    public String search(Model model) {
        model.addAttribute("searchResults", (Object)Sets.newHashSet());
        A3esPeriodBean bean = new A3esPeriodBean();
        this.setBean(bean, model);
        return this.jspPage("search");
    }

    @RequestMapping(value={"/"}, method={RequestMethod.POST})
    public String search(@RequestParam(value="bean", required=false) A3esPeriodBean bean, Model model) {
        model.addAttribute("searchResults", A3esPeriodController.filterSearch(bean.getType(), bean.getExecutionYear(), bean.getFillInDateBegin(), bean.getFillInDateEnd()));
        this.setBean(bean, model);
        return this.jspPage("search");
    }

    private static Set<A3esPeriod> filterSearch(A3esProcessType type, ExecutionYear year, DateTime fillInDateBegin, DateTime fillInDateEnd) {
        return A3esPeriod.find(year, type, fillInDateBegin, fillInDateEnd);
    }

    @RequestMapping(value={"/searchpostback/"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public ResponseEntity<String> searchpostback(@RequestParam(value="bean", required=false) A3esPeriodBean bean, Model model) {
        bean.updateDataSources();
        this.setBean(bean, model);
        return new ResponseEntity((Object)this.getBeanJson(bean), HttpStatus.OK);
    }

    @RequestMapping(value={"/search/view/{oid}"})
    public String periodSearchToViewAction(@PathVariable(value="oid") A3esPeriod period, Model model, RedirectAttributes redirectAttributes) {
        return this.redirect(READ_URL + period.getExternalId(), model, redirectAttributes);
    }

    @RequestMapping(value={"/read/{oid}"})
    public String read(@PathVariable(value="oid") A3esPeriod period, Model model) {
        this.setA3esPeriod(period, model);
        return this.jspPage("read");
    }

    @RequestMapping(value={"/delete/{oid}"}, method={RequestMethod.POST})
    public String delete(@PathVariable(value="oid") A3esPeriod period, Model model, RedirectAttributes redirectAttributes) {
        this.setA3esPeriod(period, model);
        try {
            period.delete();
            this.addInfoMessage(LegalPTUtil.bundle("label.success.delete", new String[0]), model);
            return this.redirect(CONTROLLER_URL, model, redirectAttributes);
        }
        catch (Exception ex) {
            this.addErrorMessage(ex.getLocalizedMessage(), model);
            return this.jspPage("read/" + this.getA3esPeriod(model).getExternalId());
        }
    }

    @RequestMapping(value={"/update/{oid}"}, method={RequestMethod.GET})
    public String update(@PathVariable(value="oid") A3esPeriod period, Model model) {
        this.setA3esPeriod(period, model);
        A3esPeriodBean bean = new A3esPeriodBean(period);
        this.setBean(bean, model);
        return this.jspPage("update");
    }

    @RequestMapping(value={"/updatepostback/{oid}"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public ResponseEntity<String> updatepostback(@PathVariable(value="oid") A3esPeriod period, @RequestParam(value="bean", required=false) A3esPeriodBean bean, Model model) {
        bean.updateDataSources();
        this.setBean(bean, model);
        return new ResponseEntity((Object)this.getBeanJson(bean), HttpStatus.OK);
    }

    @RequestMapping(value={"/update/{oid}"}, method={RequestMethod.POST})
    public String update(@PathVariable(value="oid") A3esPeriod period, @RequestParam(value="bean", required=false) A3esPeriodBean bean, Model model, RedirectAttributes redirectAttributes) {
        this.setA3esPeriod(period, model);
        try {
            period.edit(bean.getFillInDateBegin(), bean.getFillInDateEnd());
            this.addInfoMessage(LegalPTUtil.bundle("label.success.update", new String[0]), model);
            return this.redirect(READ_URL + this.getA3esPeriod(model).getExternalId(), model, redirectAttributes);
        }
        catch (Exception de) {
            this.addErrorMessage(de.getLocalizedMessage(), model);
            this.setA3esPeriod(period, model);
            this.setBean(bean, model);
            return this.jspPage("update");
        }
    }

    @RequestMapping(value={"/create/"}, method={RequestMethod.GET})
    public String create(Model model) {
        A3esPeriodBean bean = new A3esPeriodBean();
        this.setBean(bean, model);
        return this.jspPage("create");
    }

    @RequestMapping(value={"/createpostback/"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public ResponseEntity<String> createpostback(@RequestParam(value="bean", required=false) A3esPeriodBean bean, Model model) {
        bean.updateDataSources();
        this.setBean(bean, model);
        return new ResponseEntity((Object)this.getBeanJson(bean), HttpStatus.OK);
    }

    @RequestMapping(value={"/create/"}, method={RequestMethod.POST})
    public String create(@RequestParam(value="bean", required=false) A3esPeriodBean bean, Model model, RedirectAttributes redirectAttributes) {
        try {
            A3esPeriod period = A3esPeriod.create(bean.getExecutionYear(), bean.getType(), bean.getFillInDateBegin(), bean.getFillInDateEnd());
            model.addAttribute("period", (Object)period);
            return this.redirect(READ_URL + this.getA3esPeriod(model).getExternalId(), model, redirectAttributes);
        }
        catch (Exception de) {
            this.addErrorMessage(de.getLocalizedMessage(), model);
            this.setBean(bean, model);
            return this.jspPage("create");
        }
    }
}

