/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.legalpt.services.raides.process;

import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.CompetenceCourseType;
import org.fenixedu.academic.domain.Country;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.DistrictSubdivision;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.SchoolLevelType;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.candidacy.StudentCandidacy;
import org.fenixedu.academic.domain.degreeStructure.CourseGroup;
import org.fenixedu.academic.domain.degreeStructure.RootCourseGroup;
import org.fenixedu.academic.domain.organizationalStructure.AcademicalInstitutionType;
import org.fenixedu.academic.domain.organizationalStructure.Unit;
import org.fenixedu.academic.domain.organizationalStructure.UnitUtils;
import org.fenixedu.academic.domain.raides.DegreeClassification;
import org.fenixedu.academic.domain.raides.DegreeDesignation;
import org.fenixedu.academic.domain.student.PersonalIngressionData;
import org.fenixedu.academic.domain.student.PrecedentDegreeInformation;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.RegistrationServices;
import org.fenixedu.academic.domain.student.curriculum.conclusion.RegistrationConclusionInformation;
import org.fenixedu.academic.domain.student.curriculum.conclusion.RegistrationConclusionServices;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumGroup;
import org.fenixedu.legalpt.domain.LegalReportContext;
import org.fenixedu.legalpt.util.LegalPTUtil;
import org.fenixedu.ulisboa.specifications.domain.legal.mapping.LegalMapping;
import org.fenixedu.ulisboa.specifications.domain.legal.raides.IGrauPrecedenteCompleto;
import org.fenixedu.ulisboa.specifications.domain.legal.raides.IMatricula;
import org.fenixedu.ulisboa.specifications.domain.legal.raides.Raides;
import org.fenixedu.ulisboa.specifications.domain.legal.raides.RaidesInstance;
import org.fenixedu.ulisboa.specifications.domain.legal.raides.TblInscrito;
import org.fenixedu.ulisboa.specifications.domain.legal.raides.mapping.BranchMappingType;
import org.fenixedu.ulisboa.specifications.domain.legal.raides.mapping.LegalMappingType;
import org.fenixedu.ulisboa.specifications.domain.legal.raides.report.RaidesRequestPeriodParameter;
import org.fenixedu.ulisboa.specifications.domain.legal.report.LegalReport;
import org.joda.time.DateTime;
import pt.ist.fenixframework.DomainObject;

public class RaidesService {
    private static final int MAX_OTHER_SCHOOL_LEVEL_LENGTH = 80;
    protected LegalReport report;

    public RaidesService(LegalReport report) {
        this.report = report;
    }

    protected String anoCurricular(Registration registration, ExecutionYear executionYear) {
        if (Raides.isDoctoralDegree(registration)) {
            return LegalMapping.find(this.report, LegalMappingType.CURRICULAR_YEAR).translate("NAO_APLICAVEL_CODE");
        }
        if (this.isOnlyEnrolledOnCompetenceCourseType(registration, executionYear, CompetenceCourseType.DISSERTATION)) {
            return LegalMapping.find(this.report, LegalMappingType.CURRICULAR_YEAR).translate("DISSERTACAO_CODE");
        }
        if (this.isOnlyEnrolledOnCompetenceCourseType(registration, executionYear, CompetenceCourseType.INTERNSHIP)) {
            return LegalMapping.find(this.report, LegalMappingType.CURRICULAR_YEAR).translate("ESTAGIO_FINAL_CODE");
        }
        if (this.isOnlyEnrolledOnCompetenceCourseType(registration, executionYear, CompetenceCourseType.PROJECT_WORK)) {
            return LegalMapping.find(this.report, LegalMappingType.CURRICULAR_YEAR).translate("TRABALHO_PROJECTO_CODE");
        }
        return LegalMapping.find(this.report, LegalMappingType.CURRICULAR_YEAR).translate(String.valueOf(RegistrationServices.getCurricularYear((Registration)registration, (ExecutionYear)executionYear).getResult()));
    }

    protected boolean isOnlyEnrolledOnCompetenceCourseType(Registration registration, ExecutionYear executionYear, CompetenceCourseType competenceCourseType) {
        Collection enrolments = registration.getEnrolments(executionYear);
        HashSet typesSet = Sets.newHashSet();
        for (Enrolment enrolment : enrolments) {
            CurricularCourse curricularCourse = enrolment.getCurricularCourse();
            CompetenceCourseType type = curricularCourse != null ? curricularCourse.getCompetenceCourse().getType() : CompetenceCourseType.REGULAR;
            typesSet.add(type);
        }
        if (typesSet.size() != 1) {
            return false;
        }
        return typesSet.iterator().next() == competenceCourseType;
    }

    protected boolean isFirstTimeOnDegree(Registration registration, ExecutionYear executionYear) {
        if (!RegistrationServices.getPrecedentDegreeRegistrations((Registration)registration).isEmpty()) {
            return false;
        }
        return executionYear == registration.getRegistrationYear();
    }

    protected void preencheInformacaoMatricula(LegalReport report, IMatricula bean, Unit institutionUnit, ExecutionYear executionYear, Registration registration) {
        bean.setIdEstab(institutionUnit.getCode());
        bean.setIdAluno(registration.getStudent().getNumber().toString());
        bean.setAnoLectivo(executionYear.getQualifiedName());
        DegreeCurricularPlan degreeCurricularPlan = this.getStudentCurricularPlanForBranch(registration, executionYear).getDegreeCurricularPlan();
        LegalMapping oficialDegreeMapping = LegalMapping.find(report, LegalMappingType.DEGREE_CURRICULAR_PLAN_DEGREE_OFICIAL_CODE);
        if (oficialDegreeMapping != null && oficialDegreeMapping.isKeyDefined(degreeCurricularPlan)) {
            bean.setCurso(oficialDegreeMapping.translate((DomainObject)degreeCurricularPlan));
        } else {
            bean.setCurso(registration.getDegree().getMinistryCode());
        }
        this.preencheRamo(report, bean, executionYear, registration, false);
    }

    protected void preencheRamo(LegalReport report, IMatricula bean, ExecutionYear executionYear, Registration registration, boolean forScholarPart) {
        Set<CourseGroup> branches;
        Set<CourseGroup> set = branches = forScholarPart ? this.scholarPartBranches(registration, executionYear) : this.branches(registration, executionYear);
        if (!forScholarPart) {
            bean.setRamo(null);
        }
        if (!branches.isEmpty()) {
            if (branches.size() > 1) {
                LegalReportContext.addError("", this.i18n("error.Raides.validation.enrolled.more.than.one.branch", Raides.formatArgs(registration, executionYear)), new String[0]);
            }
            bean.setRamo(BranchMappingType.readMapping(report).translate((DomainObject)branches.iterator().next()));
        } else {
            RootCourseGroup rootCourseGroup = this.getStudentCurricularPlanForBranch(registration, executionYear).getRoot().getDegreeModule();
            LegalMapping branchMapping = BranchMappingType.readMapping(report);
            bean.setRamo(branchMapping.isKeyDefined(rootCourseGroup) ? branchMapping.translate((DomainObject)rootCourseGroup) : "1000017");
        }
    }

    private Set<CourseGroup> branches(Registration registration, ExecutionYear executionYear) {
        HashSet result = Sets.newHashSet();
        StudentCurricularPlan scp = this.getStudentCurricularPlanForBranch(registration, executionYear);
        for (CurriculumGroup curriculumGroup : scp.getAllCurriculumGroups()) {
            if (curriculumGroup.getDegreeModule() == null) continue;
            CourseGroup courseGroup = curriculumGroup.getDegreeModule();
            if (!BranchMappingType.readMapping(this.report).isKeyDefined(courseGroup)) continue;
            result.add(courseGroup);
        }
        return result;
    }

    private Set<CourseGroup> scholarPartBranches(Registration registration, ExecutionYear executionYear) {
        HashSet result = Sets.newHashSet();
        RegistrationConclusionInformation conclusionInfoToUse = null;
        for (RegistrationConclusionInformation conclusionInfo : RegistrationConclusionServices.inferConclusion((Registration)registration)) {
            if (!conclusionInfo.isScholarPart() || !conclusionInfo.isConcluded()) continue;
            conclusionInfoToUse = conclusionInfo;
            break;
        }
        for (CurriculumGroup curriculumGroup : conclusionInfoToUse.getCurriculumGroup().getAllCurriculumGroups()) {
            if (curriculumGroup.getDegreeModule() == null) continue;
            CourseGroup courseGroup = curriculumGroup.getDegreeModule();
            if (!BranchMappingType.readMapping(this.report).isKeyDefined(courseGroup)) continue;
            result.add(courseGroup);
        }
        return result;
    }

    protected StudentCurricularPlan getStudentCurricularPlanForBranch(Registration registration, ExecutionYear executionYear) {
        return registration.getStudentCurricularPlansSet().size() == 1 ? registration.getLastStudentCurricularPlan() : registration.getStudentCurricularPlan(executionYear);
    }

    protected void preencheGrauPrecedentCompleto(IGrauPrecedenteCompleto bean, Unit institutionUnit, ExecutionYear executionYear, Registration registration) {
        StudentCandidacy studentCandidacy = registration.getStudentCandidacy();
        PrecedentDegreeInformation lastCompletedQualification = studentCandidacy.getPrecedentDegreeInformation();
        if (lastCompletedQualification == null) {
            return;
        }
        if (lastCompletedQualification.getSchoolLevel() != null) {
            bean.setEscolaridadeAnterior(LegalMapping.find(this.report, LegalMappingType.PRECEDENT_SCHOOL_LEVEL).translate((Enum<?>)lastCompletedQualification.getSchoolLevel()));
            if (bean.getEscolaridadeAnterior().equals("19")) {
                if (!Strings.isNullOrEmpty((String)lastCompletedQualification.getOtherSchoolLevel())) {
                    bean.setOutroEscolaridadeAnterior(lastCompletedQualification.getOtherSchoolLevel().substring(0, Math.min(80, lastCompletedQualification.getOtherSchoolLevel().length())));
                } else {
                    bean.setOutroEscolaridadeAnterior(lastCompletedQualification.getSchoolLevel().getLocalizedName().substring(0, Math.min(80, lastCompletedQualification.getSchoolLevel().getLocalizedName().length())));
                }
            }
        }
        if (lastCompletedQualification.getCountry() != null) {
            bean.setPaisEscolaridadeAnt(lastCompletedQualification.getCountry().getCode());
        }
        if (lastCompletedQualification.getConclusionYear() != null) {
            bean.setAnoEscolaridadeAnt(lastCompletedQualification.getConclusionYear().toString());
        }
        if (this.isPortuguesePostHighSchool(lastCompletedQualification) && !Strings.isNullOrEmpty((String)lastCompletedQualification.getDegreeDesignation())) {
            if (lastCompletedQualification.getInstitution() != null && (lastCompletedQualification.getInstitution().isOfficial().booleanValue() || UnitUtils.readInstitutionUnit() == lastCompletedQualification.getInstitution())) {
                bean.setEstabEscolaridadeAnt(lastCompletedQualification.getInstitution().getCode());
            } else if (lastCompletedQualification.getInstitution() != null) {
                bean.setEstabEscolaridadeAnt("0000");
                bean.setOutroEstabEscolarAnt(lastCompletedQualification.getInstitution().getNameI18n().getContent());
            }
            DegreeDesignation degreeDesignation = DegreeDesignation.readByNameAndSchoolLevel((String)lastCompletedQualification.getDegreeDesignation(), (SchoolLevelType)lastCompletedQualification.getSchoolLevel());
            if (degreeDesignation != null) {
                bean.setCursoEscolarAnt(degreeDesignation.getCode());
            } else {
                bean.setCursoEscolarAnt("0000");
                bean.setOutroCursoEscolarAnt(lastCompletedQualification.getDegreeDesignation());
            }
        }
        if (bean.isTipoEstabSecSpecified() && lastCompletedQualification.getSchoolLevel() != null && lastCompletedQualification.getSchoolLevel().isHighSchoolOrEquivalent()) {
            if (this.highSchoolType(studentCandidacy) != null) {
                bean.setTipoEstabSec(LegalMapping.find(this.report, LegalMappingType.HIGH_SCHOOL_TYPE).translate((Enum<?>)this.highSchoolType(studentCandidacy)));
            }
            if (Strings.isNullOrEmpty((String)bean.getTipoEstabSec())) {
                bean.setTipoEstabSec("1");
                LegalReportContext.addWarn("", this.i18n("warn.Raides.highSchoolType.not.specified", Raides.formatArgs(registration, executionYear)), new String[0]);
            }
        }
        if (Strings.isNullOrEmpty((String)bean.getTipoEstabSec()) && registration.getStudent().getLatestPersonalIngressionData() != null && registration.getStudent().getLatestPersonalIngressionData().getHighSchoolType() != null) {
            PersonalIngressionData personalIngressionData = registration.getStudent().getLatestPersonalIngressionData();
            bean.setTipoEstabSec(LegalMapping.find(this.report, LegalMappingType.HIGH_SCHOOL_TYPE).translate((Enum<?>)personalIngressionData.getHighSchoolType()));
        }
        this.validaGrauPrecedenteCompleto(institutionUnit, executionYear, registration, lastCompletedQualification, bean);
        this.validaCursoOficialInstituicaoOficial(institutionUnit, executionYear, registration, lastCompletedQualification, bean);
    }

    private AcademicalInstitutionType highSchoolType(StudentCandidacy studentCandidacy) {
        if (studentCandidacy.getHighSchoolType() != null) {
            return studentCandidacy.getHighSchoolType();
        }
        if (studentCandidacy.getPrecedentDegreeInformation() != null && studentCandidacy.getPrecedentDegreeInformation().getPersonalIngressionData() != null && studentCandidacy.getPrecedentDegreeInformation().getPersonalIngressionData().getHighSchoolType() != null) {
            return studentCandidacy.getPrecedentDegreeInformation().getPersonalIngressionData().getHighSchoolType();
        }
        if (studentCandidacy.getPerson().getStudent() != null) {
            for (PersonalIngressionData pid : studentCandidacy.getPerson().getStudent().getPersonalIngressionsDataSet()) {
                if (pid.getHighSchoolType() == null) continue;
                return pid.getHighSchoolType();
            }
        }
        return null;
    }

    protected boolean isPortuguesePostHighSchool(PrecedentDegreeInformation lastCompletedQualification) {
        return lastCompletedQualification.getCountry() != null && lastCompletedQualification.getCountry().isDefaultCountry() && this.isPostHighEducation(lastCompletedQualification);
    }

    protected boolean isPostHighEducation(PrecedentDegreeInformation precedentDegreeInformation) {
        return precedentDegreeInformation.getSchoolLevel() != null && (precedentDegreeInformation.getSchoolLevel().isHigherEducation() || this.isCetEducation(precedentDegreeInformation));
    }

    protected boolean isCetEducation(PrecedentDegreeInformation lastCompletedQualification) {
        return lastCompletedQualification.getSchoolLevel() != null && lastCompletedQualification.getSchoolLevel() == SchoolLevelType.TECHNICAL_SPECIALIZATION;
    }

    protected void validaGrauPrecedenteCompleto(Unit institutionUnit, ExecutionYear executionYear, Registration registration, PrecedentDegreeInformation lastCompletedQualification, IGrauPrecedenteCompleto bean) {
        if (Strings.isNullOrEmpty((String)bean.getEscolaridadeAnterior())) {
            LegalReportContext.addError("", this.i18n("error.Raides.validation.previous.complete.school.level.missing", Raides.formatArgs(registration, executionYear)), new String[0]);
            bean.markAsInvalid();
        }
        if (Strings.isNullOrEmpty((String)bean.getPaisEscolaridadeAnt())) {
            LegalReportContext.addError("", this.i18n("error.Raides.validation.previous.complete.country.missing", Raides.formatArgs(registration, executionYear)), new String[0]);
            bean.markAsInvalid();
        }
        if (Strings.isNullOrEmpty((String)bean.getAnoEscolaridadeAnt())) {
            LegalReportContext.addError("", this.i18n("error.Raides.validation.previous.complete.year.missing", Raides.formatArgs(registration, executionYear)), new String[0]);
            bean.markAsInvalid();
        }
        this.validaEstabelecimentoAnteriorCompleto(institutionUnit, executionYear, registration, lastCompletedQualification, bean);
        this.validaCursoAnteriorCompleto(institutionUnit, executionYear, registration, lastCompletedQualification, bean);
        if (!bean.isTipoEstabSecSpecified()) {
            return;
        }
        if (lastCompletedQualification.getSchoolLevel() != null && lastCompletedQualification.getSchoolLevel().isHighSchoolOrEquivalent() && Strings.isNullOrEmpty((String)bean.getTipoEstabSec())) {
            LegalReportContext.addError("", this.i18n("error.Raides.validation.previous.complete.highSchoolType.missing", Raides.formatArgs(registration, executionYear)), new String[0]);
        }
    }

    protected void validaEstabelecimentoAnteriorCompleto(Unit institutionUnit, ExecutionYear executionYear, Registration registration, PrecedentDegreeInformation lastCompletedQualification, IGrauPrecedenteCompleto bean) {
        if (lastCompletedQualification.getCountry() == null || !lastCompletedQualification.getCountry().isDefaultCountry()) {
            return;
        }
        if (lastCompletedQualification.getSchoolLevel() == null || !this.isPostHighEducation(lastCompletedQualification)) {
            return;
        }
        if (Strings.isNullOrEmpty((String)bean.getEstabEscolaridadeAnt())) {
            LegalReportContext.addError("", this.i18n("error.Raides.validation.previous.complete.institution.missing", Raides.formatArgs(registration, executionYear)), new String[0]);
            bean.markAsInvalid();
        }
        if ("0000".equals(bean.getEstabEscolaridadeAnt()) && Strings.isNullOrEmpty((String)bean.getOutroEstabEscolarAnt())) {
            LegalReportContext.addError("", this.i18n("error.Raides.validation.previous.complete.other.institution.missing", Raides.formatArgs(registration, executionYear)), new String[0]);
            bean.markAsInvalid();
        } else if ("0000".equals(bean.getEstabEscolaridadeAnt())) {
            LegalReportContext.addWarn("", this.i18n("warn.Raides.validation.previous.complete.other.institution.given.instead.of.code", Raides.formatArgs(registration, executionYear)), new String[0]);
            bean.markAsInvalid();
        }
    }

    protected void validaCursoOficialInstituicaoOficial(Unit institutionUnit, ExecutionYear executionYear, Registration registration, PrecedentDegreeInformation lastCompletedQualification, IGrauPrecedenteCompleto bean) {
        if (!this.isPortuguesePostHighSchool(lastCompletedQualification)) {
            return;
        }
        if (Strings.isNullOrEmpty((String)lastCompletedQualification.getDegreeDesignation())) {
            return;
        }
        DegreeDesignation degreeDesignation = DegreeDesignation.readByNameAndSchoolLevel((String)lastCompletedQualification.getDegreeDesignation(), (SchoolLevelType)lastCompletedQualification.getSchoolLevel());
        if (degreeDesignation == null) {
            return;
        }
        boolean degreeDesignationContainsInstitution = false;
        for (DegreeDesignation it : this.readByNameAndSchoolLevel(lastCompletedQualification.getDegreeDesignation(), lastCompletedQualification.getSchoolLevel())) {
            degreeDesignationContainsInstitution |= it.getInstitutionUnitSet().contains(lastCompletedQualification.getInstitution());
        }
        if (!degreeDesignationContainsInstitution) {
            LegalReportContext.addError("", this.i18n("error.Raides.validation.official.precedent.degree.is.not.offered.by.institution", Raides.formatArgs(registration, executionYear)), new String[0]);
            bean.markAsInvalid();
        }
        if ((Raides.isMasterDegreeOrDoctoralDegree(registration) || Raides.isSpecializationDegree(registration)) && !this.isPostHighEducation(lastCompletedQualification)) {
            LegalReportContext.addError("", this.i18n("error.Raides.validation.isMasterDoctoralOrSpecialization.but.completed.qualification.is.not.higher", Raides.formatArgs(registration, executionYear)), new String[0]);
        }
    }

    protected void validaCursoAnteriorCompleto(Unit institutionUnit, ExecutionYear executionYear, Registration registration, PrecedentDegreeInformation lastCompletedQualification, IGrauPrecedenteCompleto bean) {
        if (lastCompletedQualification.getCountry() == null || !lastCompletedQualification.getCountry().isDefaultCountry()) {
            return;
        }
        if (lastCompletedQualification.getSchoolLevel() == null || !this.isPostHighEducation(lastCompletedQualification)) {
            return;
        }
        if (Strings.isNullOrEmpty((String)bean.getCursoEscolarAnt())) {
            LegalReportContext.addError("", this.i18n("error.Raides.validation.previous.complete.degree.designation.missing", Raides.formatArgs(registration, executionYear)), new String[0]);
            bean.markAsInvalid();
        }
        if ("4".equals(bean.getCursoEscolarAnt()) && Strings.isNullOrEmpty((String)bean.getOutroCursoEscolarAnt())) {
            LegalReportContext.addError("", this.i18n("error.Raides.validation.previous.complete.other.degree.designation.missing", Raides.formatArgs(registration, executionYear)), new String[0]);
            bean.markAsInvalid();
        }
        if (this.isPortuguesePostHighSchool(lastCompletedQualification) && "0000".equals(bean.getCursoEscolarAnt())) {
            LegalReportContext.addError("", this.i18n("error.Raides.validation.previous.complete.other.degree.designation.set.even.if.level.is.portuguese.higher.education", Raides.formatArgs(registration, executionYear)), new String[0]);
            bean.markAsInvalid();
        }
    }

    protected Set<DegreeDesignation> readByNameAndSchoolLevel(String degreeDesignationName, SchoolLevelType schoolLevel) {
        if (schoolLevel == null || degreeDesignationName == null) {
            return null;
        }
        ArrayList<DegreeClassification> possibleClassifications = new ArrayList<DegreeClassification>();
        for (Object code : schoolLevel.getEquivalentDegreeClassifications()) {
            possibleClassifications.add(DegreeClassification.readByCode((String)code));
        }
        ArrayList possibleDesignations = new ArrayList();
        for (DegreeClassification classification : possibleClassifications) {
            if (classification.getDegreeDesignationsSet().isEmpty()) continue;
            possibleDesignations.addAll(classification.getDegreeDesignationsSet());
        }
        HashSet result = Sets.newHashSet();
        for (DegreeDesignation degreeDesignation : possibleDesignations) {
            if (!degreeDesignation.getDescription().equalsIgnoreCase(degreeDesignationName)) continue;
            result.add(degreeDesignation);
        }
        return result;
    }

    protected void preencheInformacaoPessoal(ExecutionYear executionYear, Registration registration, TblInscrito bean) {
        PersonalIngressionData personalIngressionData;
        if (registration.getPerson().getMaritalStatus() != null) {
            bean.setEstadoCivil(LegalMapping.find(this.report, LegalMappingType.MARITAL_STATUS).translate((Enum<?>)registration.getPerson().getMaritalStatus()));
        }
        if ((personalIngressionData = Raides.personalIngressionData(registration, executionYear)) != null && personalIngressionData.getDislocatedFromPermanentResidence() != null) {
            bean.setAlunoDeslocado(LegalMapping.find(this.report, LegalMappingType.BOOLEAN).translate(personalIngressionData.getDislocatedFromPermanentResidence()));
        }
        if (Strings.isNullOrEmpty((String)bean.getAlunoDeslocado()) && ((RaidesInstance)((Object)this.report)).getDefaultDistrictOfResidence() != null) {
            if (Raides.countryOfResidence(registration, executionYear) != null && !Raides.countryOfResidence(registration, executionYear).isDefaultCountry()) {
                bean.setAlunoDeslocado(LegalMapping.find(this.report, LegalMappingType.BOOLEAN).translate(true));
            } else if (Raides.countryOfResidence(registration, executionYear) != null && Raides.districtSubdivisionOfResidence(registration, executionYear) != null) {
                bean.setAlunoDeslocado(LegalMapping.find(this.report, LegalMappingType.BOOLEAN).translate(Raides.districtOfResidence(registration, executionYear) != ((RaidesInstance)((Object)this.report)).getDefaultDistrictOfResidence()));
            }
        }
        Country countryOfResidence = Raides.countryOfResidence(registration, executionYear);
        DistrictSubdivision districtSubdivision = Raides.districtSubdivisionOfResidence(registration, executionYear);
        if (countryOfResidence != null && districtSubdivision != null) {
            bean.setResideConcelho(districtSubdivision.getDistrict().getCode() + districtSubdivision.getCode());
        }
        if (personalIngressionData != null) {
            if (personalIngressionData.getFatherSchoolLevel() != null) {
                bean.setNivelEscolarPai(LegalMapping.find(this.report, LegalMappingType.SCHOOL_LEVEL).translate((Enum<?>)personalIngressionData.getFatherSchoolLevel()));
            }
            if (personalIngressionData.getMotherSchoolLevel() != null) {
                bean.setNivelEscolarMae(LegalMapping.find(this.report, LegalMappingType.SCHOOL_LEVEL).translate((Enum<?>)personalIngressionData.getMotherSchoolLevel()));
            }
            if (personalIngressionData.getFatherProfessionalCondition() != null) {
                bean.setSituacaoProfPai(LegalMapping.find(this.report, LegalMappingType.PROFESSIONAL_SITUATION_CONDITION).translate((Enum<?>)personalIngressionData.getFatherProfessionalCondition()));
            }
            if (personalIngressionData.getMotherProfessionalCondition() != null) {
                bean.setSituacaoProfMae(LegalMapping.find(this.report, LegalMappingType.PROFESSIONAL_SITUATION_CONDITION).translate((Enum<?>)personalIngressionData.getMotherProfessionalCondition()));
            }
            if (personalIngressionData.getProfessionalCondition() != null) {
                bean.setSituacaoProfAluno(LegalMapping.find(this.report, LegalMappingType.PROFESSIONAL_SITUATION_CONDITION).translate((Enum<?>)personalIngressionData.getProfessionalCondition()));
            }
            if (personalIngressionData.getFatherProfessionType() != null) {
                bean.setProfissaoPai(LegalMapping.find(this.report, LegalMappingType.PROFESSION_TYPE).translate((Enum<?>)personalIngressionData.getFatherProfessionType()));
            }
            if (personalIngressionData.getMotherProfessionType() != null) {
                bean.setProfissaoMae(LegalMapping.find(this.report, LegalMappingType.PROFESSION_TYPE).translate((Enum<?>)personalIngressionData.getMotherProfessionType()));
            }
            if (personalIngressionData.getProfessionType() != null) {
                bean.setProfissaoAluno(LegalMapping.find(this.report, LegalMappingType.PROFESSION_TYPE).translate((Enum<?>)personalIngressionData.getProfessionType()));
            }
        }
        this.validaInformacaoPessoal(executionYear, registration, bean);
    }

    protected void validaInformacaoPessoal(ExecutionYear executionYear, Registration registration, TblInscrito bean) {
        if (Strings.isNullOrEmpty((String)bean.getEstadoCivil())) {
            LegalReportContext.addError("", this.i18n("error.Raides.validation.maritalStatus.missing", Raides.formatArgs(registration, executionYear)), new String[0]);
            bean.markAsInvalid();
        }
        if (Strings.isNullOrEmpty((String)bean.getAlunoDeslocado())) {
            LegalReportContext.addError("", this.i18n("error.Raides.validation.dislocated.from.residence.missing", Raides.formatArgs(registration, executionYear)), new String[0]);
            bean.markAsInvalid();
        }
        if (Raides.countryOfResidence(registration, executionYear) != null && Raides.countryOfResidence(registration, executionYear).isDefaultCountry() && Strings.isNullOrEmpty((String)bean.getResideConcelho())) {
            LegalReportContext.addError("", this.i18n("error.Raides.validation.district.subdivision.missing", Raides.formatArgs(registration, executionYear)), new String[0]);
            bean.markAsInvalid();
        }
        if (Strings.isNullOrEmpty((String)bean.getProfissaoAluno()) || "21".equals(bean.getProfissaoAluno())) {
            // empty if block
        }
        if (Strings.isNullOrEmpty((String)bean.getNivelEscolarPai()) || Strings.isNullOrEmpty((String)bean.getNivelEscolarMae()) || Strings.isNullOrEmpty((String)bean.getSituacaoProfPai()) || Strings.isNullOrEmpty((String)bean.getSituacaoProfMae()) || Strings.isNullOrEmpty((String)bean.getSituacaoProfAluno()) || Strings.isNullOrEmpty((String)bean.getProfissaoPai()) || Strings.isNullOrEmpty((String)bean.getProfissaoMae()) || Strings.isNullOrEmpty((String)bean.getProfissaoAluno())) {
            // empty if block
        }
    }

    protected String regimeFrequencia(Registration registration, ExecutionYear executionYear) {
        boolean onlyEnrolledOnDissertation = this.isOnlyEnrolledOnCompetenceCourseType(registration, executionYear, CompetenceCourseType.DISSERTATION);
        boolean onlyEnrolledOnInternship = this.isOnlyEnrolledOnCompetenceCourseType(registration, executionYear, CompetenceCourseType.INTERNSHIP);
        boolean onlyEnrolledOnProjectWork = this.isOnlyEnrolledOnCompetenceCourseType(registration, executionYear, CompetenceCourseType.PROJECT_WORK);
        if (onlyEnrolledOnDissertation || onlyEnrolledOnInternship || onlyEnrolledOnProjectWork) {
            return LegalMapping.find(this.report, LegalMappingType.REGIME_FREQUENCIA).translate("ETD_CODE");
        }
        return LegalMapping.find(this.report, LegalMappingType.REGIME_FREQUENCIA).translate(registration.getDegree().getExternalId());
    }

    protected DateTime findMaximumAnnulmentDate(List<RaidesRequestPeriodParameter> periods, ExecutionYear executionYear) {
        return periods.stream().filter(p -> p.getAcademicPeriod() == executionYear).max(Comparator.comparing(RaidesRequestPeriodParameter::getEnd)).get().getEnd().plusDays(1).toDateTimeAtStartOfDay().minusSeconds(1);
    }

    protected BigDecimal enrolledEcts(ExecutionYear executionYear, Registration registration, DateTime maximumAnnulmentDate, boolean mobility) {
        StudentCurricularPlan studentCurricularPlan = registration.getStudentCurricularPlan(executionYear);
        double result = 0.0;
        for (Enrolment enrolment : studentCurricularPlan.getEnrolmentsSet()) {
            if (Raides.isEnrolmentAnnuled(enrolment, maximumAnnulmentDate) || !mobility && enrolment.getCurriculumGroup().isNoCourseGroupCurriculumGroup() || !enrolment.isValid(executionYear)) continue;
            result += enrolment.getEctsCredits().doubleValue();
        }
        return new BigDecimal(result);
    }

    protected Set<Enrolment> scholarPartEnrolments(ExecutionYear executionYear, Registration registration) {
        StudentCurricularPlan studentCurricularPlan = registration.getStudentCurricularPlan(executionYear);
        HashSet result = Sets.newHashSet();
        for (Enrolment enrolment : studentCurricularPlan.getEnrolmentsSet()) {
            if (enrolment.getCurricularCourse() != null && enrolment.getCurricularCourse().isDissertation() || !enrolment.isValid(executionYear)) continue;
            result.add(enrolment);
        }
        return result;
    }

    protected BigDecimal doctoralEnrolledEcts(ExecutionYear executionYear, Registration registration, DateTime maximumAnnulmentDate) {
        if (this.isOnlyEnrolledOnCompetenceCourseType(registration, executionYear, CompetenceCourseType.DISSERTATION)) {
            return null;
        }
        BigDecimal enrolledEcts = this.enrolledEcts(executionYear, registration, maximumAnnulmentDate, false);
        if (BigDecimal.ZERO.compareTo(enrolledEcts) != 0) {
            enrolledEcts = enrolledEcts.subtract(this.phdDissertationEnrolledEctsCredits(executionYear, registration, maximumAnnulmentDate));
            return enrolledEcts;
        }
        return null;
    }

    private BigDecimal phdDissertationEnrolledEctsCredits(ExecutionYear executionYear, Registration registration, DateTime maximumAnnulmentDate) {
        BigDecimal result = BigDecimal.ZERO;
        StudentCurricularPlan studentCurricularPlan = registration.getStudentCurricularPlan(executionYear);
        Collection allDissertationCurricularCourses = studentCurricularPlan.getDegreeCurricularPlan().getDcpDegreeModules(CurricularCourse.class, executionYear).stream().map(CurricularCourse.class::cast).filter(cc -> cc.isDissertation()).collect(Collectors.toSet());
        for (CurricularCourse dissertation : allDissertationCurricularCourses) {
            boolean isEnrollmentInDissertationCurricularCourse = studentCurricularPlan.getEnrolmentsByExecutionYear(executionYear).stream().filter(e -> e.getCurricularCourse() == dissertation).filter(e -> !Raides.isEnrolmentAnnuled(e, maximumAnnulmentDate)).count() > 0L;
            if (!isEnrollmentInDissertationCurricularCourse) continue;
            result = result.add(new BigDecimal(dissertation.getEctsCredits()));
        }
        return result;
    }

    public String i18n(String key, String ... arguments) {
        return LegalPTUtil.bundle(key, arguments);
    }

    protected class DEGREE_VALUE_COMPARATOR
    implements Comparator<Degree> {
        protected Map<Degree, Integer> m;

        public DEGREE_VALUE_COMPARATOR(Map<Degree, Integer> m) {
            this.m = m;
        }

        @Override
        public int compare(Degree o1, Degree o2) {
            int result = this.m.get(o1).compareTo(this.m.get(o2));
            if (result != 0) {
                return -result;
            }
            return o1.getExternalId().compareTo(o2.getExternalId());
        }
    }
}

