/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.legalpt.ui.a3es;

import org.fenixedu.bennu.core.domain.exceptions.DomainException;
import org.fenixedu.bennu.spring.portal.SpringFunctionality;
import org.fenixedu.legalpt.domain.a3es.A3esInstance;
import org.fenixedu.legalpt.dto.a3es.A3esInstanceBean;
import org.fenixedu.legalpt.ui.FenixeduLegalPTBaseController;
import org.fenixedu.legalpt.ui.FenixeduLegalPTController;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@SpringFunctionality(app=FenixeduLegalPTController.class, title="label.title.manageA3esConfiguration", accessGroup="#managers")
@RequestMapping(value={"/fenixedu-legal-pt/a3es/manageconfiguration"})
public class A3esConfigurationController
extends FenixeduLegalPTBaseController {
    public static final String CONTROLLER_URL = "/fenixedu-legal-pt/a3es/manageconfiguration";
    public static final String JSP_PATH = "/fenixedu-legal-pt/a3es/manageconfiguration".substring(1);
    private static final String _READ_URI = "/read";
    public static final String READ_URL = "/fenixedu-legal-pt/a3es/manageconfiguration/read";
    private static final String _EDIT_URI = "/edit";
    public static final String EDIT_URL = "/fenixedu-legal-pt/a3es/manageconfiguration/edit";

    @RequestMapping
    public String home() {
        return "forward:/fenixedu-legal-pt/a3es/manageconfiguration/read";
    }

    @RequestMapping(value={"/read"}, method={RequestMethod.GET})
    public String read(Model model) {
        model.addAttribute("instance", (Object)A3esInstance.getInstance());
        return this.jspPage(_READ_URI);
    }

    @RequestMapping(value={"/edit"}, method={RequestMethod.GET})
    public String edit(Model model) {
        return this._edit(new A3esInstanceBean(A3esInstance.getInstance()), model);
    }

    private String _edit(A3esInstanceBean bean, Model model) {
        model.addAttribute("bean", (Object)bean);
        model.addAttribute("beanJson", (Object)this.getBeanJson(bean));
        return this.jspPage(_EDIT_URI);
    }

    @RequestMapping(value={"/edit"}, method={RequestMethod.POST})
    public String editpost(@RequestParam(value="bean") A3esInstanceBean bean, Model model) {
        try {
            A3esInstance instance = A3esInstance.getInstance();
            instance.edit(instance.getName(), instance.getGroup(), instance.getSynchronous(), instance.getHasMappings(), bean.getMobilityAgreements(), bean.getStudyCycleByDegree(), bean.getGroupCourseProfessorshipByPerson(), bean.getGroupPersonProfessorshipByCourse());
            return "redirect:/fenixedu-legal-pt/a3es/manageconfiguration/read";
        }
        catch (DomainException e) {
            this.addErrorMessage(e.getLocalizedMessage(), model);
            return this._edit(bean, model);
        }
    }

    private String jspPage(String page) {
        return JSP_PATH + "/" + page.substring(1, page.length());
    }
}

