/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.legalpt.services.commons.export;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.io.ZipOutputStream;
import net.lingala.zip4j.model.ZipModel;
import net.lingala.zip4j.model.ZipParameters;
import org.fenixedu.ulisboa.specifications.domain.legal.report.LegalReportRequest;
import org.fenixedu.ulisboa.specifications.domain.legal.report.LegalReportResultFile;
import org.fenixedu.ulisboa.specifications.domain.legal.report.LegalReportResultFileType;

public class XmlZipFileWriter {
    public static LegalReportResultFile write(LegalReportRequest reportRequest, LegalReportResultFile xmlResultFile, String password) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ZipParameters parameters = new ZipParameters();
            parameters.setCompressionMethod(8);
            parameters.setCompressionLevel(5);
            parameters.setEncryptFiles(true);
            parameters.setEncryptionMethod(0);
            parameters.setPassword(password);
            parameters.setFileNameInZip(xmlResultFile.getFilename());
            parameters.setSourceExternalStream(true);
            ZipOutputStream zOut = new ZipOutputStream((OutputStream)baos, new ZipModel());
            zOut.putNextEntry(null, parameters);
            zOut.write(xmlResultFile.getContent());
            zOut.closeEntry();
            zOut.finish();
            zOut.close();
            return new LegalReportResultFile(reportRequest, LegalReportResultFileType.ZIP, xmlResultFile.getFilename().replace(".xml", ".zip"), baos.toByteArray());
        }
        catch (IOException | ZipException e) {
            e.printStackTrace();
            return null;
        }
    }
}

