/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.legalpt.services.a3es.process;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.CompetenceCourse;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.Professorship;
import org.fenixedu.academic.domain.ShiftType;
import org.fenixedu.academic.domain.Teacher;
import org.fenixedu.academic.domain.curricularPeriod.CurricularPeriod;
import org.fenixedu.academic.domain.degreeStructure.BibliographicReferences;
import org.fenixedu.academic.domain.degreeStructure.CompetenceCourseInformation;
import org.fenixedu.academic.domain.degreeStructure.Context;
import org.fenixedu.academic.domain.degreeStructure.CourseGroup;
import org.fenixedu.academic.domain.dml.DynamicField;
import org.fenixedu.academic.util.CurricularPeriodLabelFormatter;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.legalpt.domain.a3es.A3esInstance;
import org.fenixedu.legalpt.dto.a3es.A3esCourseBean;
import org.fenixedu.legalpt.dto.a3es.A3esProcessBean;
import org.fenixedu.legalpt.services.a3es.process.A3esExportService;
import pt.ist.fenixframework.DomainObject;

public class A3esHarvestCoursesDataService {
    private final ExecutionYear year;
    private final ExecutionSemester semester;
    private final DegreeCurricularPlan degreeCurricularPlan;

    public A3esHarvestCoursesDataService(A3esProcessBean bean) {
        this.year = bean.getExecutionYear();
        this.semester = this.year.getFirstExecutionPeriod();
        this.degreeCurricularPlan = bean.getDegreeCurricularPlan();
        Set coordinators = this.degreeCurricularPlan.getExecutionDegreesSet().stream().filter(ed -> ed.getExecutionYear() == this.year).flatMap(ed -> ed.getCoordinatorsListSet().stream()).map(c -> c.getPerson()).collect(Collectors.toSet());
        A3esExportService.readCourses(this.degreeCurricularPlan, this.year).stream().map(course -> {
            Map<Person, Set<Professorship>> courseProfessorships = A3esExportService.readCourseProfessorships(this.degreeCurricularPlan, this.year, course);
            Teacher teacher = bean.getTeacher();
            if (teacher != null && !courseProfessorships.containsKey(teacher.getPerson()) && !coordinators.contains(teacher.getPerson())) {
                return null;
            }
            A3esCourseBean data = new A3esCourseBean();
            CompetenceCourseInformation info = course.findInformationMostRecentUntil((ExecutionInterval)this.semester);
            this.fillBasics(data, info);
            this.fillAllTeachersInfo(data, courseProfessorships);
            this.fillLearningObjectives(data, (CompetenceCourse)course);
            this.fillCourseProgram(data, (CompetenceCourse)course);
            this.fillCourseProgramJustification(data, info);
            this.fillTeachingMethodology(data, (CompetenceCourse)course);
            this.fillTeachingMethodologyJustification(data, info);
            this.fillBibliography(data, (CompetenceCourse)course);
            return data;
        }).filter(i -> i != null).collect(Collectors.toCollection(() -> bean.getCoursesData()));
    }

    private void fillBasics(A3esCourseBean data, CompetenceCourseInformation info) {
        data.addField("currentInfo", "currentInfo", info.getExecutionInterval().getQualifiedName(), A3esExportService._UNSUPPORTED);
        CompetenceCourse course = info.getCompetenceCourse();
        data.addField("code", "code", course.getCode(), A3esExportService._UNSUPPORTED);
        LocalizedString curricularUnitName = course.getNameI18N((ExecutionInterval)this.semester);
        data.addField("curricularUnitPresentationName", "curricularUnitPresentationName", this.getCourseName(course), A3esExportService._UNSUPPORTED);
        data.addField("1.1", "curricularUnitName", A3esExportService.PT, curricularUnitName, A3esExportService._100);
        data.addField("1.1", "curricularUnitName", A3esExportService.EN, curricularUnitName, A3esExportService._100);
        String curricularPeriods = course.getAssociatedCurricularCoursesSet().stream().filter(c -> c.getDegreeCurricularPlan() == this.degreeCurricularPlan).flatMap(c -> c.getParentContextsByExecutionYear(this.year).stream()).map(ctx -> CurricularPeriodLabelFormatter.getFullLabel((CurricularPeriod)ctx.getCurricularPeriod(), (boolean)true)).distinct().collect(Collectors.joining("; "));
        data.addField("curricularPeriod", "curricularPeriod", curricularPeriods, A3esExportService._UNSUPPORTED);
        String source = course.getAssociatedCurricularCoursesSet().stream().filter(c -> c.getDegreeCurricularPlan() == this.degreeCurricularPlan && c.getAssociatedExecutionCoursesSet().stream().anyMatch(ec -> ec.getExecutionYear() == this.year)).flatMap(c -> {
            ArrayList<String> notes = new ArrayList<String>();
            if (c.isOptionalCurricularCourse()) {
                notes.add(A3esExportService.label("optional"));
            }
            this.collectFullPath(c.getParentContextsByExecutionYear(this.year)).forEach(cg -> {
                if (cg.isBranchCourseGroup()) {
                    notes.add(cg.getName());
                }
                if (cg.isOptionalCourseGroup()) {
                    notes.add(A3esExportService.label("optional"));
                }
            });
            return notes.stream();
        }).sorted().distinct().collect(Collectors.joining(A3esExportService.SEMICOLON));
        data.addField("notes", "notes", StringUtils.isBlank((String)source) ? "-" : source, A3esExportService._UNSUPPORTED);
    }

    private List<CourseGroup> collectFullPath(List<Context> input) {
        ArrayList<CourseGroup> result = new ArrayList<CourseGroup>();
        if (!input.isEmpty()) {
            List parents = input.stream().map(c -> c.getParentCourseGroup()).collect(Collectors.toList());
            result.addAll(parents);
            result.addAll(this.collectFullPath(parents.stream().flatMap(c -> c.getParentContextsByExecutionYear(this.year).stream()).collect(Collectors.toList())));
        }
        return result;
    }

    private String getCourseName(CompetenceCourse course) {
        LocalizedString i18n = course.getNameI18N((ExecutionInterval)this.semester);
        String result = i18n.getContent(A3esExportService.PT);
        if (i18n.getContent(A3esExportService.EN) != null) {
            result = result + " | " + i18n.getContent(A3esExportService.EN);
        }
        return result;
    }

    private void fillAllTeachersInfo(A3esCourseBean data, Map<Person, Set<Professorship>> courseProfessorships) {
        A3esHarvestCoursesDataService.fillTeachersInfo(data, courseProfessorships);
        A3esHarvestCoursesDataService.fillAssistantTeachersInfo(data, courseProfessorships);
    }

    private static void fillTeachersInfo(A3esCourseBean data, Map<Person, Set<Professorship>> courseProfessorships) {
        String source = A3esHarvestCoursesDataService.getTeachersAndTeachingHours(courseProfessorships, p -> p.isResponsibleFor());
        data.addField("2", "responsibleTeacherAndTeachingHours", source, A3esExportService._1000);
    }

    private static void fillAssistantTeachersInfo(A3esCourseBean data, Map<Person, Set<Professorship>> courseProfessorships) {
        String source = A3esHarvestCoursesDataService.getTeachersAndTeachingHours(courseProfessorships, p -> !p.isResponsibleFor());
        data.addField("3", "otherTeachersAndTeachingHours", source, A3esExportService._1000);
    }

    private static String getTeachersAndTeachingHours(Map<Person, Set<Professorship>> courseProfessorships, Predicate<Professorship> p) {
        return courseProfessorships.entrySet().stream().map(entry -> {
            Person person = (Person)entry.getKey();
            Set personProfessorships = (Set)entry.getValue();
            if (personProfessorships.stream().noneMatch(p)) {
                return "";
            }
            return person.getName() + " (" + A3esHarvestCoursesDataService.getTeachingHours(personProfessorships, p) + ")";
        }).sorted().filter(i -> !StringUtils.isBlank((String)i)).collect(Collectors.joining(A3esExportService.PLUS));
    }

    private static String getTeachingHours(Set<Professorship> personProfessorships, Predicate<Professorship> p) {
        Stream<Professorship> filtered = personProfessorships.stream().filter(p);
        if (A3esInstance.getInstance().getGroupCourseProfessorshipByPerson()) {
            return A3esHarvestCoursesDataService.getTeachingHoursByPerson(filtered);
        }
        return A3esHarvestCoursesDataService.getTeachingHoursByShiftType(filtered);
    }

    private static String getTeachingHoursByPerson(Stream<Professorship> professorships) {
        return professorships.flatMap(p -> p.getAssociatedShiftProfessorshipSet().stream()).map(sp -> A3esExportService.calculateTeachingHours(sp)).reduce(BigDecimal.ZERO, BigDecimal::add).toPlainString() + "h";
    }

    private static String getTeachingHoursByShiftType(Stream<Professorship> professorships) {
        return professorships.flatMap(p -> p.getAssociatedShiftProfessorshipSet().stream()).map(sp -> A3esExportService.getShiftTypeAcronym((ShiftType)sp.getShift().getTypes().iterator().next()) + " - " + A3esExportService.calculateTeachingHours(sp).toPlainString() + "h").sorted().collect(Collectors.joining(A3esExportService.SEMICOLON));
    }

    private void fillLearningObjectives(A3esCourseBean data, CompetenceCourse course) {
        LocalizedString source = course.getObjectivesI18N((ExecutionInterval)this.semester);
        data.addField("4", "learningOutcomes", A3esExportService.PT, source, A3esExportService._1000);
        data.addField("4", "learningOutcomes", A3esExportService.EN, source, A3esExportService._1000);
    }

    private void fillCourseProgram(A3esCourseBean data, CompetenceCourse course) {
        LocalizedString source = course.getProgramI18N((ExecutionInterval)this.semester);
        data.addField("5", "program", A3esExportService.PT, source, A3esExportService._1000);
        data.addField("5", "program", A3esExportService.EN, source, A3esExportService._1000);
    }

    private void fillCourseProgramJustification(A3esCourseBean data, CompetenceCourseInformation info) {
        String code = "programDemonstration";
        DynamicField field = DynamicField.findField((DomainObject)info, (String)"programDemonstration");
        LocalizedString source = field == null ? null : (LocalizedString)field.getValue(LocalizedString.class);
        data.addField("6", "programDemonstration", A3esExportService.PT, source, A3esExportService._1000);
        data.addField("6", "programDemonstration", A3esExportService.EN, source, A3esExportService._1000);
    }

    private void fillTeachingMethodology(A3esCourseBean data, CompetenceCourse course) {
        LocalizedString source = A3esExportService.createMLS(course.getEvaluationMethod((ExecutionInterval)this.semester), course.getEvaluationMethodEn((ExecutionInterval)this.semester));
        data.addField("7", "evaluationMethod", A3esExportService.PT, source, A3esExportService._1000);
        data.addField("7", "evaluationMethod", A3esExportService.EN, source, A3esExportService._1000);
    }

    private void fillTeachingMethodologyJustification(A3esCourseBean data, CompetenceCourseInformation info) {
        String code = "evaluationMethodDemonstration";
        DynamicField field = DynamicField.findField((DomainObject)info, (String)"evaluationMethodDemonstration");
        LocalizedString source = field == null ? null : (LocalizedString)field.getValue(LocalizedString.class);
        data.addField("8", "evaluationMethodDemonstration", A3esExportService.PT, source, A3esExportService._3000);
        data.addField("8", "evaluationMethodDemonstration", A3esExportService.EN, source, A3esExportService._3000);
    }

    private void fillBibliography(A3esCourseBean data, CompetenceCourse course) {
        data.addField("9", "bibliographicReferences", this.getBibliography(course), A3esExportService._1000);
    }

    private String getBibliography(CompetenceCourse course) {
        LinkedHashSet result = new LinkedHashSet();
        BibliographicReferences data = course.getBibliographicReferences((ExecutionInterval)this.semester);
        if (data != null) {
            data.getBibliographicReferencesSortedByOrder().stream().forEach(r -> result.add(A3esExportService.getApaFormat(this.removeNonPrintableChars(r.getAuthors()), this.removeNonPrintableChars(r.getYear()), this.removeNonPrintableChars(r.getTitle()), this.removeNonPrintableChars(r.getReference()))));
        }
        return result.stream().collect(Collectors.joining(A3esExportService.PLUS));
    }

    private String removeNonPrintableChars(String value) {
        return value == null ? null : value.replaceAll("\\P{Print}", "");
    }
}

