/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.legalpt.dto.a3es;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.student.RegistrationProtocol;
import org.fenixedu.bennu.IBean;
import org.fenixedu.bennu.TupleDataSourceBean;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.legalpt.domain.a3es.A3esInstance;

public class A3esInstanceBean
implements IBean {
    private Set<RegistrationProtocol> mobilityAgreements;
    private List<TupleDataSourceBean> registrationProtocolsDataSource;
    private boolean studyCycleByDegree;
    private boolean groupCourseProfessorshipByPerson;
    private boolean groupPersonProfessorshipByCourse;

    public A3esInstanceBean(A3esInstance instance) {
        this.setMobilityAgreements(Sets.newHashSet((Iterable)instance.getMobilityAgreementsSet()));
        this.setStudyCycleByDegree(instance.getStudyCycleByDegree());
        this.setGroupCourseProfessorshipByPerson(instance.getGroupCourseProfessorshipByPerson());
        this.setGroupPersonProfessorshipByCourse(instance.getGroupPersonProfessorshipByCourse());
        this.loadDataSources();
    }

    private void loadDataSources() {
        this.registrationProtocolsDataSource = Lists.newArrayList();
        this.registrationProtocolsDataSource.add(new TupleDataSourceBean("", "-"));
        this.registrationProtocolsDataSource.addAll(Bennu.getInstance().getRegistrationProtocolsSet().stream().map(r -> new TupleDataSourceBean(r.getExternalId(), r.getDescription().getContent())).collect(Collectors.toList()));
    }

    public Set<RegistrationProtocol> getMobilityAgreements() {
        return this.mobilityAgreements;
    }

    public void setMobilityAgreements(Set<RegistrationProtocol> mobilityAgreements) {
        this.mobilityAgreements = mobilityAgreements;
    }

    public boolean getStudyCycleByDegree() {
        return this.studyCycleByDegree;
    }

    public void setStudyCycleByDegree(boolean input) {
        this.studyCycleByDegree = input;
    }

    public boolean getGroupCourseProfessorshipByPerson() {
        return this.groupCourseProfessorshipByPerson;
    }

    public void setGroupCourseProfessorshipByPerson(boolean input) {
        this.groupCourseProfessorshipByPerson = input;
    }

    public boolean getGroupPersonProfessorshipByCourse() {
        return this.groupPersonProfessorshipByCourse;
    }

    public void setGroupPersonProfessorshipByCourse(boolean input) {
        this.groupPersonProfessorshipByCourse = input;
    }
}

