/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.legalpt.domain.a3es;

import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.legalpt.domain.a3es.A3esPeriod;
import org.fenixedu.legalpt.domain.a3es.A3esProcess$callable$create;
import org.fenixedu.legalpt.domain.a3es.A3esProcess$callable$delete;
import org.fenixedu.legalpt.domain.a3es.A3esProcess$callable$edit;
import org.fenixedu.legalpt.domain.a3es.A3esProcessType;
import org.fenixedu.legalpt.domain.a3es.A3esProcess_Base;
import org.fenixedu.legalpt.domain.exceptions.LegalPTDomainException;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class A3esProcess
extends A3esProcess_Base {
    public static final Advice advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$create = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$edit = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    protected A3esProcess() {
        this.setRoot(Bennu.getInstance());
    }

    public void delete() {
        Object object = advice$delete.perform((Callable)new A3esProcess$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(A3esProcess this_) {
        this_.setRoot(null);
        this_.setPeriod(null);
        this_.setDegreeCurricularPlan(null);
        super.deleteDomainObject();
    }

    protected void init(A3esPeriod period, String identifier, String description, DegreeCurricularPlan plan) {
        this.setPeriod(period);
        this.setIdentifier(identifier);
        this.setDescription(description);
        this.setDegreeCurricularPlan(plan);
        this.checkRules();
    }

    public void checkRules() {
        if (this.getPeriod() == null) {
            throw new LegalPTDomainException("error.A3esProcess.period.required", new String[0]);
        }
        if (StringUtils.isBlank((String)this.getIdentifier())) {
            throw new LegalPTDomainException("error.A3esProcess.identifier.required", new String[0]);
        }
        if (this.getDegreeCurricularPlan() == null) {
            throw new LegalPTDomainException("error.A3esProcess.degreeCurricularPlan.required", new String[0]);
        }
        if (A3esProcess.find(this.getPeriod(), this.getIdentifier(), this.getDegreeCurricularPlan()).size() != 1) {
            throw new LegalPTDomainException("error.A3esProcess.duplicated", new String[0]);
        }
    }

    public static A3esProcess create(A3esPeriod a3esPeriod, String string, String string2, DegreeCurricularPlan degreeCurricularPlan) {
        return (A3esProcess)((Object)advice$create.perform((Callable)new A3esProcess$callable$create(a3esPeriod, string, string2, degreeCurricularPlan)));
    }

    static /* synthetic */ A3esProcess advised$create(A3esPeriod period, String identifier, String description, DegreeCurricularPlan plan) {
        A3esProcess result = new A3esProcess();
        result.init(period, identifier, description, plan);
        return result;
    }

    public A3esProcess edit(String string, String string2, DegreeCurricularPlan degreeCurricularPlan) {
        return (A3esProcess)((Object)advice$edit.perform((Callable)new A3esProcess$callable$edit(this, string, string2, degreeCurricularPlan)));
    }

    static /* synthetic */ A3esProcess advised$edit(A3esProcess this_, String identifier, String description, DegreeCurricularPlan plan) {
        this_.init(this_.getPeriod(), identifier, description, plan);
        return this_;
    }

    public static Set<A3esProcess> find(A3esPeriod period, String identifier, DegreeCurricularPlan plan) {
        return period == null ? Sets.newHashSet() : period.getProcessSet().stream().filter(i -> StringUtils.isBlank((String)identifier) || StringUtils.equalsIgnoreCase((String)i.getIdentifier(), (String)identifier)).filter(i -> plan == null || i.getDegreeCurricularPlan() == plan).collect(Collectors.toSet());
    }

    public static A3esPeriod getPeriodUnique(ExecutionYear year, A3esProcessType type) {
        Set<A3esPeriod> periods = A3esPeriod.find(year, type, null, null);
        return periods.size() != 1 ? null : periods.iterator().next();
    }

    public ExecutionYear getExecutionYear() {
        return this.getPeriod().getExecutionYear();
    }

    public A3esProcessType getType() {
        return this.getPeriod().getType();
    }

    public boolean isUploadable() {
        return this.getType().getExportService() != null;
    }

    public String getName() {
        return String.format("%s/%s", this.getPeriod().getDescription(), this.getIdentifier());
    }

    public String getPlanDescription() {
        DegreeCurricularPlan plan = this.getDegreeCurricularPlan();
        return A3esProcess.getPlanDescription(plan);
    }

    public static String getPlanDescription(DegreeCurricularPlan plan) {
        return "[" + plan.getDegree().getCode() + "] " + plan.getPresentationName();
    }
}

