/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.legalpt.services.rebides.process;

import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Teacher;
import org.fenixedu.academic.domain.TeacherAuthorization;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.legalpt.domain.LegalReportContext;
import org.fenixedu.legalpt.domain.mapping.LegalMapping;
import org.fenixedu.legalpt.domain.rebides.RebidesReportEntryTarget;
import org.fenixedu.legalpt.domain.rebides.mapping.RebidesMappingType;
import org.fenixedu.legalpt.domain.report.LegalReport;
import org.fenixedu.legalpt.domain.report.LegalReportRequest;
import org.fenixedu.legalpt.dto.rebides.RebidesBean;
import org.fenixedu.legalpt.dto.rebides.TeacherBean;
import org.fenixedu.legalpt.services.rebides.process.CareerActivitiesService;
import org.fenixedu.legalpt.services.rebides.process.ExtractionInfoService;
import org.fenixedu.legalpt.services.rebides.process.IdentificationService;
import org.fenixedu.legalpt.util.LegalPTUtil;
import org.joda.time.ReadablePartial;
import org.joda.time.YearMonthDay;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class RebidesService {
    public static int SIZE_4CHARS = 4;
    public static int SIZE_9CHARS = 9;
    public static int LIMIT_1CHARS = 1;
    public static int LIMIT_2CHARS = 2;
    public static int LIMIT_3CHARS = 3;
    public static int LIMIT_20CHARS = 20;
    public static int LIMIT_50CHARS = 50;
    public static int LIMIT_60CHARS = 60;
    public static int LIMIT_80CHARS = 80;
    public static int LIMIT_160CHARS = 160;
    public static int LIMIT_255CHARS = 255;
    public static int MAX_AGE = 100;
    public static int MIN_AGE = 18;
    public static int LIMIT_100PERCENTAGE = 100;
    public static int LIMIT_99PERCENTAGE = 99;
    public static int LIMIT_0PERCENTAGE = 0;
    public static final DateTimeFormatter LOCAL_DATE_FORMAT = DateTimeFormat.forPattern((String)"yyyy-MM-dd");
    private RebidesBean bean = new RebidesBean();
    protected LegalReport report;

    public RebidesService(LegalReportRequest reportRequest) {
        ExtractionInfoService extractionInfoService = new ExtractionInfoService();
        this.bean.setExtractionInfo(extractionInfoService.getExtractionInfoData(reportRequest));
        this.report = reportRequest.getLegalReport();
    }

    public RebidesBean process(ExecutionYear executionYear) {
        this.checkAllMappings();
        YearMonthDay lastDayOfTheYear = new YearMonthDay(executionYear.getAcademicInterval().getStart().getYear(), 12, 31);
        Bennu.getInstance().getTeachersSet().forEach(t -> {
            TeacherAuthorization teacherAuthorization = t.getLatestTeacherAuthorizationInInterval(lastDayOfTheYear.toInterval()).orElse(null);
            if (!(teacherAuthorization == null || teacherAuthorization.getRevokeTime() != null && teacherAuthorization.getRevokeTime().toLocalDate().isAfter((ReadablePartial)lastDayOfTheYear.toLocalDate()))) {
                TeacherBean teacherBean = new TeacherBean();
                IdentificationService identificationService = new IdentificationService(this.report, (Teacher)t, executionYear);
                teacherBean.setIdentification(identificationService.getIdentificationData());
                CareerActivitiesService careerActivitiesService = new CareerActivitiesService(this.report, (Teacher)t, lastDayOfTheYear, executionYear);
                teacherBean.setCareerActivities(careerActivitiesService.getCareerActivitiesData());
                this.bean.getTeachers().add(teacherBean);
            }
        });
        return this.bean;
    }

    private void checkAllMappings() {
        if (LegalMapping.find(this.report, RebidesMappingType.CONTRACT_CATEGORY) == null) {
            throw new DomainException("rebides.message.error.mapping.is.empty", new String[]{RebidesService.i18n("com.qubit.qubEdu.module.legal.domain.rebides.mapping.RebidesMappingType.CONTRACT_CATEGORY.name", new String[0])});
        }
        if (LegalMapping.find(this.report, RebidesMappingType.CONTRACT_BINDING_REGIME) == null) {
            throw new DomainException("rebides.message.error.mapping.is.empty", new String[]{RebidesService.i18n("com.qubit.qubEdu.module.legal.domain.rebides.mapping.RebidesMappingType.CONTRACT_BINDING_REGIME.name", new String[0])});
        }
        if (LegalMapping.find(this.report, RebidesMappingType.CONTRACT_SERVICE_REGIME) == null) {
            throw new DomainException("rebides.message.error.mapping.is.empty", new String[]{RebidesService.i18n("com.qubit.qubEdu.module.legal.domain.rebides.mapping.RebidesMappingType.CONTRACT_SERVICE_REGIME.name", new String[0])});
        }
        if (LegalMapping.find(this.report, RebidesMappingType.CONTRACT_WAGE_LEVEL) == null) {
            throw new DomainException("rebides.message.error.mapping.is.empty", new String[]{RebidesService.i18n("com.qubit.qubEdu.module.legal.domain.rebides.mapping.RebidesMappingType.CONTRACT_WAGE_LEVEL.name", new String[0])});
        }
        if (LegalMapping.find(this.report, RebidesMappingType.ID_DOCUMENT_TYPE) == null) {
            throw new DomainException("rebides.message.error.mapping.is.empty", new String[]{RebidesService.i18n("com.qubit.qubEdu.module.legal.domain.rebides.mapping.RebidesMappingType.ID_DOCUMENT_TYPE.name", new String[0])});
        }
        if (LegalMapping.find(this.report, RebidesMappingType.BOOLEAN) == null) {
            throw new DomainException("rebides.message.error.mapping.is.empty", new String[]{RebidesService.i18n("com.qubit.qubEdu.module.legal.domain.rebides.mapping.RebidesMappingType.BOOLEAN.name", new String[0])});
        }
        if (LegalMapping.find(this.report, RebidesMappingType.GENDER) == null) {
            throw new DomainException("rebides.message.error.mapping.is.empty", new String[]{RebidesService.i18n("com.qubit.qubEdu.module.legal.domain.rebides.mapping.RebidesMappingType.GENDER.name", new String[0])});
        }
        if (LegalMapping.find(this.report, RebidesMappingType.SCIENTIFIC_AREA) == null) {
            throw new DomainException("rebides.message.error.mapping.is.empty", new String[]{RebidesService.i18n("com.qubit.qubEdu.module.legal.domain.rebides.mapping.RebidesMappingType.SCIENTIFIC_AREA.name", new String[0])});
        }
    }

    public static String i18n(String key, String ... arguments) {
        return LegalPTUtil.bundle(key, arguments);
    }

    public static String createMissingMappingMessage(String field, String value) {
        String fieldName = RebidesService.i18n(field, new String[0]);
        return RebidesService.i18n("rebides.createMissingMappingMessage", fieldName, value);
    }

    public static String createMissingFieldMessage(String field) {
        String fieldName = RebidesService.i18n(field, new String[0]);
        return RebidesService.i18n("rebides.createMissingFieldMessage", fieldName);
    }

    public static String createInvalidFieldMessage(String field) {
        String fieldName = RebidesService.i18n(field, new String[0]);
        return RebidesService.i18n("rebides.createInvalidFieldMessage", fieldName);
    }

    public static Boolean validateMaxFieldSize(Teacher teacher, String field, String fieldContent, int maxFieldSize) {
        if (fieldContent.length() > maxFieldSize) {
            String message = RebidesService.i18n("rebides.fieldSizeOverflow", RebidesService.i18n(field, new String[0]), String.valueOf(fieldContent.length()), String.valueOf(maxFieldSize));
            LegalReportContext.addError(RebidesReportEntryTarget.of(teacher), message);
            return false;
        }
        return true;
    }

    public static Boolean validatePercentageField(Teacher teacher, String field, Integer value, Integer minPercentage, Integer maxPercentage) {
        if (value < minPercentage || value > maxPercentage) {
            String message = RebidesService.i18n("rebides.invalidIntervalValue", RebidesService.i18n(field, new String[0]), String.valueOf(value), String.valueOf(minPercentage), String.valueOf(maxPercentage));
            LegalReportContext.addError(RebidesReportEntryTarget.of(teacher), message);
            return false;
        }
        return true;
    }
}

