/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.legalpt.services.raides.process;

import com.google.common.base.Strings;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.fenixedu.academic.domain.Country;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.person.IDDocumentType;
import org.fenixedu.academic.domain.student.PrecedentDegreeInformation;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.Student;
import org.fenixedu.legalpt.domain.LegalReportContext;
import org.fenixedu.legalpt.domain.mapping.LegalMapping;
import org.fenixedu.legalpt.domain.raides.Raides;
import org.fenixedu.legalpt.domain.raides.RaidesReportEntryTarget;
import org.fenixedu.legalpt.domain.raides.TblIdentificacao;
import org.fenixedu.legalpt.domain.raides.mapping.LegalMappingType;
import org.fenixedu.legalpt.domain.report.LegalReport;
import org.fenixedu.legalpt.services.raides.process.RaidesService;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import org.joda.time.Years;

public class IdentificacaoService
extends RaidesService {
    private static List<String> COUNTRIES_EU = Arrays.asList("AT", "BE", "BG", "CY", "HR", "DK", "SK", "SI", "ES", "EE", "FI", "FR", "GR", "HU", "IE", "IT", "LV", "LT", "LU", "MT", "NL", "PL", "PT", "CZ", "RO", "SE", "DE");
    public static Function<Registration, String> COUNTRY_OF_HIGH_SCHOOL_PROVIDER = registration -> {
        PrecedentDegreeInformation pid = registration.getCompletedDegreeInformation();
        if (pid != null && pid.getEducationLevelType() != null && pid.getEducationLevelType().getHighSchoolOrEquivalent() && pid.getCountry() != null) {
            return pid.getCountry().getCode();
        }
        if (registration.getPerson().getCountryHighSchool() != null) {
            return registration.getPerson().getCountryHighSchool().getCode();
        }
        if (pid.getCountryHighSchool() != null) {
            return pid.getCountryHighSchool().getCode();
        }
        if (registration.getPerson().getCountry() != null) {
            return registration.getPerson().getCountry().getCode();
        }
        return null;
    };

    public IdentificacaoService(LegalReport report) {
        super(report);
    }

    public TblIdentificacao create(Student student, Registration registration, ExecutionYear executionYear) {
        String value;
        TblIdentificacao bean = new TblIdentificacao();
        RaidesReportEntryTarget target = RaidesReportEntryTarget.of(registration, executionYear);
        bean.setIdAluno(registration.getStudent().getNumber());
        bean.setNome(student.getName());
        bean.setNumId(student.getPerson().getDocumentIdNumber());
        if (student.getPerson().getIdDocumentType() != null) {
            value = LegalMapping.find(this.report, LegalMappingType.ID_DOCUMENT_TYPE).translate((Enum<?>)student.getPerson().getIdDocumentType());
            if (StringUtils.isBlank((CharSequence)value)) {
                LegalReportContext.addError(target, this.i18n("error.Raides.validation.idDocumentType.missing.translate", student.getPerson().getIdDocumentType().getLocalizedName()), this.i18n("error.Raides.validation.idDocumentType.missing.translate.action", student.getPerson().getIdDocumentType().getLocalizedName()));
                bean.markAsInvalid();
            } else {
                bean.setTipoId(value);
            }
        }
        if ("7".equals(bean.getTipoId())) {
            bean.setTipoIdDescr(student.getPerson().getIdDocumentType().getLocalizedName(Locale.getDefault()));
        }
        if (student.getPerson().getIdDocumentType() == IDDocumentType.IDENTITY_CARD) {
            String digitControlPerson = student.getPerson().getIdentificationDocumentSeriesNumber();
            bean.setCheckDigitId(digitControlPerson);
            if (Strings.isNullOrEmpty((String)bean.getCheckDigitId()) && student.getPerson().getIdDocumentType() == IDDocumentType.IDENTITY_CARD) {
                try {
                    int digitControl = IdentificacaoService.generatePortugueseIdentityCardControlDigit(student.getPerson().getDocumentIdNumber());
                    bean.setCheckDigitId(String.valueOf(digitControl));
                    LegalReportContext.addWarn(target, this.i18n("warn.Raides.identity.card.digit.control.generated", new String[0]));
                }
                catch (NumberFormatException e) {
                    LegalReportContext.addError(target, this.i18n("error.Raides.validation.cannot.generate.digit.control", new String[0]), this.i18n("error.Raides.validation.cannot.generate.digit.control.action", new String[0]));
                    bean.markAsInvalid();
                }
            }
        }
        if (student.getPerson().getDateOfBirthYearMonthDay() != null) {
            bean.setDataNasc(student.getPerson().getDateOfBirthYearMonthDay().toLocalDate());
        }
        if (student.getPerson().getGender() != null) {
            value = LegalMapping.find(this.report, LegalMappingType.GENDER).translate((Enum<?>)student.getPerson().getGender());
            if (StringUtils.isBlank((CharSequence)value)) {
                LegalReportContext.addError(target, this.i18n("error.Raides.validation.gender.missing.translate", student.getPerson().getGender().getLocalizedName()), this.i18n("error.Raides.validation.gender.missing.translate.action", student.getPerson().getGender().getLocalizedName()));
                bean.markAsInvalid();
            } else {
                bean.setSexo(value);
            }
        } else {
            LegalReportContext.addError(target, this.i18n("error.Raides.validation.gender.missing", new String[0]), this.i18n("error.Raides.validation.gender.missing.action", new String[0]));
            bean.markAsInvalid();
        }
        this.preencheNacionalidade(student, bean);
        Country countryOfResidence = Raides.countryOfResidence(registration, executionYear);
        if (countryOfResidence != null) {
            bean.setResidePais(countryOfResidence.getCode());
        }
        bean.setPaisEnsinoSecundario(this.countryHighSchool(registration));
        this.validaPais(bean, student, registration, executionYear);
        this.validaDocumentoIdentificacao(bean, student, registration, executionYear);
        this.validaDataNascimento(bean, student, registration, executionYear);
        return bean;
    }

    private static int generatePortugueseIdentityCardControlDigit(String idDocumentNumber) throws NumberFormatException {
        Integer.valueOf(idDocumentNumber);
        int mult = 2;
        int controlSum = 0;
        for (int i = 0; i < idDocumentNumber.length(); ++i) {
            controlSum += Integer.valueOf(idDocumentNumber.charAt(idDocumentNumber.length() - i - 1)) * mult;
            ++mult;
        }
        int result = controlSum % 11;
        int checkDigit = result < 2 ? 0 : 11 - result;
        return checkDigit;
    }

    private void preencheNacionalidade(Student student, TblIdentificacao bean) {
        Country firstNationality = student.getPerson().getCountry();
        Country secondNationality = student.getPerson().getSecondNationality();
        if (firstNationality == null && secondNationality == null) {
            return;
        }
        if (firstNationality != null && secondNationality == null) {
            bean.setNacionalidade(firstNationality.getCode());
            bean.setOutroPaisDeNacionalidade(null);
            return;
        }
        if (firstNationality == null && secondNationality != null) {
            bean.setNacionalidade(secondNationality.getCode());
            bean.setOutroPaisDeNacionalidade(null);
            return;
        }
        if (firstNationality != null && firstNationality == secondNationality) {
            bean.setNacionalidade(firstNationality.getCode());
            bean.setOutroPaisDeNacionalidade(null);
            return;
        }
        if (firstNationality.isDefaultCountry() || secondNationality.isDefaultCountry()) {
            if (firstNationality.isDefaultCountry()) {
                bean.setNacionalidade(firstNationality.getCode());
                bean.setOutroPaisDeNacionalidade(secondNationality.getCode());
                return;
            }
            bean.setNacionalidade(secondNationality.getCode());
            bean.setOutroPaisDeNacionalidade(firstNationality.getCode());
            return;
        }
        if (COUNTRIES_EU.contains(firstNationality.getCode()) || COUNTRIES_EU.contains(secondNationality.getCode())) {
            if (COUNTRIES_EU.contains(firstNationality.getCode())) {
                bean.setNacionalidade(firstNationality.getCode());
                bean.setOutroPaisDeNacionalidade(secondNationality.getCode());
                return;
            }
            bean.setNacionalidade(secondNationality.getCode());
            bean.setOutroPaisDeNacionalidade(firstNationality.getCode());
            return;
        }
        bean.setNacionalidade(firstNationality.getCode());
        bean.setOutroPaisDeNacionalidade(secondNationality.getCode());
    }

    public static void setCountryOfHighSchoolProvider(Function<Registration, String> provider) {
        COUNTRY_OF_HIGH_SCHOOL_PROVIDER = provider;
    }

    protected String countryHighSchool(Registration registration) {
        return COUNTRY_OF_HIGH_SCHOOL_PROVIDER.apply(registration);
    }

    protected void validaDataNascimento(TblIdentificacao bean, Student student, Registration registration, ExecutionYear executionYear) {
        RaidesReportEntryTarget target = RaidesReportEntryTarget.of(registration, executionYear);
        if (bean.getDataNasc() == null) {
            LegalReportContext.addError(target, this.i18n("error.Raides.validation.birth.date.missing", new String[0]), this.i18n("error.Raides.validation.birth.date.missing.action", new String[0]));
            bean.markAsInvalid();
        }
        if (bean.getDataNasc() != null) {
            LocalDate december31BeginExecYear = new LocalDate(executionYear.getAcademicInterval().getStart().getYear(), 12, 31);
            long age = Years.yearsBetween((ReadablePartial)bean.getDataNasc(), (ReadablePartial)december31BeginExecYear).getYears();
            if (age < (long)Raides.Idade.MIN.intValue() || age > (long)Raides.Idade.MAX.intValue()) {
                LegalReportContext.addError(target, this.i18n("error.Raides.validation.birth.date.invalid", new String[0]), this.i18n("error.Raides.validation.birth.date.invalid.action", new String[0]));
                bean.markAsInvalid();
            }
        }
    }

    protected void validaDocumentoIdentificacao(TblIdentificacao bean, Student student, Registration registration, ExecutionYear executionYear) {
        RaidesReportEntryTarget target = RaidesReportEntryTarget.of(registration, executionYear);
        if (Strings.isNullOrEmpty((String)bean.getNumId())) {
            LegalReportContext.addError(target, this.i18n("error.Raides.validation.missing.document.id", new String[0]), this.i18n("error.Raides.validation.missing.document.id.action", new String[0]));
            bean.markAsInvalid();
        } else if (bean.getNumId().matches(".*\\s.*")) {
            LegalReportContext.addError(target, this.i18n("error.Raides.validation.document.id.contains.spaces", new String[0]), this.i18n("error.Raides.validation.document.id.contains.spaces.action", new String[0]));
            bean.markAsInvalid();
        } else if (IDDocumentType.IDENTITY_CARD == registration.getPerson().getIdDocumentType() || IDDocumentType.CITIZEN_CARD == registration.getPerson().getIdDocumentType()) {
            if (!bean.getNumId().matches("\\d+")) {
                LegalReportContext.addError(target, this.i18n("error.Raides.validation.national.document.id.contains.other.than.spaces", new String[0]), this.i18n("error.Raides.validation.national.document.id.contains.other.than.spaces.action", new String[0]));
                bean.markAsInvalid();
            }
            if (student.getPerson().getIdDocumentType() == IDDocumentType.IDENTITY_CARD && student.getPerson().getDocumentIdNumber().length() != 8) {
                LegalReportContext.addError(target, this.i18n("error.Raides.validation.document.id.invalid", new String[0]), this.i18n("error.Raides.validation.document.id.invalid.action", new String[0]));
                bean.markAsInvalid();
            }
        }
        if (!Strings.isNullOrEmpty((String)bean.getTipoIdDescr()) && bean.getTipoIdDescr().equalsIgnoreCase(IDDocumentType.OTHER.getLocalizedName(Locale.getDefault()))) {
            LegalReportContext.addError(target, this.i18n("error.Raides.validation.document.id.invalid.other", new String[0]), this.i18n("error.Raides.validation.document.id.invalid.other.action", new String[0]));
            bean.markAsInvalid();
        }
    }

    protected void validaPais(TblIdentificacao bean, Student student, Registration registration, ExecutionYear executionYear) {
        RaidesReportEntryTarget target = RaidesReportEntryTarget.of(registration, executionYear);
        if (Strings.isNullOrEmpty((String)bean.getResidePais())) {
            LegalReportContext.addError(target, this.i18n("error.Raides.validation.country.of.residence.incomplete", new String[0]), this.i18n("error.Raides.validation.country.of.residence.incomplete.action", new String[0]));
            bean.markAsInvalid();
        }
        if (Strings.isNullOrEmpty((String)bean.getNacionalidade())) {
            LegalReportContext.addError(target, this.i18n("error.Raides.validation.nationality.incomplete", new String[0]), this.i18n("error.Raides.validation.nationality.incomplete.action", new String[0]));
            bean.markAsInvalid();
        }
        if (Strings.isNullOrEmpty((String)bean.getPaisEnsinoSecundario())) {
            LegalReportContext.addError(target, this.i18n("error.Raides.validation.high.school.country.missing", new String[0]), this.i18n("error.Raides.validation.high.school.country.missing.action", new String[0]));
            bean.markAsInvalid();
        }
    }
}

