/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.legalpt.domain.raides.report;

import com.google.common.collect.Lists;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.candidacy.IngressionType;
import org.fenixedu.academic.domain.degree.DegreeType;
import org.fenixedu.academic.domain.student.RegistrationProtocol;
import org.fenixedu.bennu.IBean;
import org.fenixedu.bennu.TupleDataSourceBean;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.legalpt.domain.raides.report.RaidesPeriodInputType;
import org.fenixedu.legalpt.domain.raides.report.RaidesRequestPeriodParameter;
import org.fenixedu.legalpt.domain.report.LegalReportRequestParameters;
import org.fenixedu.legalpt.util.LegalPTUtil;
import org.joda.time.LocalDate;

public class RaidesRequestParameter
extends LegalReportRequestParameters
implements Serializable,
IBean {
    private static final long serialVersionUID = 1L;
    private String institutionCode;
    private String moment;
    private String interlocutorName;
    private String interlocutorEmail;
    private String interlocutorPhone;
    private String studentNumber;
    private String reportName;
    private boolean filterEntriesWithErrors;
    private List<RaidesRequestPeriodParameter> periods = Lists.newArrayList();
    private List<RegistrationProtocol> agreementsForMobility = Lists.newArrayList();
    private List<RegistrationProtocol> agreementsForEnrolled = Lists.newArrayList();
    private List<IngressionType> ingressionsForDegreeChange = Lists.newArrayList();
    private List<IngressionType> ingressionsForDegreeTransfer = Lists.newArrayList();
    private List<IngressionType> ingressionsForGeneralAccessRegime = Lists.newArrayList();
    private ExecutionYear graduatedExecutionYear;
    private List<Degree> degrees = Lists.newArrayList();
    private List<TupleDataSourceBean> registrationProtocolsDataSource;
    private List<TupleDataSourceBean> ingressionTypesDataSource;
    private List<TupleDataSourceBean> executionYearsDataSource;

    public RaidesRequestParameter(String institutionCode, String moment, String interlocutorName, String interlocutorEmail, String interlocutorPhone, String studentNumber, String reportName, boolean filterEntriesWithErrors) {
        this.setInstitutionCode(institutionCode);
        this.setMoment(moment);
        this.setInterlocutorName(interlocutorName);
        this.setInstitutionCode(institutionCode);
        this.setInterlocutorPhone(interlocutorPhone);
        this.setFilterEntriesWithErrors(filterEntriesWithErrors);
        this.setStudentNumber(studentNumber);
        this.setReportName(reportName);
        this.loadDataSources();
    }

    public RaidesRequestParameter() {
        this.setFilterEntriesWithErrors(true);
        this.loadDataSources();
    }

    private void loadDataSources() {
        this.loadRegistrationProtocolsDataSource();
        this.loadIngressionTypesDataSource();
        this.loadExecutionYearsDataSource();
    }

    private void loadIngressionTypesDataSource() {
        this.ingressionTypesDataSource = Lists.newArrayList();
        this.ingressionTypesDataSource.add(new TupleDataSourceBean("", LegalPTUtil.bundle("label.select.option", new String[0])));
        this.ingressionTypesDataSource.addAll(Bennu.getInstance().getIngressionTypesSet().stream().map(r -> new TupleDataSourceBean(r.getExternalId(), r.getLocalizedName())).collect(Collectors.toList()));
    }

    private void loadRegistrationProtocolsDataSource() {
        this.registrationProtocolsDataSource = Lists.newArrayList();
        this.registrationProtocolsDataSource.add(new TupleDataSourceBean("", LegalPTUtil.bundle("label.select.option", new String[0])));
        this.registrationProtocolsDataSource.addAll(Bennu.getInstance().getRegistrationProtocolsSet().stream().sorted(RegistrationProtocol.AGREEMENT_COMPARATOR).map(r -> new TupleDataSourceBean(r.getExternalId(), r.getDescription().getContent())).collect(Collectors.toList()));
    }

    private void loadExecutionYearsDataSource() {
        this.executionYearsDataSource = Lists.newArrayList();
        this.executionYearsDataSource.addAll(ExecutionYear.readNotClosedExecutionYears().stream().sorted(ExecutionYear.COMPARATOR_BY_BEGIN_DATE.reversed()).map(ey -> new TupleDataSourceBean(ey.getExternalId(), ey.getQualifiedName())).collect(Collectors.toList()));
    }

    public void checkRules() {
        if (this.getDegrees().isEmpty()) {
            throw new IllegalArgumentException("error.RaidesReportRequest.degrees.required");
        }
        if (StringUtils.isBlank((CharSequence)this.getInstitutionCode())) {
            throw new IllegalArgumentException("error.RaidesReportRequest.institutionCode.required");
        }
    }

    public RaidesRequestPeriodParameter addPeriod(RaidesPeriodInputType periodType, ExecutionYear academicPeriod, LocalDate begin, LocalDate end, boolean enrolledInAcademicPeriod, boolean enrolmentEctsConstraint, BigDecimal minEnrolmentEcts, BigDecimal maxEnrolmentEcts, boolean enrolmentYearsConstraint, Integer minEnrolmentYears, Integer maxEnrolmentYears, Collection<DegreeType> degreeTypes) {
        RaidesRequestPeriodParameter result = new RaidesRequestPeriodParameter(academicPeriod, begin, end, enrolledInAcademicPeriod, periodType, enrolmentEctsConstraint, minEnrolmentEcts, maxEnrolmentEcts, enrolmentYearsConstraint, minEnrolmentYears, maxEnrolmentYears);
        result.addDegreeTypes(degreeTypes);
        this.periods.add(result);
        return result;
    }

    public List<RaidesRequestPeriodParameter> getPeriodsForEnrolled() {
        ArrayList result = Lists.newArrayList();
        for (RaidesRequestPeriodParameter periodParameter : this.getPeriods()) {
            if (!periodParameter.getPeriodInputType().isForEnrolled()) continue;
            result.add(periodParameter);
        }
        return result;
    }

    public List<RaidesRequestPeriodParameter> getPeriodsForGraduated() {
        ArrayList result = Lists.newArrayList();
        for (RaidesRequestPeriodParameter periodParameter : this.getPeriods()) {
            if (!periodParameter.getPeriodInputType().isForGraduated()) continue;
            result.add(periodParameter);
        }
        return result;
    }

    public List<RaidesRequestPeriodParameter> getPeriodsForInternationalMobility() {
        ArrayList result = Lists.newArrayList();
        for (RaidesRequestPeriodParameter periodParameter : this.getPeriods()) {
            if (!periodParameter.getPeriodInputType().isForInternationalMobility()) continue;
            result.add(periodParameter);
        }
        return result;
    }

    public String getInstitutionCode() {
        return this.institutionCode;
    }

    public void setInstitutionCode(String institutionCode) {
        this.institutionCode = institutionCode;
    }

    public String getMoment() {
        return this.moment;
    }

    public void setMoment(String moment) {
        this.moment = moment;
    }

    public String getInterlocutorName() {
        return this.interlocutorName;
    }

    public void setInterlocutorName(String interlocutorName) {
        this.interlocutorName = interlocutorName;
    }

    public String getInterlocutorEmail() {
        return this.interlocutorEmail;
    }

    public void setInterlocutorEmail(String interlocutorEmail) {
        this.interlocutorEmail = interlocutorEmail;
    }

    public String getInterlocutorPhone() {
        return this.interlocutorPhone;
    }

    public void setInterlocutorPhone(String interlocutorPhone) {
        this.interlocutorPhone = interlocutorPhone;
    }

    public String getReportName() {
        return this.reportName;
    }

    public void setReportName(String reportName) {
        this.reportName = reportName;
    }

    public List<RaidesRequestPeriodParameter> getPeriods() {
        return this.periods;
    }

    public void setPeriods(List<RaidesRequestPeriodParameter> periods) {
        this.periods = periods;
    }

    public List<RegistrationProtocol> getAgreementsForMobility() {
        return this.agreementsForMobility;
    }

    public void setAgreementsForMobility(List<RegistrationProtocol> agreementsForMobility) {
        this.agreementsForMobility = agreementsForMobility;
    }

    public List<RegistrationProtocol> getAgreementsForEnrolled() {
        return this.agreementsForEnrolled;
    }

    public void setAgreementsForEnrolled(List<RegistrationProtocol> agreementsForEnrolled) {
        this.agreementsForEnrolled = agreementsForEnrolled;
    }

    public List<IngressionType> getIngressionsForDegreeChange() {
        return this.ingressionsForDegreeChange;
    }

    public void setIngressionsForDegreeChange(List<IngressionType> ingressionsForDegreeChange) {
        this.ingressionsForDegreeChange = ingressionsForDegreeChange;
    }

    public List<IngressionType> getIngressionsForDegreeTransfer() {
        return this.ingressionsForDegreeTransfer;
    }

    public void setIngressionsForDegreeTransfer(List<IngressionType> ingressionsForDegreeTransfer) {
        this.ingressionsForDegreeTransfer = ingressionsForDegreeTransfer;
    }

    public List<IngressionType> getIngressionsForGeneralAccessRegime() {
        return this.ingressionsForGeneralAccessRegime;
    }

    public void setIngressionsForGeneralAccessRegime(List<IngressionType> ingressionsForGeneralAccessRegime) {
        this.ingressionsForGeneralAccessRegime = ingressionsForGeneralAccessRegime;
    }

    public List<Degree> getDegrees() {
        return this.degrees;
    }

    public void setDegrees(List<Degree> degrees) {
        this.degrees = degrees;
    }

    public boolean isFilterEntriesWithErrors() {
        return this.filterEntriesWithErrors;
    }

    public void setFilterEntriesWithErrors(boolean filterEntriesWithErrors) {
        this.filterEntriesWithErrors = filterEntriesWithErrors;
    }

    public String getStudentNumber() {
        return this.studentNumber;
    }

    public void setStudentNumber(String studentNumber) {
        this.studentNumber = studentNumber;
    }

    public ExecutionYear getGraduatedExecutionYear() {
        return this.graduatedExecutionYear;
    }

    public void setGraduatedExecutionYear(ExecutionYear graduatedExecutionYear) {
        this.graduatedExecutionYear = graduatedExecutionYear;
    }

    public RaidesRequestParameter copy() {
        RaidesRequestParameter result = new RaidesRequestParameter();
        result.setAgreementsForEnrolled(this.getAgreementsForEnrolled());
        result.setAgreementsForMobility(this.getAgreementsForMobility());
        result.setDegrees(this.getDegrees());
        result.setFilterEntriesWithErrors(this.filterEntriesWithErrors);
        result.setIngressionsForDegreeChange(this.getIngressionsForDegreeChange());
        result.setIngressionsForDegreeTransfer(this.getIngressionsForDegreeTransfer());
        result.setIngressionsForGeneralAccessRegime(this.getIngressionsForGeneralAccessRegime());
        result.setInstitutionCode(this.getInstitutionCode());
        result.setInterlocutorEmail(this.getInterlocutorEmail());
        result.setInterlocutorName(this.getInterlocutorName());
        result.setInterlocutorPhone(this.getInterlocutorPhone());
        result.setMoment(this.getMoment());
        result.setPeriods(this.getPeriods().stream().map(p -> p.copy()).collect(Collectors.toList()));
        result.setGraduatedExecutionYear(this.getGraduatedExecutionYear());
        result.setReportName(this.getReportName());
        return result;
    }
}

