/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.legalpt.domain.raides;

import com.google.common.base.Strings;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.security.Authenticate;
import org.fenixedu.legalpt.domain.raides.IRaidesReportRequestDefaultData;
import org.fenixedu.legalpt.domain.raides.RaidesInstance;
import org.fenixedu.legalpt.domain.raides.report.RaidesRequestParameter;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class RaidesReportRequestDefaultData
implements IRaidesReportRequestDefaultData {
    public static final DateTimeFormatter DATETIME_FORMATTER = DateTimeFormat.forPattern((String)"dd/MM/yyyy");

    @Override
    public void fill(RaidesRequestParameter raidesRequestParameter) {
        raidesRequestParameter.getAgreementsForEnrolled().addAll(RaidesInstance.getInstance().getEnrolledAgreementsSet());
        raidesRequestParameter.getAgreementsForMobility().addAll(RaidesInstance.getInstance().getMobilityAgreementsSet());
        raidesRequestParameter.getIngressionsForDegreeChange().addAll(RaidesInstance.getInstance().getDegreeChangeIngressionsSet());
        raidesRequestParameter.getIngressionsForDegreeTransfer().addAll(RaidesInstance.getInstance().getDegreeTransferIngressionsSet());
        raidesRequestParameter.getIngressionsForGeneralAccessRegime().addAll(RaidesInstance.getInstance().getGeneralAccessRegimeIngressionsSet());
        raidesRequestParameter.setInstitutionCode(!Strings.isNullOrEmpty((String)RaidesInstance.getInstance().getInstitutionCode()) ? RaidesInstance.getInstance().getInstitutionCode() : Bennu.getInstance().getInstitutionUnit().getCode());
        raidesRequestParameter.setMoment("1");
        raidesRequestParameter.setInterlocutorName(Authenticate.getUser().getPerson().getName());
        raidesRequestParameter.setInterlocutorEmail(Authenticate.getUser().getPerson().getDefaultEmailAddressValue());
        raidesRequestParameter.setInterlocutorPhone(RaidesInstance.getInstance().getInterlocutorPhone());
        raidesRequestParameter.setFilterEntriesWithErrors(true);
    }
}

