/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.ulisboa.integration.sas.service;

import org.fenixedu.academic.domain.Person;
import org.fenixedu.academicextensions.domain.person.dataShare.DataShareAuthorization;
import org.fenixedu.academicextensions.domain.person.dataShare.DataShareAuthorizationType;

public class SasDataShareAuthorizationServices {
    private static final String SAS_AUTHORIZATION_CODE = "SAS";

    public static boolean isAuthorizationTypeActive() {
        return SasDataShareAuthorizationServices.getAuthorizationType() != null && SasDataShareAuthorizationServices.getAuthorizationType().isActive();
    }

    public static boolean isAnswered(Person person) {
        DataShareAuthorizationType authorizationType = SasDataShareAuthorizationServices.getAuthorizationType();
        return authorizationType == null ? false : DataShareAuthorization.findLatest((Person)person, (DataShareAuthorizationType)authorizationType) != null;
    }

    public static boolean isDataShareAllowed(Person person) {
        DataShareAuthorizationType authorizationType = SasDataShareAuthorizationServices.getAuthorizationType();
        return authorizationType == null ? false : DataShareAuthorization.isDataShareAllowed((Person)person, (DataShareAuthorizationType)authorizationType);
    }

    private static DataShareAuthorizationType getAuthorizationType() {
        return DataShareAuthorizationType.findUnique((String)SAS_AUTHORIZATION_CODE);
    }
}

