/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.legalpt.domain.raides.mapping;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.GrantOwnerType;
import org.fenixedu.academic.domain.SchoolPeriodDuration;
import org.fenixedu.academic.domain.candidacy.IngressionType;
import org.fenixedu.academic.domain.curriculum.grade.GradeScale;
import org.fenixedu.academic.domain.degreeStructure.CycleType;
import org.fenixedu.academic.domain.organizationalStructure.AcademicalInstitutionType;
import org.fenixedu.academic.domain.person.Gender;
import org.fenixedu.academic.domain.person.IDDocumentType;
import org.fenixedu.academic.domain.person.MaritalStatus;
import org.fenixedu.academic.domain.student.RegistrationProtocol;
import org.fenixedu.academic.domain.student.RegistrationRegimeType;
import org.fenixedu.academic.domain.student.StatuteType;
import org.fenixedu.academic.domain.student.mobility.MobilityActivityType;
import org.fenixedu.academic.domain.student.mobility.MobilityProgramType;
import org.fenixedu.academic.domain.student.personaldata.EducationLevelType;
import org.fenixedu.academic.domain.student.personaldata.ProfessionCategoryType;
import org.fenixedu.academic.domain.student.personaldata.ProfessionalStatusType;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.commons.i18n.I18N;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.legalpt.domain.mapping.DomainObjectLegalMapping;
import org.fenixedu.legalpt.domain.mapping.EnumerationLegalMapping;
import org.fenixedu.legalpt.domain.mapping.ILegalMappingType;
import org.fenixedu.legalpt.domain.mapping.LegalMapping;
import org.fenixedu.legalpt.domain.mapping.StringLegalMapping;
import org.fenixedu.legalpt.domain.raides.Raides;
import org.fenixedu.legalpt.domain.report.LegalReport;
import org.fenixedu.legalpt.util.LegalPTUtil;
import pt.ist.fenixframework.FenixFramework;

public enum LegalMappingType implements ILegalMappingType
{
    BOOLEAN,
    GENDER,
    ID_DOCUMENT_TYPE,
    CYCLE_TYPE,
    REGIME_TYPE,
    GRANT_OWNER_TYPE,
    GRANT_OWNER_BY_STATUTE_TYPE,
    REGISTRATION_INGRESSION_TYPE,
    MARITAL_STATUS,
    EDUCATION_LEVEL,
    PROFESSIONAL_STATUS,
    PROFESSION_CATEGORY,
    HIGH_SCHOOL_TYPE,
    SCHOOL_PERIOD_DURATION,
    INTERNATIONAL_MOBILITY_PROGRAM,
    INTERNATIONAL_MOBILITY_ACTIVITY,
    CURRICULAR_YEAR,
    REGIME_FREQUENCIA,
    PRECEDENT_EDUCATION_LEVEL,
    INTERNATIONAL_MOBILITY_PROGRAM_AGREEMENT,
    GRADE,
    INTEGRATED_MASTER_FIRST_CYCLE_CODES,
    DEGREE_CURRICULAR_PLAN_DEGREE_OFICIAL_CODE;

    private static final String ENUMERATION_RESOURCES = "resources.EnumerationResources";

    public Set<?> getValues() {
        switch (this) {
            case BOOLEAN: {
                return Sets.newHashSet((Object[])new Boolean[]{Boolean.TRUE, Boolean.FALSE});
            }
            case GENDER: {
                return Sets.newHashSet((Object[])Gender.values());
            }
            case ID_DOCUMENT_TYPE: {
                return Sets.newHashSet((Object[])IDDocumentType.values());
            }
            case CYCLE_TYPE: {
                return Sets.newHashSet((Object[])CycleType.values());
            }
            case REGIME_TYPE: {
                return Sets.newHashSet((Object[])RegistrationRegimeType.values());
            }
            case GRANT_OWNER_TYPE: {
                return Sets.newHashSet((Object[])GrantOwnerType.values());
            }
            case GRANT_OWNER_BY_STATUTE_TYPE: {
                return Sets.newHashSet((Iterable)StatuteType.findAll());
            }
            case REGISTRATION_INGRESSION_TYPE: {
                return Sets.newHashSet((Iterable)Bennu.getInstance().getIngressionTypesSet());
            }
            case MARITAL_STATUS: {
                return Sets.newHashSet((Object[])MaritalStatus.values());
            }
            case EDUCATION_LEVEL: 
            case PRECEDENT_EDUCATION_LEVEL: {
                return EducationLevelType.findAll().collect(Collectors.toSet());
            }
            case PROFESSIONAL_STATUS: {
                return ProfessionalStatusType.findAll().collect(Collectors.toSet());
            }
            case PROFESSION_CATEGORY: {
                return ProfessionCategoryType.findAll().collect(Collectors.toSet());
            }
            case HIGH_SCHOOL_TYPE: {
                return Sets.newHashSet((Object[])AcademicalInstitutionType.values());
            }
            case SCHOOL_PERIOD_DURATION: {
                return Sets.newHashSet((Object[])SchoolPeriodDuration.values());
            }
            case CURRICULAR_YEAR: {
                return Raides.AnoCurricular.VALUES();
            }
            case REGIME_FREQUENCIA: {
                return Raides.RegimeFrequencia.VALUES();
            }
            case INTERNATIONAL_MOBILITY_PROGRAM: {
                return MobilityProgramType.findAllActive();
            }
            case INTERNATIONAL_MOBILITY_ACTIVITY: {
                return MobilityActivityType.findAllActive();
            }
            case INTERNATIONAL_MOBILITY_PROGRAM_AGREEMENT: {
                return Sets.newHashSet((Iterable)Bennu.getInstance().getRegistrationProtocolsSet());
            }
            case GRADE: {
                return GradeScale.findActive((boolean)true).flatMap(gs -> gs.getOrderedGradeScaleEntriesSet().stream()).map(e -> e.getValue()).collect(Collectors.toSet());
            }
            case INTEGRATED_MASTER_FIRST_CYCLE_CODES: {
                return Sets.newHashSet((Iterable)Bennu.getInstance().getDegreesSet().stream().filter(d -> d.getDegreeType().isIntegratedMasterDegree()).collect(Collectors.toSet()));
            }
            case DEGREE_CURRICULAR_PLAN_DEGREE_OFICIAL_CODE: {
                return Bennu.getInstance().getDegreesSet().stream().flatMap(d -> d.getDegreeCurricularPlansSet().stream()).collect(Collectors.toSet());
            }
        }
        return Collections.EMPTY_SET;
    }

    @Override
    public String getCode() {
        return this.name();
    }

    @Override
    public LocalizedString getName() {
        return LegalPTUtil.bundleI18N(this.getQualifiedNameKey(), new String[0]);
    }

    @Override
    public LocalizedString getDescription() {
        return LegalPTUtil.bundleI18N(this.getQualifiedDescriptionKey(), new String[0]);
    }

    protected String getQualifiedDescriptionKey() {
        return this.getClass().getName() + "." + this.name() + ".description";
    }

    protected String getQualifiedNameKey() {
        return this.getClass().getName() + "." + this.name() + ".name";
    }

    @Override
    public LegalMapping createMapping(LegalReport report) {
        switch (this) {
            case GRANT_OWNER_BY_STATUTE_TYPE: 
            case REGISTRATION_INGRESSION_TYPE: 
            case INTERNATIONAL_MOBILITY_PROGRAM: 
            case INTERNATIONAL_MOBILITY_ACTIVITY: 
            case INTERNATIONAL_MOBILITY_PROGRAM_AGREEMENT: 
            case INTEGRATED_MASTER_FIRST_CYCLE_CODES: 
            case DEGREE_CURRICULAR_PLAN_DEGREE_OFICIAL_CODE: {
                return new DomainObjectLegalMapping(report, this);
            }
            case BOOLEAN: 
            case CURRICULAR_YEAR: 
            case REGIME_FREQUENCIA: 
            case GRADE: {
                return new StringLegalMapping(report, this);
            }
        }
        return new EnumerationLegalMapping(report, this);
    }

    @Override
    public LocalizedString getLocalizedNameKey(String key) {
        LocalizedString mls = new LocalizedString();
        switch (this) {
            case BOOLEAN: {
                return LegalPTUtil.bundleI18N("label." + key, new String[0]);
            }
            case GENDER: {
                Gender gender = Gender.valueOf((String)key);
                mls = mls.with(I18N.getLocale(), gender.toLocalizedString(I18N.getLocale()));
                return mls;
            }
            case ID_DOCUMENT_TYPE: {
                IDDocumentType idDocumentType = IDDocumentType.valueOf((String)key);
                mls = mls.with(I18N.getLocale(), idDocumentType.getLocalizedName(I18N.getLocale()));
                return mls;
            }
            case CYCLE_TYPE: {
                CycleType cycleType = CycleType.valueOf((String)key);
                return cycleType.getDescriptionI18N();
            }
            case REGIME_TYPE: {
                RegistrationRegimeType registrationRegimeType = RegistrationRegimeType.valueOf((String)key);
                mls = mls.with(I18N.getLocale(), registrationRegimeType.getLocalizedName());
                return mls;
            }
            case GRANT_OWNER_TYPE: {
                return Raides.Bolseiro.LOCALIZED_NAME(key);
            }
            case GRANT_OWNER_BY_STATUTE_TYPE: {
                return ((StatuteType)FenixFramework.getDomainObject((String)key)).getName();
            }
            case REGISTRATION_INGRESSION_TYPE: {
                return ((IngressionType)FenixFramework.getDomainObject((String)key)).getDescription();
            }
            case MARITAL_STATUS: {
                MaritalStatus maritalStatus = MaritalStatus.valueOf((String)key);
                mls = mls.with(I18N.getLocale(), maritalStatus.getLocalizedName());
                return mls;
            }
            case EDUCATION_LEVEL: 
            case PRECEDENT_EDUCATION_LEVEL: {
                return ((EducationLevelType)FenixFramework.getDomainObject((String)key)).getName();
            }
            case PROFESSIONAL_STATUS: {
                return ((ProfessionalStatusType)FenixFramework.getDomainObject((String)key)).getName();
            }
            case PROFESSION_CATEGORY: {
                return ((ProfessionCategoryType)FenixFramework.getDomainObject((String)key)).getName();
            }
            case HIGH_SCHOOL_TYPE: {
                AcademicalInstitutionType academicalInstitutionType = AcademicalInstitutionType.valueOf((String)key);
                return this.localizedName(academicalInstitutionType, I18N.getLocale());
            }
            case SCHOOL_PERIOD_DURATION: {
                return LegalPTUtil.bundleI18N("label.SchoolPeriodDuration." + key, new String[0]);
            }
            case CURRICULAR_YEAR: {
                return Raides.AnoCurricular.LOCALIZED_NAME(key);
            }
            case REGIME_FREQUENCIA: {
                return Raides.RegimeFrequencia.LOCALIZED_NAME(key);
            }
            case INTERNATIONAL_MOBILITY_PROGRAM: {
                return ((MobilityProgramType)FenixFramework.getDomainObject((String)key)).getName();
            }
            case INTERNATIONAL_MOBILITY_ACTIVITY: {
                return ((MobilityActivityType)FenixFramework.getDomainObject((String)key)).getName();
            }
            case INTERNATIONAL_MOBILITY_PROGRAM_AGREEMENT: {
                return ((RegistrationProtocol)FenixFramework.getDomainObject((String)key)).getDescription();
            }
            case GRADE: {
                return new LocalizedString(new Locale("PT"), key);
            }
            case INTEGRATED_MASTER_FIRST_CYCLE_CODES: {
                Degree degree = (Degree)FenixFramework.getDomainObject((String)key);
                return new LocalizedString(I18N.getLocale(), "[" + degree.getCode() + "] " + degree.getPresentationName());
            }
            case DEGREE_CURRICULAR_PLAN_DEGREE_OFICIAL_CODE: {
                DegreeCurricularPlan degreeCurricularPlan = (DegreeCurricularPlan)FenixFramework.getDomainObject((String)key);
                return new LocalizedString(I18N.getLocale(), "[" + degreeCurricularPlan.getDegree().getCode() + "] " + degreeCurricularPlan.getPresentationName());
            }
        }
        return new LocalizedString();
    }

    private LocalizedString localizedName(AcademicalInstitutionType academicalInstitutionType, Locale ... locales) {
        return this.localizedName(ENUMERATION_RESOURCES, academicalInstitutionType.getClass().getSimpleName() + "." + academicalInstitutionType.name(), locales);
    }

    private LocalizedString localizedName(String bundle, String key, Locale ... locales) {
        return BundleUtil.getLocalizedString((String)ENUMERATION_RESOURCES, (String)key, (String[])new String[0]);
    }
}

