/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.ulisboa.integration.sas.domain;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.fenixedu.academic.domain.candidacy.IngressionType;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.StatuteType;
import org.fenixedu.academic.domain.student.curriculum.CreditsReasonType;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.ulisboa.integration.sas.domain.SocialServicesConfiguration_Base;

public class SocialServicesConfiguration
extends SocialServicesConfiguration_Base {
    public SocialServicesConfiguration() {
        this.setBennu(Bennu.getInstance());
    }

    public void edit(int numberOfMonthsOfAcademicYear, String email, String institutionCode, Collection<IngressionType> ingressionTypesWhichAreDegreeTransfer, Collection<IngressionType> ingressionTypesWithExternalData, Collection<CreditsReasonType> creditsReasonTypes, StatuteType statuteType) {
        SocialServicesConfiguration config = Bennu.getInstance().getSocialServicesConfiguration();
        config.setNumberOfMonthsOfAcademicYear(numberOfMonthsOfAcademicYear);
        config.setEmail(email);
        config.setInstitutionCode(institutionCode);
        Set ingressionTypeWhichAreDegreeTransferSet = config.getIngressionTypeWhichAreDegreeTransferSet();
        ingressionTypeWhichAreDegreeTransferSet.clear();
        ingressionTypeWhichAreDegreeTransferSet.addAll(ingressionTypesWhichAreDegreeTransfer);
        Set ingressionTypesWithExternalDataSet = config.getIngressionTypesWithExternalDataSet();
        ingressionTypesWithExternalDataSet.clear();
        ingressionTypesWithExternalDataSet.addAll(ingressionTypesWithExternalData);
        Set creditsReasonType = config.getCreditsReasonTypesSet();
        creditsReasonType.clear();
        creditsReasonType.addAll(creditsReasonTypes);
        config.setStatuteTypeSas(statuteType);
    }

    public static SocialServicesConfiguration getInstance() {
        return Bennu.getInstance().getSocialServicesConfiguration();
    }

    public Collection<String> getInstitutionCodes() {
        return StringUtils.isBlank((CharSequence)this.getInstitutionCode()) ? Collections.emptySet() : (Collection)Stream.of(this.getInstitutionCode().split(",")).map(s -> s.trim()).collect(Collectors.toSet());
    }

    public boolean ingressionTypeRequiresExternalData(Registration registration) {
        return registration.getIngressionType() != null && this.getIngressionTypesWithExternalDataSet().contains(registration.getIngressionType());
    }
}

