/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.legalpt.domain.report;

import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.legalpt.domain.report.LegalReportRequest;
import org.fenixedu.legalpt.domain.report.LegalReportResultFileType;
import org.fenixedu.legalpt.domain.report.LegalReportResultFile_Base;
import org.joda.time.DateTime;

public class LegalReportResultFile
extends LegalReportResultFile_Base {
    public LegalReportResultFile() {
        this.setBennu(Bennu.getInstance());
    }

    public LegalReportResultFile(LegalReportRequest reportRequest, LegalReportResultFileType type, byte[] content) {
        this(reportRequest, type, reportRequest.getLegalReport().getName().getContent() + "_" + new DateTime().toString("dd-MM-yyyy-HH-mm") + "." + type.getFileExtension(), content);
    }

    public LegalReportResultFile(LegalReportRequest reportRequest, LegalReportResultFileType type, String filename, byte[] content) {
        this();
        this.setType(type);
        this.setLegalReportRequest(reportRequest);
        String displayName = reportRequest.getLegalReport().getName().getContent() + "_" + new DateTime().toString("dd-MM-yyyy-HH-mm");
        this.init(displayName, filename, content);
    }

    public boolean isAccessible(User user) {
        return this.getLegalReportRequest().getLegalReport().getGroup().isMember(user);
    }

    public void delete() {
        this.setLegalReportRequest(null);
        this.setBennu(null);
        super.delete();
    }
}

