/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.ulisboa.integration.sas.servlet;

import com.qubit.terra.framework.services.logging.Log;
import java.lang.annotation.Annotation;
import java.util.concurrent.Callable;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.annotation.WebListener;
import org.fenixedu.academic.domain.student.personaldata.EducationLevelType;
import org.fenixedu.academic.domain.student.personaldata.ProfessionCategoryType;
import org.fenixedu.academic.domain.student.personaldata.ProfessionalStatusType;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.legalpt.domain.mapping.DomainObjectLegalMapping;
import org.fenixedu.legalpt.domain.mapping.EnumerationLegalMapping;
import org.fenixedu.legalpt.domain.mapping.ILegalMappingType;
import org.fenixedu.legalpt.domain.raides.mapping.LegalMappingType;
import org.fenixedu.legalpt.domain.report.LegalReport;
import org.fenixedu.ulisboa.integration.sas.domain.EducationLevelTypeMapping;
import org.fenixedu.ulisboa.integration.sas.domain.SchoolLevelTypeMapping;
import org.fenixedu.ulisboa.integration.sas.domain.SocialServicesConfiguration;
import org.fenixedu.ulisboa.integration.sas.service.sicabe.SicabeExternalService;
import org.fenixedu.ulisboa.integration.sas.servlet.SasInitializer$callable$contextInitialized;
import org.fenixedu.ulisboa.integration.sas.servlet.SasInitializer$callable$createNewDomainMappingsFromEnumerationMappings;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.DomainObject;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

@WebListener
public class SasInitializer
implements ServletContextListener {
    public static final Advice advice$contextInitialized = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$createNewDomainMappingsFromEnumerationMappings = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.WRITE, true));

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        Object object = advice$contextInitialized.perform((Callable)new SasInitializer$callable$contextInitialized(this, servletContextEvent));
    }

    static /* synthetic */ void advised$contextInitialized(SasInitializer this_, ServletContextEvent event) {
        if (Bennu.getInstance().getSocialServicesConfiguration() == null) {
            SocialServicesConfiguration socialServicesConfiguration = new SocialServicesConfiguration();
        }
        SchoolLevelTypeMapping.registerEvents();
        EducationLevelTypeMapping.registerEvents();
        SicabeExternalService.init();
        this_.createNewDomainMappingsFromEnumerationMappings();
        SasInitializer.createEducationLevelTypeMappings();
    }

    public void contextDestroyed(ServletContextEvent event) {
    }

    private void createNewDomainMappingsFromEnumerationMappings() {
        Object object = advice$createNewDomainMappingsFromEnumerationMappings.perform((Callable)new SasInitializer$callable$createNewDomainMappingsFromEnumerationMappings(this));
    }

    static /* synthetic */ void advised$createNewDomainMappingsFromEnumerationMappings(SasInitializer this_) {
        this_.migrateMapping("SCHOOL_LEVEL", LegalMappingType.EDUCATION_LEVEL);
        this_.migrateMapping("PROFESSION_TYPE", LegalMappingType.PROFESSION_CATEGORY);
        this_.migrateMapping("PROFESSIONAL_SITUATION_CONDITION", LegalMappingType.PROFESSIONAL_STATUS);
        this_.migrateMapping("PRECEDENT_SCHOOL_LEVEL", LegalMappingType.PRECEDENT_EDUCATION_LEVEL);
    }

    private void migrateMapping(String sourceType, LegalMappingType targetType) {
        EnumerationLegalMapping sourceMapping = Bennu.getInstance().getLegalMappingsSet().stream().filter(EnumerationLegalMapping.class::isInstance).map(EnumerationLegalMapping.class::cast).filter(mapping -> mapping.getType().equals(sourceType)).findFirst().orElse(null);
        if (sourceMapping == null) {
            Log.warn((String)("No " + sourceType + " enumeration mapping found"));
            return;
        }
        if (DomainObjectLegalMapping.find((LegalReport)sourceMapping.getLegalReport(), (ILegalMappingType)targetType) == null) {
            Log.warn((String)("Creating new DomainObjectLegalMapping for type: " + targetType));
            DomainObjectLegalMapping targetMapping = new DomainObjectLegalMapping(sourceMapping.getLegalReport(), targetType);
            SasInitializer.addEntriesToTargetMapping(targetType, sourceMapping, targetMapping);
            Log.warn((String)("New DomainObjectLegalMapping created for type: " + targetType));
        }
    }

    private static void addEntriesToTargetMapping(LegalMappingType targetType, EnumerationLegalMapping sourceMapping, DomainObjectLegalMapping targetMapping) {
        sourceMapping.getLegalMappingEntriesSet().forEach(e -> {
            DomainObject key = null;
            switch (targetType) {
                case EDUCATION_LEVEL: 
                case PRECEDENT_EDUCATION_LEVEL: {
                    key = (DomainObject)EducationLevelType.findByCode((String)e.getMappingKey()).orElseThrow(() -> new IllegalArgumentException("Invalid Education Level Code: " + e.getMappingKey()));
                    break;
                }
                case PROFESSION_CATEGORY: {
                    key = (DomainObject)ProfessionCategoryType.findByCode((String)e.getMappingKey()).orElseThrow(() -> new IllegalArgumentException("Invalid Profession Category Code: " + e.getMappingKey()));
                    break;
                }
                case PROFESSIONAL_STATUS: {
                    key = (DomainObject)ProfessionalStatusType.findByCode((String)e.getMappingKey()).orElseThrow(() -> new IllegalArgumentException("Invalid Professional Status Code: " + e.getMappingKey()));
                    break;
                }
                default: {
                    Log.error((String)("Unsupported targetType: " + targetType));
                }
            }
            if (key != null) {
                targetMapping.addEntry(key, e.getMappingValue());
            }
        });
    }

    private static void createEducationLevelTypeMappings() {
        SchoolLevelTypeMapping.findAll().forEach(m -> {
            EducationLevelType educationLevelType = (EducationLevelType)EducationLevelType.findByCode((String)m.getSchoolLevel().getName()).orElseThrow(() -> new IllegalArgumentException("Invalid School Level Code: " + m.getSchoolLevel().getName()));
            if (EducationLevelTypeMapping.find(m.getDegreeType()).isEmpty()) {
                Log.warn((String)("Creating new EducationLevelTypeMapping with code: " + educationLevelType.getCode() + " and degree type: " + m.getDegreeType().getCode()));
                EducationLevelTypeMapping.create(educationLevelType, m.getDegreeType());
                Log.warn((String)("New EducationLevelTypeMapping created for code: " + educationLevelType.getCode() + " and degree type: " + m.getDegreeType().getCode()));
            }
        });
    }
}

