/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.ulisboa.integration.sas.domain;

import java.util.stream.Stream;
import org.fenixedu.academic.domain.candidacy.IngressionType;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.ulisboa.integration.sas.domain.SasIngressionRegimeMapping_Base;

public class SasIngressionRegimeMapping
extends SasIngressionRegimeMapping_Base {
    public static SasIngressionRegimeMapping create(IngressionType ingression, String regimeCode, String regimeCodeWithDescription) {
        SasIngressionRegimeMapping.checkPreConditions(null, ingression, regimeCode, regimeCodeWithDescription);
        SasIngressionRegimeMapping ingressionRegimeMapping = new SasIngressionRegimeMapping();
        ingressionRegimeMapping.setIngressionType(ingression);
        ingressionRegimeMapping.setRegimeCode(regimeCode);
        ingressionRegimeMapping.setRegimeCodeWithDescription(regimeCodeWithDescription);
        ingressionRegimeMapping.setBennu(Bennu.getInstance());
        return ingressionRegimeMapping;
    }

    public void edit(IngressionType ingression, String regimeCode, String regimeCodeWithDescription) {
        SasIngressionRegimeMapping.checkPreConditions(this, ingression, regimeCode, regimeCodeWithDescription);
        this.setIngressionType(ingression);
        this.setRegimeCode(regimeCode);
        this.setRegimeCodeWithDescription(regimeCodeWithDescription);
    }

    public static void checkPreConditions(SasIngressionRegimeMapping ingressionRegimeMapping, IngressionType ingression, String regimeCode, String regimeCodeWithDescription) {
        if (ingression == null) {
            throw new RuntimeException("Ingression Type");
        }
        if (regimeCode == null) {
            throw new RuntimeException("Regime Code");
        }
        if (regimeCodeWithDescription == null) {
            throw new RuntimeException("Regime Code With Description");
        }
        SasIngressionRegimeMapping regimeCurrentIngressionRegimeMapping = ingression.getSasIngressionRegimeMapping();
        if (regimeCurrentIngressionRegimeMapping != null && regimeCurrentIngressionRegimeMapping != ingressionRegimeMapping) {
            throw new RuntimeException("Ingression type already has associated Regime");
        }
    }

    public void delete() {
        this.setIngressionType(null);
        this.setBennu(null);
        super.deleteDomainObject();
    }

    public static Stream<SasIngressionRegimeMapping> findAll() {
        return Bennu.getInstance().getSasIngressionRegimeMappingsSet().stream();
    }
}

