/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.legalpt.services.raides.export;

import com.google.common.base.Strings;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Optional;
import java.util.concurrent.Callable;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.student.PrecedentDegreeInformation;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.personaldata.EducationLevelType;
import org.fenixedu.academic.domain.student.personaldata.EducationLevelType_Base;
import org.fenixedu.academic.domain.student.personaldata.ProfessionCategoryType;
import org.fenixedu.academic.domain.student.personaldata.ProfessionCategoryType_Base;
import org.fenixedu.academic.domain.student.personaldata.ProfessionalStatusType;
import org.fenixedu.academic.domain.student.personaldata.ProfessionalStatusType_Base;
import org.fenixedu.academic.domain.time.calendarStructure.AcademicCalendarRootEntry;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.commons.spreadsheet.SheetData;
import org.fenixedu.commons.spreadsheet.SpreadsheetBuilderForXLSX;
import org.fenixedu.legalpt.domain.raides.Raides;
import org.fenixedu.legalpt.domain.raides.TblDiplomado;
import org.fenixedu.legalpt.domain.raides.TblIdentificacao;
import org.fenixedu.legalpt.domain.raides.TblInscrito;
import org.fenixedu.legalpt.domain.raides.TblMobilidadeInternacional;
import org.fenixedu.legalpt.domain.report.LegalReportRequest;
import org.fenixedu.legalpt.domain.report.LegalReportResultFile;
import org.fenixedu.legalpt.domain.report.LegalReportResultFileType;
import org.fenixedu.legalpt.services.raides.export.XlsxExporter$callable$writeFile;
import org.fenixedu.legalpt.util.LegalPTUtil;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class XlsxExporter {
    public static final Advice advice$writeFile = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.WRITE, true));

    public static LegalReportResultFile write(LegalReportRequest reportRequest, final Raides raides) {
        SheetData<TblIdentificacao> identificationData = new SheetData<TblIdentificacao>(raides.getAllIdentifications()){

            protected void makeLine(TblIdentificacao tblIdentificacao) {
                this.addCell("DataNascimento", tblIdentificacao.getDataNasc());
                this.addCell("DigitosControlo", tblIdentificacao.getCheckDigitId());
                this.addCell("Nome", tblIdentificacao.getNome());
                this.addCell("NumeroAluno", tblIdentificacao.getIdAluno());
                this.addCell("NumeroId", tblIdentificacao.getNumId());
                this.addCell("NumeroIdTipo", tblIdentificacao.getTipoId());
                this.addCell("OutroPaisDeNacionalidade", "");
                this.addCell("OutroTipoID", tblIdentificacao.getTipoIdDescr());
                this.addCell("PaisDeNacionalidade", tblIdentificacao.getNacionalidade());
                this.addCell("OutroPaisDeNacionalidade", tblIdentificacao.getOutroPaisDeNacionalidade());
                this.addCell("PaisEnsinoSec", tblIdentificacao.getPaisEnsinoSecundario());
                this.addCell("PaisResidencia", tblIdentificacao.getResidePais());
                this.addCell("Sexo", tblIdentificacao.getSexo());
            }
        };
        SheetData<TblInscrito> inscritoData = new SheetData<TblInscrito>(raides.getAllInscritos()){

            protected void makeLine(TblInscrito tblInscrito) {
                this.addCell("IdAluno", tblInscrito.getIdAluno());
                this.addCell("Curso", tblInscrito.getCurso());
                this.addCell("Ramo", tblInscrito.getRamo());
                this.addCell("AnoLetivo", tblInscrito.getAnoLectivo());
                this.addCell("AnoCurricular", tblInscrito.getAnoCurricular());
                this.addCell("PrimeiraVez", tblInscrito.getPrimeiraVez());
                this.addCell("RegimeFrequencia", tblInscrito.getRegimeFrequencia());
                this.addCell("NumInscNesteCurso", tblInscrito.getNumInscNesteCurso() != null ? Integer.valueOf(tblInscrito.getNumInscNesteCurso()) : "");
                this.addCell("ECTSInscricao", tblInscrito.getEctsInscricao() != null ? tblInscrito.getEctsInscricao().toString() : "");
                this.addCell("ECTSAcumulados", tblInscrito.getEctsAcumulados() != null ? tblInscrito.getEctsAcumulados().toString() : "");
                this.addCell("TempoParcial", tblInscrito.getTempoParcial());
                this.addCell("Bolseiro", tblInscrito.getBolseiro());
                this.addCell("FormaIngresso", tblInscrito.getFormaIngresso());
                this.addCell("EstabInscricaoAnt", tblInscrito.getEstabInscricaoAnt());
                this.addCell("OutroEstabInscAnt", tblInscrito.getOutroEstabInscAnt());
                this.addCell("NotaIngresso", tblInscrito.getNotaIngresso());
                this.addCell("OpcaoIngresso", tblInscrito.getOpcaoIngresso());
                this.addCell("NumInscCursosAnt", tblInscrito.getNumInscCursosAnt());
                this.addCell("AnoUltimaInscricao", tblInscrito.getAnoUltimaInscricao());
                this.addCell("EstadoCivil", tblInscrito.getEstadoCivil());
                this.addCell("TrabalhadorEstudante", tblInscrito.getEstudanteTrabalhador());
                this.addCell("AlunoDeslocado", tblInscrito.getAlunoDeslocado());
                this.addCell("Concelho", tblInscrito.getResideConcelho());
                this.addCell("NivelEscolarPai", tblInscrito.getNivelEscolarPai());
                this.addCell("NivelEscolarMae", tblInscrito.getNivelEscolarMae());
                this.addCell("SituacaoProfPai", tblInscrito.getSituacaoProfPai());
                this.addCell("SituacaoProfMae", tblInscrito.getSituacaoProfMae());
                this.addCell("SituacaoProfAluno", tblInscrito.getSituacaoProfAluno());
                this.addCell("ProfissaoPai", tblInscrito.getProfissaoPai());
                this.addCell("ProfissaoMae", tblInscrito.getProfissaoMae());
                this.addCell("ProfissaoAluno", tblInscrito.getProfissaoAluno());
                this.addCell("EscolaridadeAnterior", tblInscrito.getEscolaridadeAnterior());
                this.addCell("OutroEscolaridadeAnterior", tblInscrito.getOutroEscolaridadeAnterior());
                this.addCell("PaisEscolaridadeAnt", tblInscrito.getPaisEscolaridadeAnt());
                this.addCell("AnoEscolaridadeAnt", tblInscrito.getAnoEscolaridadeAnt());
                this.addCell("EstabEscolaridadeAnt", tblInscrito.getEstabEscolaridadeAnt());
                this.addCell("OutroEstabEscolarAnt", tblInscrito.getOutroEstabEscolarAnt());
                this.addCell("CursoEscolarAnt", tblInscrito.getCursoEscolarAnt());
                this.addCell("OutroCursoEscolarAnt", tblInscrito.getOutroCursoEscolarAnt());
                this.addCell("TipoEstabSec", tblInscrito.getTipoEstabSec());
            }
        };
        SheetData<TblDiplomado> diplomadoData = new SheetData<TblDiplomado>(raides.getAllDiplomados()){

            protected void makeLine(TblDiplomado tblDiplomado) {
                this.addCell("IdAluno", tblDiplomado.getIdAluno());
                this.addCell("Curso", tblDiplomado.getCurso());
                this.addCell("Ramo", tblDiplomado.getRamo());
                this.addCell("AnoLetivo", tblDiplomado.getAnoLectivo());
                this.addCell("AreaInvestigacao", tblDiplomado.getAreaInvestigacao());
                this.addCell("ConcluiGrau", tblDiplomado.getConcluiGrau());
                this.addCell("NumInscConclusao", tblDiplomado.getNumInscConclusao());
                this.addCell("ClassificacaoFinal", tblDiplomado.getClassificacaoFinal());
                this.addCell("DataDiploma", tblDiplomado.getDataDiploma() != null ? tblDiplomado.getDataDiploma().toString("dd-MM-yyyy") : "");
                this.addCell("ConclusaoMD", tblDiplomado.getConclusaoMd());
                this.addCell("ClassificacaoFinalMD", tblDiplomado.getClassificacaoFinalMd());
                this.addCell("MobilidadeCredito", tblDiplomado.getMobilidadeCredito());
                this.addCell("TipoMobilidadeCredito", tblDiplomado.getTipoMobilidadeCredito());
                this.addCell("ProgMobilidadeCredito", tblDiplomado.getProgMobilidadeCredito());
                this.addCell("OutroProgMobCredito", tblDiplomado.getOutroProgMobCredito());
                this.addCell("PaisMobilidadeCredito", tblDiplomado.getPaisMobilidadeCredito());
                this.addCell("EscolaridadeAnterior", tblDiplomado.getEscolaridadeAnterior());
                this.addCell("OutroEscolaridadeAnterior", tblDiplomado.getOutroEscolaridadeAnterior());
                this.addCell("PaisEscolaridadeAnt", tblDiplomado.getPaisEscolaridadeAnt());
                this.addCell("AnoEscolaridadeAnt", tblDiplomado.getAnoEscolaridadeAnt());
                this.addCell("EstabEscolaridadeAnt", tblDiplomado.getEstabEscolaridadeAnt());
                this.addCell("OutroEstabEscolarAnt", tblDiplomado.getOutroEstabEscolarAnt());
                this.addCell("CursoEscolarAnt", tblDiplomado.getCursoEscolarAnt());
                this.addCell("OutroCursoEscolarAnt", tblDiplomado.getOutroCursoEscolarAnt());
            }
        };
        SheetData<TblMobilidadeInternacional> mobilidadeInternacionalData = new SheetData<TblMobilidadeInternacional>(raides.getAllMobilidadeInternacional()){

            protected void makeLine(TblMobilidadeInternacional tblMobilidadeInternacional) {
                this.addCell("IdAluno", tblMobilidadeInternacional.getIdAluno());
                this.addCell("Curso", !Strings.isNullOrEmpty((String)tblMobilidadeInternacional.getCurso()) ? tblMobilidadeInternacional.getCurso() : "");
                this.addCell("Ramo", !Strings.isNullOrEmpty((String)tblMobilidadeInternacional.getRamo()) ? tblMobilidadeInternacional.getRamo() : "");
                this.addCell("AnoLetivo", tblMobilidadeInternacional.getAnoLectivo());
                this.addCell("AreaCientifica", tblMobilidadeInternacional.getAreaCientifica());
                this.addCell("AnoCurricular", tblMobilidadeInternacional.getAnoCurricular());
                this.addCell("RegimeFrequencia", tblMobilidadeInternacional.getRegimeFrequencia());
                this.addCell("ECTSInscricao", tblMobilidadeInternacional.getEctsInscrito());
                this.addCell("ProgMobilidade", tblMobilidadeInternacional.getProgMobilidade());
                this.addCell("OutroPrograma", tblMobilidadeInternacional.getOutroPrograma());
                this.addCell("TipoProgMobilidade", tblMobilidadeInternacional.getTipoProgMobilidade());
                this.addCell("DuracaoPrograma", tblMobilidadeInternacional.getDuracaoPrograma());
                this.addCell("NivelCursoOrigem", tblMobilidadeInternacional.getNivelCursoOrigem());
                this.addCell("PaisOrigemMobilidadeCredito", tblMobilidadeInternacional.getPaisOrigemMobilidadeCredito());
                this.addCell("OutroNivelCurOrigem", tblMobilidadeInternacional.getOutroNivelCurOrigem());
                this.addCell("AreaCientifica", tblMobilidadeInternacional.getAreaCientifica());
                this.addCell("NivelCursoDestino", tblMobilidadeInternacional.getNivelCursoDestino());
                this.addCell("OutroNivelCurDestino", tblMobilidadeInternacional.getOutroNivelCursoDestino());
            }
        };
        SheetData<Registration> precedentDegreeInformationData = new SheetData<Registration>(raides.getAllRegistrations()){

            protected void makeLine(Registration registration) {
                this.addCell("N\u00ba Aluno", registration.getStudent().getNumber());
                this.addCell(XlsxExporter.pdiLabel("executionYear"), registration.getRegistrationYear().getQualifiedName());
                this.addCell("Curso", registration.getDegree().getPresentationName());
                this.addCell("Acordo", registration.getRegistrationProtocol() != null ? registration.getRegistrationProtocol().getDescription().getContent() : "");
                this.addCell("Ingresso", registration.getIngressionType() != null ? registration.getIngressionType().getDescription().getContent() : "");
                this.addCell("Nome", registration.getStudent().getName());
                this.addCell("Reportar como Inscrito", raides.isInEnrolledData(registration));
                this.addCell("Reportar como Diplomado", raides.isInGraduated(registration));
                this.addCell("Reportar como Mobilidade", raides.isInInternacionalMobility(registration));
                PrecedentDegreeInformation lastCompletedQualification = registration.getCompletedDegreeInformation();
                this.addCell(XlsxExporter.pdiLabel("educationLevel"), XlsxExporter.educationLevelLocalizedName(lastCompletedQualification.getEducationLevelType()));
                this.addCell(XlsxExporter.pdiLabel("otherSchoolLevel"), lastCompletedQualification.getOtherSchoolLevel());
                this.addCell(XlsxExporter.pdiLabel("country"), lastCompletedQualification.getCountry() != null ? lastCompletedQualification.getCountry().getCode() : "");
                this.addCell(XlsxExporter.pdiLabel("institution"), lastCompletedQualification.getInstitution() != null ? lastCompletedQualification.getInstitution().getName() : "");
                this.addCell(XlsxExporter.pdiLabel("degreeDesignation"), lastCompletedQualification.getDegreeDesignation());
                this.addCell(XlsxExporter.pdiLabel("conclusionGrade"), lastCompletedQualification.getConclusionGrade());
                this.addCell(XlsxExporter.pdiLabel("conclusionYear"), lastCompletedQualification.getConclusionYear() != null ? lastCompletedQualification.getConclusionYear() : "");
                PrecedentDegreeInformation previousQualification = registration.getPreviousDegreeInformation();
                this.addCell(XlsxExporter.pdiLabel("precedentEducationLevel"), previousQualification != null ? XlsxExporter.educationLevelLocalizedName(previousQualification.getEducationLevelType()) : "");
                this.addCell(XlsxExporter.pdiLabel("otherPrecedentSchoolLevel"), previousQualification != null ? previousQualification.getOtherSchoolLevel() : "");
                this.addCell(XlsxExporter.pdiLabel("precedentCountry"), previousQualification != null && previousQualification.getCountry() != null ? previousQualification.getCountry().getCode() : "");
                this.addCell(XlsxExporter.pdiLabel("precedentInstitution"), previousQualification != null && previousQualification.getInstitution() != null ? previousQualification.getInstitution().getName() : "");
                this.addCell(XlsxExporter.pdiLabel("precedentDegreeDesignation"), previousQualification != null ? previousQualification.getDegreeDesignation() : "");
                this.addCell(XlsxExporter.pdiLabel("numberOfEnrolmentsInPreviousDegrees"), previousQualification != null && previousQualification.getNumberOfEnrolmentsInPreviousDegrees() != null ? previousQualification.getNumberOfEnrolmentsInPreviousDegrees() : "");
            }
        };
        SheetData<Registration> personalIngressionDataSheetData = new SheetData<Registration>(raides.getAllRegistrations()){

            protected void makeLine(Registration registration) {
                ExecutionYear currentYear = ExecutionYear.findCurrent((AcademicCalendarRootEntry)registration.getDegree().getCalendar());
                registration.getStudent().getPersonalIngressionsDataSet().stream().filter(pid -> pid.getExecutionYear() == currentYear).forEach(pid -> {
                    this.addCell("N\u00ba Aluno", registration.getStudent().getNumber());
                    this.addCell(XlsxExporter.pdiLabel("executionYear"), pid.getExecutionYear().getQualifiedName());
                    this.addCell(XlsxExporter.pidLabel("countryOfResidence"), pid.getCountryOfResidence() != null ? pid.getCountryOfResidence().getName() : "");
                    this.addCell(XlsxExporter.pidLabel("districtSubdivisionOfResidence"), pid.getDistrictSubdivisionOfResidence() != null ? pid.getDistrictSubdivisionOfResidence().getName() : "");
                    this.addCell(XlsxExporter.pidLabel("dislocatedFromPermanentResidence"), pid.getDislocatedFromPermanentResidence() != null ? pid.getDislocatedFromPermanentResidence() : "");
                    this.addCell(XlsxExporter.pidLabel("professionCategoryType"), XlsxExporter.professionCategoryTypeLocalizedName(pid.getProfessionCategoryType()));
                    this.addCell(XlsxExporter.pidLabel("professionalStatusType"), XlsxExporter.professionalStatusTypeLocalizedName(pid.getProfessionalStatusType()));
                    this.addCell(XlsxExporter.pidLabel("motherEducationLevel"), XlsxExporter.educationLevelLocalizedName(pid.getMotherEducationLevelType()));
                    this.addCell(XlsxExporter.pidLabel("motherProfessionCategoryType"), XlsxExporter.professionCategoryTypeLocalizedName(pid.getMotherProfessionCategoryType()));
                    this.addCell(XlsxExporter.pidLabel("motherProfessionalStatusType"), XlsxExporter.professionalStatusTypeLocalizedName(pid.getMotherProfessionalStatusType()));
                    this.addCell(XlsxExporter.pidLabel("fatherEducationLevel"), XlsxExporter.educationLevelLocalizedName(pid.getFatherEducationLevelType()));
                    this.addCell(XlsxExporter.pidLabel("fatherProfessionCategoryType"), XlsxExporter.professionCategoryTypeLocalizedName(pid.getFatherProfessionCategoryType()));
                    this.addCell(XlsxExporter.pidLabel("fatherProfessionalStatusType"), XlsxExporter.professionalStatusTypeLocalizedName(pid.getFatherProfessionalStatusType()));
                });
            }
        };
        ByteArrayOutputStream outputStream = null;
        try {
            outputStream = new ByteArrayOutputStream();
            SpreadsheetBuilderForXLSX spreadsheetBuilder = new SpreadsheetBuilderForXLSX();
            spreadsheetBuilder.addSheet("Informacao Pessoal Complementar", personalIngressionDataSheetData);
            spreadsheetBuilder.addSheet("Graus Precedentes & Informacao Pessoal", precedentDegreeInformationData);
            spreadsheetBuilder.addSheet("Alunos Mobilidade Internacional", mobilidadeInternacionalData);
            spreadsheetBuilder.addSheet("Alunos Diplomados", diplomadoData);
            spreadsheetBuilder.addSheet("Alunos Inscritos", inscritoData);
            spreadsheetBuilder.addSheet("Alunos", identificationData);
            spreadsheetBuilder.build(outputStream);
            byte[] content = outputStream.toByteArray();
            LegalReportResultFile legalReportResultFile = XlsxExporter.writeFile(reportRequest, content);
            return legalReportResultFile;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalArgumentException("error.XlsxExporter.spreadsheet.generation.failed", e);
        }
        finally {
            try {
                outputStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new IllegalArgumentException("error.XlsxExporter.spreadsheet.generation.failed", e);
            }
        }
    }

    private static LegalReportResultFile writeFile(LegalReportRequest legalReportRequest, byte[] byArray) {
        return (LegalReportResultFile)((Object)advice$writeFile.perform((Callable)new XlsxExporter$callable$writeFile(legalReportRequest, byArray)));
    }

    static /* synthetic */ LegalReportResultFile advised$writeFile(LegalReportRequest reportRequest, byte[] content) {
        return new LegalReportResultFile(reportRequest, LegalReportResultFileType.XLSX, content);
    }

    protected static String pdiLabel(String key) {
        return LegalPTUtil.bundle("org.fenixedu.academic.domain.student.PrecedentDegreeInformation." + key, new String[0]);
    }

    protected static String pidLabel(String key) {
        return LegalPTUtil.bundle("label.org.fenixedu.academic.domain.student.PersonalIngressionData." + key, new String[0]);
    }

    protected static String educationLevelLocalizedName(EducationLevelType educationLevelType) {
        return Optional.ofNullable(educationLevelType).map(EducationLevelType_Base::getName).map(LocalizedString::getContent).orElse("");
    }

    protected static String professionCategoryTypeLocalizedName(ProfessionCategoryType professionCategoryType) {
        return Optional.ofNullable(professionCategoryType).map(ProfessionCategoryType_Base::getName).map(LocalizedString::getContent).orElse("");
    }

    protected static String professionalStatusTypeLocalizedName(ProfessionalStatusType professionalStatusType) {
        return Optional.ofNullable(professionalStatusType).map(ProfessionalStatusType_Base::getName).map(LocalizedString::getContent).orElse("");
    }
}

