/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.commons.spreadsheet;

import com.qubit.terra.framework.tools.excel.ExcelUtil;
import com.qubit.terra.framework.tools.excel.XlsType;
import com.qubit.terra.framework.tools.excel.styles.poi.xssf.XCellAlignment;
import com.qubit.terra.framework.tools.excel.styles.poi.xssf.XCellBorder;
import com.qubit.terra.framework.tools.excel.styles.poi.xssf.XCellFillForegroundColor;
import com.qubit.terra.framework.tools.excel.styles.poi.xssf.XCellFillPattern;
import com.qubit.terra.framework.tools.excel.styles.poi.xssf.XCellStyle;
import com.qubit.terra.framework.tools.excel.styles.poi.xssf.XCellVerticalAlignment;
import com.qubit.terra.framework.tools.excel.styles.poi.xssf.XCellWrapText;
import com.qubit.terra.framework.tools.excel.styles.poi.xssf.XComposedCellStyle;
import com.qubit.terra.framework.tools.excel.styles.poi.xssf.XFontColor;
import com.qubit.terra.framework.tools.excel.styles.poi.xssf.XFontHeight;
import com.qubit.terra.framework.tools.excel.styles.poi.xssf.XFontWeight;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.poi.ss.formula.Formula;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.commons.spreadsheet.AbstractSheetBuilder;
import org.fenixedu.commons.spreadsheet.SheetData;
import org.fenixedu.commons.spreadsheet.converters.CellConverter;
import org.fenixedu.commons.spreadsheet.converters.LocalizedStringCellConverter;
import org.fenixedu.commons.spreadsheet.converters.excel.BigDecimalCellConverter;
import org.fenixedu.commons.spreadsheet.converters.excel.IntegerCellConverter;
import org.fenixedu.commons.spreadsheet.converters.xssf.DateTimeCellConverter;
import org.fenixedu.commons.spreadsheet.converters.xssf.LocalDateCellConverter;
import org.fenixedu.commons.spreadsheet.converters.xssf.MultiLanguageStringCellConverter;
import org.fenixedu.commons.spreadsheet.converters.xssf.YearMonthDayCellConverter;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.YearMonthDay;

@Deprecated
class DocxBuilder
extends AbstractSheetBuilder {
    static Map<Class<?>, CellConverter> BASE_CONVERTERS = new HashMap();
    private static XCellStyle HEADER_STYLE;
    private XCellStyle headerStyle;
    int usefulAreaStart;
    int usefulAreaEnd;

    DocxBuilder() {
        this.converters.putAll(BASE_CONVERTERS);
        this.headerStyle = HEADER_STYLE;
    }

    protected void setValue(Workbook book, Cell cell, Object value, short span) {
        this.setValue(book, cell, value, span, null);
    }

    private void setValue(Workbook book, Cell cell, Object value, short span, CellStyle style) {
        if (value != null) {
            Object content = this.convert(value);
            if (content instanceof Boolean) {
                ExcelUtil.setCellValue((Cell)cell, (Boolean)((Boolean)content));
            } else if (content instanceof Double) {
                ExcelUtil.setCellValue((Cell)cell, (Number)((Double)content));
            } else if (content instanceof String) {
                ExcelUtil.setCellValue((Cell)cell, (String)((String)content));
            } else if (content instanceof GregorianCalendar) {
                ExcelUtil.setCellValue((Cell)cell, (Calendar)((GregorianCalendar)content));
            } else if (content instanceof Date) {
                ExcelUtil.setCellValue((Cell)cell, (Date)((Date)content));
            } else if (content instanceof RichTextString) {
                ExcelUtil.setCellValue((Cell)cell, (RichTextString)((RichTextString)content));
            } else if (!(content instanceof Formula)) {
                ExcelUtil.setCellValue((Cell)cell, (String)content.toString());
            }
        } else {
            ExcelUtil.setCellValue((Cell)cell, (String)null);
        }
        if (span > 1) {
            CellRangeAddress region = new CellRangeAddress(cell.getRowIndex(), cell.getRowIndex(), cell.getColumnIndex(), cell.getColumnIndex() + span - 1);
            cell.getSheet().addMergedRegion(region);
        }
        cell.setCellStyle(style);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void build(Map<String, SheetData<?>> sheets, Set<String> sheetNames, OutputStream output) throws IOException {
        try {
            Workbook book = ExcelUtil.createWorkbook((XlsType)XlsType.XLSX);
            XSSFCellStyle xssfHeaderStyle = this.headerStyle.getStyle((XSSFWorkbook)book);
            for (String sheetName : sheetNames) {
                Row row;
                Sheet sheet = book.createSheet(sheetName);
                int rownum = 0;
                int colnum = 0;
                SheetData<?> data = sheets.get(sheetName);
                if (!((List)data.headers.get(0)).isEmpty()) {
                    for (List headerRow : data.headers) {
                        colnum = 0;
                        row = sheet.createRow(rownum++);
                        for (SheetData.Cell cell : headerRow) {
                            this.setValue(book, ExcelUtil.createCell((Row)row, (int)colnum++), cell.value, cell.span, (CellStyle)xssfHeaderStyle);
                            colnum = colnum + cell.span - 1;
                        }
                    }
                }
                this.usefulAreaStart = rownum;
                for (List line : data.matrix) {
                    colnum = 0;
                    row = sheet.createRow(rownum++);
                    for (SheetData.Cell cell : line) {
                        this.setValue(book, ExcelUtil.createCell((Row)row, (int)colnum++), cell.value, cell.span);
                        colnum = colnum + cell.span - 1;
                    }
                }
                this.usefulAreaEnd = rownum - 1;
                if (!data.hasFooter()) continue;
                colnum = 0;
                Row row2 = sheet.createRow(rownum++);
                for (SheetData.Cell cell : data.footer) {
                    this.setValue(book, ExcelUtil.createCell((Row)row2, (int)colnum++), cell.value, cell.span);
                    colnum = colnum + cell.span - 1;
                }
            }
            book.write(output);
        }
        finally {
            output.flush();
            output.close();
        }
    }

    static {
        BASE_CONVERTERS.put(Integer.class, (CellConverter)new IntegerCellConverter());
        BASE_CONVERTERS.put(DateTime.class, new DateTimeCellConverter());
        BASE_CONVERTERS.put(YearMonthDay.class, new YearMonthDayCellConverter());
        BASE_CONVERTERS.put(LocalDate.class, new LocalDateCellConverter());
        BASE_CONVERTERS.put(BigDecimal.class, (CellConverter)new BigDecimalCellConverter());
        BASE_CONVERTERS.put(MultiLanguageStringCellConverter.class, new MultiLanguageStringCellConverter());
        BASE_CONVERTERS.put(LocalizedString.class, (CellConverter)new LocalizedStringCellConverter());
        HEADER_STYLE = new XComposedCellStyle(){
            {
                IndexedColors black = IndexedColors.BLACK;
                IndexedColors gray = IndexedColors.GREY_25_PERCENT;
                this.merge((XCellStyle)new XFontColor(black));
                this.merge((XCellStyle)new XFontWeight(true));
                this.merge((XCellStyle)new XFontHeight(8));
                this.merge((XCellStyle)new XCellAlignment(HorizontalAlignment.CENTER));
                this.merge((XCellStyle)new XCellFillForegroundColor(gray));
                this.merge((XCellStyle)new XCellFillPattern(FillPatternType.SOLID_FOREGROUND));
                this.merge((XCellStyle)new XCellBorder(BorderStyle.THIN));
                this.merge((XCellStyle)new XCellVerticalAlignment(VerticalAlignment.CENTER));
                this.merge((XCellStyle)new XCellWrapText(true));
            }
        };
    }
}

