/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.ulisboa.integration.sas.service.transform;

import com.qubit.terra.framework.tools.excel.ExcelUtil;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFCreationHelper;
import org.apache.poi.hssf.usermodel.HSSFFormulaEvaluator;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.CellValue;
import org.apache.poi.ss.usermodel.Row;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.bennu.core.util.CoreConfiguration;
import org.fenixedu.ulisboa.integration.sas.dto.AbstractScholarshipStudentBean;
import org.joda.time.LocalDate;

public abstract class AbstractScholarshipXlsTransformService {
    private static final String SHEET_NAME = "Dados Academicos";
    private static final String DATE_FORMAT = "dd-MM-yyyy";
    protected List<AbstractScholarshipStudentBean> studentLines;
    protected POIFSFileSystem poifsFileSystem;
    protected AbstractScholarshipStudentBean scholarshipStudentBean;
    protected HSSFWorkbook wb;

    public void readExcelFile() throws IOException {
        this.wb = new HSSFWorkbook(this.poifsFileSystem);
        HSSFSheet sheet = this.wb.getSheet(SHEET_NAME);
        this.checkExcelFormat(sheet);
        this.readStudentLines(sheet);
    }

    public abstract boolean checkExcelFormat(HSSFSheet var1) throws IOException;

    public abstract void readStudentLines(HSSFSheet var1) throws IOException;

    public HSSFWorkbook writeExcelFile(POIFSFileSystem poifsFileSystem) throws IOException {
        HSSFWorkbook wb = new HSSFWorkbook(poifsFileSystem);
        HSSFSheet sheet = wb.getSheet(SHEET_NAME);
        this.writeExcelLines(sheet);
        return wb;
    }

    public abstract void writeExcelLines(HSSFSheet var1) throws IOException;

    public List<AbstractScholarshipStudentBean> getStudentLines() {
        return this.studentLines;
    }

    public void setStudentLines(List<AbstractScholarshipStudentBean> studentLines) {
        this.studentLines = studentLines;
    }

    public POIFSFileSystem getPoifsFileSystem() {
        return this.poifsFileSystem;
    }

    public void setPoifsFileSystem(POIFSFileSystem poifsFileSystem) {
        this.poifsFileSystem = poifsFileSystem;
    }

    public AbstractScholarshipStudentBean getScholarshipStudentBean() {
        return this.scholarshipStudentBean;
    }

    public void setScholarshipStudentBean(AbstractScholarshipStudentBean scholarshipStudentBean) {
        this.scholarshipStudentBean = scholarshipStudentBean;
    }

    public String getValueFromColumnMayBeNull(HSSFRow row, int i) {
        HSSFCell cell = row.getCell((int)((short)i));
        if (cell == null) {
            return "";
        }
        String valueFromColumn = this.getValueFromColumn(row, i);
        return valueFromColumn == null ? "" : valueFromColumn.trim();
    }

    private String getValueFromColumn(HSSFRow row, int i) {
        HSSFFormulaEvaluator evaluator;
        CellValue cellValue;
        if (row.getCell((int)((short)i)).getCellType() == CellType.FORMULA && (cellValue = (evaluator = this.wb.getCreationHelper().createFormulaEvaluator()).evaluate((Cell)row.getCell((int)((short)i)))) != null) {
            switch (cellValue.getCellType()) {
                case BOOLEAN: {
                    return String.valueOf(cellValue.getBooleanValue());
                }
                case NUMERIC: {
                    return String.valueOf(cellValue.getNumberValue());
                }
            }
            return cellValue.getStringValue();
        }
        try {
            return Integer.toString(new Double(row.getCell((int)((short)i)).getNumericCellValue()).intValue());
        }
        catch (NumberFormatException e) {
            return row.getCell((int)((short)i)).getStringCellValue();
        }
        catch (IllegalStateException e) {
            return row.getCell((int)((short)i)).getStringCellValue();
        }
    }

    public void writeCellBigDecimal(HSSFRow row, int column, BigDecimal value) {
        AbstractScholarshipXlsTransformService.createNumberCell(row, column, value);
    }

    public void writeCellInteger(HSSFRow row, int column, Integer value) {
        AbstractScholarshipXlsTransformService.createNumberCell(row, column, value);
    }

    private static void createNumberCell(HSSFRow row, int column, Number value) {
        if (value != null) {
            ExcelUtil.createCellWithValue((Row)row, (int)column, (Number)value);
        } else {
            ExcelUtil.createCellWithValue((Row)row, (int)column, (Number)null);
        }
    }

    public void writeCellBoolean(HSSFRow row, int column, Boolean value) {
        String toWrite;
        if (value == null) {
            toWrite = null;
        } else {
            String key = value != false ? "label.yes" : "label.no";
            toWrite = BundleUtil.getString((String)"resources/SasResources", (String)CoreConfiguration.getConfiguration().defaultLocale(), (String[])new String[]{key});
        }
        this.writeCellString(row, column, toWrite);
    }

    public void writeCellString(HSSFRow row, int column, String value) {
        ExcelUtil.createCellWithValue((Row)row, (int)column, (String)value);
    }

    public void writeCellLocalDate(HSSFRow row, int column, LocalDate date) {
        this.writeCellDate(row, column, date != null ? date.toDateMidnight().toDate() : null, DATE_FORMAT);
    }

    private void writeCellDate(HSSFRow row, int column, Date date, String dateFormat) {
        if (date != null) {
            Cell cell = ExcelUtil.createCellWithValue((Row)row, (int)column, (Date)date);
            HSSFWorkbook workbook = row.getSheet().getWorkbook();
            HSSFCreationHelper createHelper = workbook.getCreationHelper();
            HSSFCellStyle cellStyle = workbook.createCellStyle();
            cellStyle.setDataFormat(createHelper.createDataFormat().getFormat(dateFormat));
            cell.setCellStyle((CellStyle)cellStyle);
        } else {
            ExcelUtil.createCellWithValue((Row)row, (int)column, (Date)null);
        }
    }

    protected String booleanToString(Boolean value) {
        if (value == null) {
            value = false;
        }
        return value != false ? "Sim" : "N\u00e3o";
    }

    protected String toMonthString(int monthOfYear) {
        Calendar cal = Calendar.getInstance();
        cal.set(2, monthOfYear - 1);
        return cal.getDisplayName(2, 2, Locale.forLanguageTag("pt-PT"));
    }
}

