/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.legalpt.dto.a3es;

import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.legalpt.dto.a3es.A3esBeanField;
import org.fenixedu.legalpt.services.a3es.process.A3esExportService;

public abstract class A3esAbstractBean
implements Serializable {
    private static AtomicLong beanIdSeed = new AtomicLong(1L);
    public static Comparator<A3esAbstractBean> COMPARE_BY_ID = new Comparator<A3esAbstractBean>(){

        @Override
        public int compare(A3esAbstractBean bean1, A3esAbstractBean bean2) {
            return bean1.getId().compareTo(bean2.getId());
        }
    };
    private final Long beanId;
    private final List<A3esBeanField> fields = Lists.newArrayList();

    public A3esAbstractBean() {
        this.beanId = A3esAbstractBean.generateId();
    }

    public Long getId() {
        return (long)this.beanId;
    }

    public String getFormattedId() {
        return String.format("%d", this.beanId);
    }

    private static Long generateId() {
        return beanIdSeed.getAndIncrement();
    }

    public List<A3esBeanField> getFields() {
        return this.fields;
    }

    public A3esBeanField getFieldUnique(String id) {
        return this.getField(id).stream().findFirst().orElse(null);
    }

    public List<A3esBeanField> getField(String id) {
        return this.fields.stream().filter(i -> StringUtils.equalsIgnoreCase((String)i.getId(), (String)id)).collect(Collectors.toList());
    }

    public A3esBeanField addField(String id, String fieldName, Locale locale, LocalizedString source, int limit) {
        A3esBeanField result = A3esBeanField.create(id, fieldName, locale, source, limit);
        this.getFields().add(result);
        return result;
    }

    public A3esBeanField addField(String id, String fieldName, LocalizedString source, int limit) {
        return this.addField(id, fieldName, source == null ? null : source.getContent(A3esExportService.PT), limit);
    }

    public A3esBeanField addField(String id, String fieldName, String source, int limit) {
        A3esBeanField result = A3esBeanField.create(id, fieldName, source, limit);
        this.getFields().add(result);
        return result;
    }
}

