/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.legalpt.services.rebides.process;

import org.fenixedu.academic.domain.Qualification;
import org.fenixedu.academic.domain.SchoolLevelType;
import org.fenixedu.academic.domain.Teacher;
import org.fenixedu.academic.domain.organizationalStructure.Unit;
import org.fenixedu.academic.domain.raides.DegreeDesignation;
import org.fenixedu.legalpt.domain.LegalReportContext;
import org.fenixedu.legalpt.domain.mapping.LegalMapping;
import org.fenixedu.legalpt.domain.rebides.RebidesReportEntryTarget;
import org.fenixedu.legalpt.domain.rebides.mapping.RebidesMappingType;
import org.fenixedu.legalpt.domain.report.LegalReport;
import org.fenixedu.legalpt.dto.rebides.QualificationBean;
import org.fenixedu.legalpt.services.rebides.process.RebidesService;
import pt.ist.fenixframework.DomainObject;

public class QualificationService {
    private final Teacher teacher;
    private final Qualification qualification;
    private LegalReport report;

    public QualificationService(LegalReport report, Teacher teacher, Qualification qualification) {
        this.report = report;
        this.teacher = teacher;
        this.qualification = qualification;
    }

    public QualificationBean getQualificationData() {
        QualificationBean bean = new QualificationBean();
        this.fillSchoolLevel(bean);
        this.fillSchoolLevelDegree(bean);
        this.fillInstituition(bean);
        this.fillOtherInstituition(bean);
        this.fillDegree(bean);
        this.fillOtherDegree(bean);
        this.fillExpertiseArea(bean);
        this.fillOtherExpertiseArea(bean);
        this.fillScientificArea(bean);
        return bean;
    }

    private void fillSchoolLevel(QualificationBean bean) {
        if (this.getQualificationSchoolLevel() != null) {
            if (LegalMapping.find(this.report, RebidesMappingType.SCHOOL_LEVEL).translate((Enum<?>)this.getQualificationSchoolLevel()) != null) {
                bean.setSchoolLevel(LegalMapping.find(this.report, RebidesMappingType.SCHOOL_LEVEL).translate((Enum<?>)this.getQualificationSchoolLevel()));
            } else {
                LegalReportContext.addError(RebidesReportEntryTarget.of(this.teacher), RebidesService.createMissingMappingMessage("label.schoolLevel", this.getQualificationSchoolLevel().getLocalizedName()));
            }
        } else {
            LegalReportContext.addError(RebidesReportEntryTarget.of(this.teacher), RebidesService.createMissingFieldMessage("label.schoolLevel"));
        }
    }

    private void fillSchoolLevelDegree(QualificationBean bean) {
        if (this.getQualificationSchoolLevelOrigin() != null) {
            if (LegalMapping.find(this.report, RebidesMappingType.SCHOOL_LEVEL_ORIGIN).translate(this.getQualificationSchoolLevelOrigin()) != null) {
                bean.setSchoolLevelOrigin(LegalMapping.find(this.report, RebidesMappingType.SCHOOL_LEVEL_ORIGIN).translate(this.getQualificationSchoolLevelOrigin()));
            } else {
                LegalReportContext.addError(RebidesReportEntryTarget.of(this.teacher), RebidesService.createMissingMappingMessage("label.schoolLevelOrigin", this.getQualificationSchoolLevelOrigin()));
            }
        } else {
            LegalReportContext.addError(RebidesReportEntryTarget.of(this.teacher), RebidesService.createMissingFieldMessage("label.schoolLevelType"));
        }
    }

    private void fillInstituition(QualificationBean bean) {
        if (this.getQualificationInstitution() != null) {
            if (this.getQualificationInstitution().getCode() != null) {
                bean.setInstituition(this.getQualificationInstitution().getCode());
            } else {
                bean.setInstituition("0000");
            }
        } else {
            LegalReportContext.addError(RebidesReportEntryTarget.of(this.teacher), RebidesService.createMissingFieldMessage("label.degreeInstitution"));
        }
    }

    private void fillOtherInstituition(QualificationBean bean) {
        if (bean.getInstituition() != null && bean.getInstituition().equals("0000")) {
            String otherInstitution;
            String string = otherInstitution = this.getQualificationInstitution() != null ? this.getQualificationInstitution().getName() : "";
            if (RebidesService.validateMaxFieldSize(this.teacher, "label.otherInstitution", otherInstitution, RebidesService.LIMIT_160CHARS).booleanValue()) {
                bean.setOtherInstituition(otherInstitution);
            }
        }
    }

    private void fillDegree(QualificationBean bean) {
        if (this.qualification.getDegree() != null) {
            if (this.qualification.getCountry().isDefaultCountry() && this.getQualificationDegreeDesignation() != null && this.getQualificationDegreeDesignation().getCode() != null) {
                bean.setDegree(this.getQualificationDegreeDesignation().getCode());
            } else {
                bean.setDegree("0000");
            }
        } else {
            LegalReportContext.addError(RebidesReportEntryTarget.of(this.teacher), RebidesService.createMissingFieldMessage("label.degree"));
        }
    }

    private void fillOtherDegree(QualificationBean bean) {
        String otherDegree;
        if (bean.getDegree() != null && bean.getDegree().equals("0000") && RebidesService.validateMaxFieldSize(this.teacher, "label.degreeOther", otherDegree = this.qualification.getDegree(), RebidesService.LIMIT_160CHARS).booleanValue()) {
            bean.setOtherDegree(otherDegree);
            return;
        }
    }

    private void fillExpertiseArea(QualificationBean bean) {
        if (this.qualification.getCountry() != null && this.qualification.getCountry().isDefaultCountry() && this.getQualificationSchoolLevel() != null && this.getQualificationSchoolLevel().isHigherEducation()) {
            bean.setExpertiseArea("00");
        } else {
            bean.setExpertiseArea("99");
        }
    }

    private void fillOtherExpertiseArea(QualificationBean bean) {
        if (bean.getExpertiseArea() != null && bean.getExpertiseArea().equals("00")) {
            bean.setOtherExpertiseArea(RebidesService.i18n("rebides.info.not.applicable", new String[0]));
        }
    }

    private void fillScientificArea(QualificationBean bean) {
        if (this.getQualificationScientificAreaUnit() != null) {
            if (LegalMapping.find(this.report, RebidesMappingType.SCIENTIFIC_AREA).translate((DomainObject)this.getQualificationScientificAreaUnit()) != null) {
                bean.setScientificArea(LegalMapping.find(this.report, RebidesMappingType.SCIENTIFIC_AREA).translate((DomainObject)this.getQualificationScientificAreaUnit()));
            } else {
                LegalReportContext.addError(RebidesReportEntryTarget.of(this.teacher), RebidesService.createMissingMappingMessage("label.scientificArea", this.getQualificationScientificAreaUnit().getName()));
            }
        } else {
            LegalReportContext.addError(RebidesReportEntryTarget.of(this.teacher), RebidesService.createMissingFieldMessage("label.scientificArea"));
        }
    }

    private SchoolLevelType getQualificationSchoolLevel() {
        return null;
    }

    private String getQualificationSchoolLevelOrigin() {
        return null;
    }

    private Unit getQualificationInstitution() {
        return null;
    }

    private DegreeDesignation getQualificationDegreeDesignation() {
        return null;
    }

    private Unit getQualificationScientificAreaUnit() {
        return null;
    }

    public static class Institution {
        public static final String OTHER = "0000";
        public static final String NOT_DEFINED = "9999";
    }

    public static class Degree {
        public static final String OTHER = "0000";
        public static final String NOT_DEFINED = "9999";
    }

    public static class ExpertiseArea {
        public static final String OTHER = "00";
        public static final String NOT_DEFINED = "99";
    }
}

