/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.commons.spreadsheet.styles.xssf;

import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.fenixedu.commons.spreadsheet.styles.xssf.XCellStyle;

public class XFontHeight
extends XCellStyle {
    private final short height;

    public XFontHeight(short height) {
        this.height = height;
    }

    @Override
    protected void appendToStyle(XSSFWorkbook book, XSSFCellStyle style, XSSFFont font) {
        font.setFontHeightInPoints(this.height);
    }

    @Override
    public XSSFCellStyle getStyle(XSSFWorkbook book) {
        XSSFCellStyle style = book.createCellStyle();
        XSSFFont font = book.createFont();
        this.appendToStyle(book, style, font);
        style.setFont((Font)font);
        return style;
    }

    public boolean equals(Object obj) {
        if (obj instanceof XFontHeight) {
            XFontHeight fontHeight = (XFontHeight)obj;
            return this.height == fontHeight.height;
        }
        return false;
    }

    public int hashCode() {
        return this.height;
    }
}

